/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.ws.jaxb;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.openecard.ws.jaxb.MarshallerImpl;
import org.openecard.ws.marshal.MarshallingTypeException;
import org.openecard.ws.marshal.WSMarshaller;
import org.openecard.ws.marshal.WSMarshallerException;
import org.openecard.ws.marshal.WhitespaceFilter;
import org.openecard.ws.soap.MessageFactory;
import org.openecard.ws.soap.SOAPBody;
import org.openecard.ws.soap.SOAPException;
import org.openecard.ws.soap.SOAPMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class JAXBMarshaller
implements WSMarshaller {
    private static final Logger LOG = LoggerFactory.getLogger(JAXBMarshaller.class);
    private final MarshallerImpl marshaller;
    private final DocumentBuilderFactory w3Factory;
    private final DocumentBuilder w3Builder;
    private final Transformer serializer;
    private final MessageFactory soapFactory;

    public JAXBMarshaller() {
        MessageFactory tmpSoapFactory;
        Transformer tmpSerializer;
        DocumentBuilder tmpW3Builder;
        DocumentBuilderFactory tmpW3Factory;
        MarshallerImpl tmpMarshaller;
        try {
            tmpMarshaller = new MarshallerImpl();
            tmpW3Factory = DocumentBuilderFactory.newInstance();
            tmpW3Factory.setNamespaceAware(true);
            tmpW3Factory.setIgnoringComments(true);
            tmpW3Factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            tmpW3Factory.setExpandEntityReferences(false);
            tmpW3Factory.setXIncludeAware(false);
            tmpW3Factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            try {
                tmpW3Factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                // empty catch block
            }
            tmpW3Factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            tmpW3Factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            tmpW3Builder = tmpW3Factory.newDocumentBuilder();
            TransformerFactory tfactory = TransformerFactory.newInstance();
            tfactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            tfactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            tfactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            try {
                tfactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                // empty catch block
            }
            tmpSerializer = tfactory.newTransformer();
            tmpSerializer.setOutputProperty("indent", "yes");
            tmpSerializer.setOutputProperty("standalone", "yes");
            tmpSerializer.setOutputProperty("encoding", "UTF-8");
            tmpSerializer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            tmpSoapFactory = MessageFactory.newInstance();
        }
        catch (IllegalArgumentException | ParserConfigurationException | TransformerConfigurationException | SOAPException ex) {
            LOG.error("Failed to initialize XML components.", ex);
            System.exit(1);
            throw new RuntimeException("Failed to initialize marshaller.", ex);
        }
        this.marshaller = tmpMarshaller;
        this.w3Factory = tmpW3Factory;
        this.w3Builder = tmpW3Builder;
        this.serializer = tmpSerializer;
        this.soapFactory = tmpSoapFactory;
    }

    @Override
    public void addXmlTypeClass(Class<?> xmlTypeClass) throws MarshallingTypeException {
        this.marshaller.addXmlClass(xmlTypeClass);
    }

    @Override
    public void removeAllTypeClasses() {
        this.marshaller.removeAllClasses();
    }

    @Override
    public synchronized Document str2doc(String docStr) throws SAXException {
        try {
            StringReader strReader = new StringReader(docStr);
            InputSource inSrc = new InputSource(strReader);
            Document doc = this.w3Builder.parse(inSrc);
            WhitespaceFilter.filter(doc);
            return doc;
        }
        catch (IOException ex) {
            throw new SAXException(ex);
        }
    }

    @Override
    public synchronized Document str2doc(InputStream docStr) throws SAXException, IOException {
        Document doc = this.w3Builder.parse(docStr);
        WhitespaceFilter.filter(doc);
        return doc;
    }

    @Override
    public synchronized String doc2str(Node doc) throws TransformerException {
        String result;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.serializer.transform(new DOMSource(doc), new StreamResult(out));
        try {
            result = out.toString("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new TransformerException(ex);
        }
        return result;
    }

    @Override
    public synchronized Object unmarshal(Node n) throws MarshallingTypeException, WSMarshallerException {
        Object result;
        Document newDoc = this.createDoc(n);
        try {
            result = this.marshaller.getUnmarshaller().unmarshal((Node)newDoc);
        }
        catch (JAXBException ex) {
            throw new MarshallingTypeException(ex);
        }
        return result;
    }

    @Override
    public synchronized <T> JAXBElement<T> unmarshal(Node n, Class<T> c) throws MarshallingTypeException, WSMarshallerException {
        JAXBElement result;
        Document newDoc = this.createDoc(n);
        try {
            result = this.marshaller.getUnmarshaller().unmarshal((Node)newDoc, c);
        }
        catch (JAXBException ex) {
            throw new MarshallingTypeException(ex);
        }
        return result;
    }

    private Document createDoc(Node n) throws WSMarshallerException {
        Document newDoc = null;
        if (n instanceof Document) {
            newDoc = (Document)n;
        } else if (n instanceof Element) {
            newDoc = this.w3Builder.newDocument();
            Node root = newDoc.importNode(n, true);
            newDoc.appendChild(root);
        } else {
            throw new WSMarshallerException("Only w3c Document and Element are accepted.");
        }
        return newDoc;
    }

    @Override
    public synchronized Document marshal(Object o) throws MarshallingTypeException {
        try {
            Document d = this.w3Builder.newDocument();
            this.marshaller.getMarshaller().marshal(o, (Node)d);
            return d;
        }
        catch (JAXBException ex) {
            throw new MarshallingTypeException(ex);
        }
    }

    @Override
    public synchronized SOAPMessage doc2soap(Document envDoc) throws SOAPException {
        SOAPMessage msg = this.soapFactory.createMessage(envDoc);
        return msg;
    }

    @Override
    public synchronized SOAPMessage add2soap(Document content) throws SOAPException {
        SOAPMessage msg = this.soapFactory.createMessage();
        SOAPBody body = msg.getSOAPBody();
        body.addDocument(content);
        return msg;
    }
}

