/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.transport.paos;

import iso.std.iso_iec._24727.tech.schema.StartPAOS;
import iso.std.iso_iec._24727.tech.schema.StartPAOSResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import javax.annotation.Nonnull;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import org.openecard.binding.tctoken.TlsConnectionHandler;
import org.openecard.binding.tctoken.ex.ErrorTranslations;
import org.openecard.bouncycastle.tls.TlsClientProtocol;
import org.openecard.common.I18nKey;
import org.openecard.common.interfaces.Dispatcher;
import org.openecard.common.interfaces.DispatcherException;
import org.openecard.transport.httpcore.StreamHttpClientConnection;
import org.openecard.transport.paos.MessageIdGenerator;
import org.openecard.transport.paos.PAOSConnectionException;
import org.openecard.transport.paos.PAOSException;
import org.openecard.ws.marshal.MarshallingTypeException;
import org.openecard.ws.marshal.WSMarshaller;
import org.openecard.ws.marshal.WSMarshallerException;
import org.openecard.ws.marshal.WSMarshallerFactory;
import org.openecard.ws.soap.SOAPException;
import org.openecard.ws.soap.SOAPHeader;
import org.openecard.ws.soap.SOAPMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class PAOS {
    private static final Logger LOG = LoggerFactory.getLogger(PAOS.class);
    public static final String HEADER_KEY_PAOS = "PAOS";
    public static final QName RELATES_TO = new QName("http://www.w3.org/2005/03/addressing", "RelatesTo");
    public static final QName REPLY_TO = new QName("http://www.w3.org/2005/03/addressing", "ReplyTo");
    public static final QName MESSAGE_ID = new QName("http://www.w3.org/2005/03/addressing", "MessageID");
    public static final QName ADDRESS = new QName("http://www.w3.org/2005/03/addressing", "Address");
    public static final QName PAOS_PAOS = new QName("urn:liberty:paos:2006-08", "PAOS");
    public static final QName PAOS_VERSION = new QName("urn:liberty:paos:2006-08", "Version");
    public static final QName PAOS_ENDPOINTREF = new QName("urn:liberty:paos:2006-08", "EndpointReference");
    public static final QName PAOS_ADDRESS = new QName("urn:liberty:paos:2006-08", "Address");
    public static final QName PAOS_METADATA = new QName("urn:liberty:paos:2006-08", "MetaData");
    public static final QName PAOS_SERVICETYPE = new QName("urn:liberty:paos:2006-08", "ServiceType");
    private final String headerValuePaos;
    private final MessageIdGenerator idGenerator;
    private final WSMarshaller m;
    private final Dispatcher dispatcher;
    private final TlsConnectionHandler tlsHandler;
    private final String serviceString;

    public PAOS(@Nonnull Dispatcher dispatcher, @Nonnull TlsConnectionHandler tlsHandler) throws PAOSException {
        this.dispatcher = dispatcher.getFilter();
        this.tlsHandler = tlsHandler;
        this.serviceString = this.buildServiceString();
        this.headerValuePaos = String.format("ver=\"%s\" %s", "urn:liberty:paos:2006-08", this.serviceString);
        try {
            this.idGenerator = new MessageIdGenerator();
            this.m = WSMarshallerFactory.createInstance();
        }
        catch (WSMarshallerException ex) {
            LOG.error(ex.getMessage(), ex);
            throw new PAOSException(ex);
        }
    }

    private String getRelatesTo(SOAPMessage msg) throws SOAPException {
        return this.getHeaderElement(msg, RELATES_TO);
    }

    private void setRelatesTo(SOAPMessage msg, String value) throws SOAPException {
        Element elem = this.getHeaderElement(msg, RELATES_TO, true);
        elem.setTextContent(value);
    }

    private String getHeaderElement(SOAPMessage msg, QName elem) throws SOAPException {
        Element headerElem = this.getHeaderElement(msg, elem, false);
        return headerElem == null ? null : headerElem.getTextContent().trim();
    }

    private Element getHeaderElement(SOAPMessage msg, QName elem, boolean create) throws SOAPException {
        Element result = null;
        SOAPHeader h = msg.getSOAPHeader();
        for (Element e : h.getChildElements()) {
            if (!e.getLocalName().equals(elem.getLocalPart()) || !e.getNamespaceURI().equals(elem.getNamespaceURI())) continue;
            result = e;
            break;
        }
        if (result == null && create) {
            result = h.addHeaderElement(elem);
        }
        return result;
    }

    private void addMessageIDs(SOAPMessage msg) throws SOAPException {
        String otherID = this.idGenerator.getRemoteID();
        String newID = this.idGenerator.createNewID();
        if (otherID != null) {
            this.setRelatesTo(msg, otherID);
        }
        this.setMessageID(msg, newID);
    }

    private void updateMessageID(SOAPMessage msg) throws PAOSException {
        try {
            String id = this.getMessageID(msg);
            if (id == null) {
                throw new PAOSException((I18nKey)ErrorTranslations.NO_MESSAGE_ID, new Object[0]);
            }
            if (!this.idGenerator.setRemoteID(id)) {
                throw new PAOSException((I18nKey)ErrorTranslations.MESSAGE_ID_MISSMATCH, new Object[0]);
            }
        }
        catch (SOAPException e) {
            LOG.error(e.getMessage(), e);
            throw new PAOSException(e.getMessage(), e);
        }
    }

    private String getMessageID(SOAPMessage msg) throws SOAPException {
        return this.getHeaderElement(msg, MESSAGE_ID);
    }

    private void setMessageID(SOAPMessage msg, String value) throws SOAPException {
        Element elem = this.getHeaderElement(msg, MESSAGE_ID, true);
        elem.setTextContent(value);
    }

    private Object processPAOSRequest(InputStream content) throws PAOSException {
        try {
            Document doc = this.m.str2doc(content);
            SOAPMessage msg = this.m.doc2soap(doc);
            this.updateMessageID(msg);
            if (LOG.isDebugEnabled()) {
                try {
                    LOG.debug("Message received:\n{}", (Object)this.m.doc2str(doc));
                }
                catch (TransformerException ex) {
                    LOG.warn("Failed to log PAOS request message.", ex);
                }
            }
            return this.m.unmarshal(msg.getSOAPBody().getChildElements().get(0));
        }
        catch (MarshallingTypeException ex) {
            LOG.error(ex.getMessage(), ex);
            throw new PAOSException(ex.getMessage(), ex);
        }
        catch (WSMarshallerException ex) {
            String msg = "Failed to read/process message from PAOS server.";
            LOG.error(msg, ex);
            throw new PAOSException((I18nKey)ErrorTranslations.MARSHALLING_ERROR, (Throwable)ex, new Object[0]);
        }
        catch (IOException | SAXException ex) {
            String msg = "Failed to read/process message from PAOS server.";
            LOG.error(msg, ex);
            throw new PAOSException((I18nKey)ErrorTranslations.SOAP_MESSAGE_FAILURE, (Throwable)ex, new Object[0]);
        }
    }

    private String createPAOSResponse(Object obj) throws MarshallingTypeException, SOAPException, TransformerException {
        SOAPMessage msg = this.createSOAPMessage(obj);
        String result = this.m.doc2str(msg.getDocument());
        LOG.debug("Message sent:\n{}", (Object)result);
        return result;
    }

    private SOAPMessage createSOAPMessage(Object content) throws MarshallingTypeException, SOAPException {
        Document contentDoc = this.m.marshal(content);
        SOAPMessage msg = this.m.add2soap(contentDoc);
        SOAPHeader header = msg.getSOAPHeader();
        Element paos = header.addHeaderElement(PAOS_PAOS);
        paos.setAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "actor", "http://schemas.xmlsoap.org/soap/actor/next");
        paos.setAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "mustUnderstand", "1");
        Element version = header.addChildElement(paos, PAOS_VERSION);
        version.setTextContent("urn:liberty:paos:2006-08");
        Element endpointReference = header.addChildElement(paos, PAOS_ENDPOINTREF);
        Element address = header.addChildElement(endpointReference, PAOS_ADDRESS);
        address.setTextContent("http://www.projectliberty.org/2006/01/role/paos");
        Element metaData = header.addChildElement(endpointReference, PAOS_METADATA);
        Element serviceType = header.addChildElement(metaData, PAOS_SERVICETYPE);
        serviceType.setTextContent("http://www.bsi.bund.de/ecard/api/1.1/PAOS/GetNextCommand");
        Element replyTo = header.addHeaderElement(REPLY_TO);
        address = header.addChildElement(replyTo, ADDRESS);
        address.setTextContent("http://www.projectliberty.org/2006/02/role/paos");
        this.addMessageIDs(msg);
        return msg;
    }

    /*
     * Exception decompiling
     */
    public StartPAOSResponse sendStartPAOS(StartPAOS message) throws DispatcherException, PAOSException, PAOSConnectionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [21[DOLOOP]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private StreamHttpClientConnection openHttpStream() throws PAOSConnectionException {
        try {
            LOG.debug("Opening connection to PAOS server.");
            TlsClientProtocol handler = this.tlsHandler.createTlsConnection();
            StreamHttpClientConnection conn = new StreamHttpClientConnection(handler.getInputStream(), handler.getOutputStream());
            LOG.debug("Connection to PAOS server established.");
            return conn;
        }
        catch (IOException | URISyntaxException ex) {
            throw new PAOSConnectionException(ex);
        }
    }

    private void checkHTTPStatusCode(int statusCode) throws PAOSConnectionException {
        if (statusCode != 200 && statusCode != 202) {
            throw new PAOSConnectionException(ErrorTranslations.INVALID_HTTP_STATUS, statusCode);
        }
        if (statusCode == 200) {
            String msg2 = "The PAOS endpoint sent the http status code 200 which does not conform to the PAOS specification. (See section 9.4 Processing Rules of the PAOS Specification)";
            LOG.warn(msg2);
        }
    }

    private String buildServiceString() {
        StringBuilder builder = new StringBuilder();
        for (String service : this.dispatcher.getServiceList()) {
            builder.append(";");
            builder.append('\"');
            builder.append(service);
            builder.append('\"');
        }
        return builder.toString();
    }
}

