/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.scio;

import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.NoSuchAlgorithmException;
import javax.smartcardio.CardTerminals;
import org.openecard.common.ifd.scio.SCIOTerminals;
import org.openecard.common.ifd.scio.TerminalFactory;
import org.openecard.common.util.LinuxLibraryFinder;
import org.openecard.scio.PCSCTerminals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PCSCFactory
implements TerminalFactory {
    private static final Logger LOG = LoggerFactory.getLogger(PCSCFactory.class);
    private static final String ALGORITHM = "PC/SC";
    private final String osName = System.getProperty("os.name");
    private javax.smartcardio.TerminalFactory terminalFactory;

    public PCSCFactory() throws FileNotFoundException, NoSuchAlgorithmException {
        if (this.osName.startsWith("Linux")) {
            File libFile = LinuxLibraryFinder.getLibraryPath("pcsclite", "1");
            System.setProperty("sun.security.smartcardio.library", libFile.getAbsolutePath());
        }
        this.loadPCSC();
    }

    @Override
    public String getType() {
        return this.terminalFactory.getType();
    }

    @Override
    public SCIOTerminals terminals() {
        return new PCSCTerminals(this);
    }

    javax.smartcardio.TerminalFactory getRawFactory() {
        return this.terminalFactory;
    }

    private static Integer versionCompare(String str1, String str2) {
        int i;
        String[] vals1 = str1.split("\\.");
        String[] vals2 = str2.split("\\.");
        for (i = 0; i < vals1.length && i < vals2.length && vals1[i].equals(vals2[i]); ++i) {
        }
        if (i < vals1.length && i < vals2.length) {
            return Integer.signum(Integer.valueOf(vals1[i]).compareTo(Integer.valueOf(vals2[i])));
        }
        return Integer.signum(vals1.length - vals2.length);
    }

    final void loadPCSC() throws NoSuchAlgorithmException {
        this.terminalFactory = javax.smartcardio.TerminalFactory.getInstance(ALGORITHM, null);
    }

    void reloadPCSC() {
        try {
            Class<?> pcscterminal = Class.forName("sun.security.smartcardio.PCSCTerminals");
            Field contextId = pcscterminal.getDeclaredField("contextId");
            contextId.setAccessible(true);
            if (contextId.getLong(pcscterminal) != 0L) {
                Class<?> pcsc = Class.forName("sun.security.smartcardio.PCSC");
                Method SCardEstablishContext = pcsc.getDeclaredMethod("SCardEstablishContext", Integer.TYPE);
                SCardEstablishContext.setAccessible(true);
                Field SCARD_SCOPE_USER = pcsc.getDeclaredField("SCARD_SCOPE_USER");
                SCARD_SCOPE_USER.setAccessible(true);
                long newId = (Long)SCardEstablishContext.invoke(pcsc, SCARD_SCOPE_USER.getInt(pcsc));
                contextId.setLong(pcscterminal, newId);
                this.loadPCSC();
                CardTerminals terminals = this.terminalFactory.terminals();
                Field fieldTerminals = pcscterminal.getDeclaredField("terminals");
                fieldTerminals.setAccessible(true);
                Class<?> classMap = Class.forName("java.util.Map");
                Method clearMap = classMap.getDeclaredMethod("clear", new Class[0]);
                clearMap.invoke(fieldTerminals.get(terminals), new Object[0]);
            }
        }
        catch (NoSuchAlgorithmException ex) {
            String msg = "PCSC changed it's algorithm. There is something really wrong.";
            LOG.error(msg, ex);
            throw new RuntimeException("PCSC changed it's algorithm. There is something really wrong.");
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            LOG.error("Failed to perform reflection magic to reload TerminalFactory.", ex);
        }
    }
}

