/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.sal.protocol.genericcryptography;

import iso.std.iso_iec._24727.tech.schema.CardCallTemplateType;
import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import iso.std.iso_iec._24727.tech.schema.CryptographicServiceActionName;
import iso.std.iso_iec._24727.tech.schema.DIDScopeType;
import iso.std.iso_iec._24727.tech.schema.DIDStructureType;
import iso.std.iso_iec._24727.tech.schema.HashGenerationInfoType;
import iso.std.iso_iec._24727.tech.schema.LegacySignatureGenerationType;
import iso.std.iso_iec._24727.tech.schema.Sign;
import iso.std.iso_iec._24727.tech.schema.SignResponse;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.openecard.addon.sal.FunctionType;
import org.openecard.addon.sal.ProtocolStep;
import org.openecard.bouncycastle.util.Arrays;
import org.openecard.common.ECardException;
import org.openecard.common.WSHelper;
import org.openecard.common.apdu.GetResponse;
import org.openecard.common.apdu.InternalAuthenticate;
import org.openecard.common.apdu.ManageSecurityEnvironment;
import org.openecard.common.apdu.common.APDUTemplateException;
import org.openecard.common.apdu.common.BaseTemplateContext;
import org.openecard.common.apdu.common.CardCommandAPDU;
import org.openecard.common.apdu.common.CardCommandTemplate;
import org.openecard.common.apdu.common.CardResponseAPDU;
import org.openecard.common.apdu.exception.APDUException;
import org.openecard.common.apdu.utils.SALErrorUtils;
import org.openecard.common.interfaces.Dispatcher;
import org.openecard.common.sal.Assert;
import org.openecard.common.sal.exception.IncorrectParameterException;
import org.openecard.common.sal.state.CardStateEntry;
import org.openecard.common.sal.util.SALUtils;
import org.openecard.common.tlv.TLV;
import org.openecard.common.tlv.TLVException;
import org.openecard.common.util.ByteUtils;
import org.openecard.crypto.common.sal.did.CryptoMarkerType;
import org.openecard.sal.protocol.genericcryptography.apdu.PSOComputeDigitalSignature;
import org.openecard.sal.protocol.genericcryptography.apdu.PSOHash;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignStep
implements ProtocolStep<Sign, SignResponse> {
    private static final Logger LOG = LoggerFactory.getLogger(SignStep.class);
    private static final byte BLOCKSIZE = 0;
    private static final byte SET_COMPUTATION = 65;
    private static final byte KEY_REFERENCE_PRIVATE_KEY = -124;
    private static final byte CARD_ALG_REF = -128;
    private static final String HASH_TO_SIGN = "hashToSign";
    private static final String KEY_REFERENCE = "keyReference";
    private static final String ALGORITHM_IDENTIFIER = "algorithmIdentifier";
    private static final String HASHALGORITHM_REFERENCE = "hashAlgorithmReference";
    private final Dispatcher dispatcher;

    public SignStep(Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    @Override
    public FunctionType getFunctionType() {
        return FunctionType.Sign;
    }

    @Override
    public SignResponse perform(Sign sign, Map<String, Object> internalData) {
        SignResponse response = (SignResponse)WSHelper.makeResponse(SignResponse.class, WSHelper.makeResultOK());
        try {
            ConnectionHandleType connectionHandle = SALUtils.getConnectionHandle(sign);
            String didName = SALUtils.getDIDName(sign);
            CardStateEntry cardStateEntry = SALUtils.getCardStateEntry(internalData, connectionHandle);
            DIDStructureType didStructure = SALUtils.getDIDStructure(sign, didName, cardStateEntry, connectionHandle);
            CryptoMarkerType cryptoMarker = new CryptoMarkerType(didStructure.getDIDMarker());
            byte[] slotHandle = connectionHandle.getSlotHandle();
            byte[] applicationID = connectionHandle.getCardApplication();
            Assert.securityConditionDID(cardStateEntry, applicationID, didName, CryptographicServiceActionName.SIGN);
            byte[] message = sign.getMessage();
            byte[] keyReference = cryptoMarker.getCryptoKeyInfo().getKeyRef().getKeyRef();
            byte[] algorithmIdentifier = cryptoMarker.getAlgorithmInfo().getCardAlgRef();
            byte[] hashRef = cryptoMarker.getAlgorithmInfo().getHashAlgRef();
            HashGenerationInfoType hashInfo = cryptoMarker.getHashGenerationInfo();
            if (didStructure.getDIDScope() == DIDScopeType.LOCAL) {
                keyReference[0] = (byte)(0x80 | keyReference[0]);
            }
            if (cryptoMarker.getSignatureGenerationInfo() != null) {
                response = this.performSignature(cryptoMarker, keyReference, algorithmIdentifier, message, slotHandle, hashRef, hashInfo);
            } else {
                BaseTemplateContext templateContext = new BaseTemplateContext();
                templateContext.put(HASH_TO_SIGN, message);
                templateContext.put(KEY_REFERENCE, keyReference);
                templateContext.put(ALGORITHM_IDENTIFIER, algorithmIdentifier);
                templateContext.put(HASHALGORITHM_REFERENCE, hashRef);
                response = this.performLegacySignature(cryptoMarker, connectionHandle, templateContext);
            }
        }
        catch (ECardException e) {
            response.setResult(e.getResult());
        }
        catch (Exception e) {
            LOG.warn(e.getMessage(), e);
            response.setResult(WSHelper.makeResult(e));
        }
        return response;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private SignResponse performSignature(CryptoMarkerType cryptoMarker, byte[] keyReference, byte[] algorithmIdentifier, byte[] message, byte[] slotHandle, byte[] hashRef, HashGenerationInfoType hashInfo) throws TLVException, IncorrectParameterException, APDUException, WSHelper.WSException {
        String[] signatureGenerationInfo;
        SignResponse response = (SignResponse)WSHelper.makeResponse(SignResponse.class, WSHelper.makeResultOK());
        TLV tagAlgorithmIdentifier = new TLV();
        tagAlgorithmIdentifier.setTagNumWithClass((byte)-128);
        tagAlgorithmIdentifier.setValue(algorithmIdentifier);
        TLV tagKeyReference = new TLV();
        tagKeyReference.setTagNumWithClass((byte)-124);
        tagKeyReference.setValue(keyReference);
        Object var11_11 = null;
        CardResponseAPDU responseAPDU = null;
        for (String command : signatureGenerationInfo = cryptoMarker.getSignatureGenerationInfo()) {
            void var11_26;
            block26: {
                byte[] mseData;
                block27: {
                    HashSet<String> signGenInfo = new HashSet<String>(java.util.Arrays.asList(signatureGenerationInfo));
                    if (!command.equals("MSE_KEY")) break block27;
                    mseData = tagKeyReference.toBER();
                    if (signGenInfo.contains("PSO_CDS")) {
                        ManageSecurityEnvironment manageSecurityEnvironment = new ManageSecurityEnvironment(65, -74, mseData);
                        break block26;
                    } else if (signGenInfo.contains("INT_AUTH") && !signGenInfo.contains("PSO_CDS")) {
                        ManageSecurityEnvironment manageSecurityEnvironment = new ManageSecurityEnvironment(65, -92, mseData);
                        break block26;
                    } else {
                        String msg = "The command 'MSE_KEY' followed by 'INT_AUTH' and 'PSO_CDS' is currently not supported.";
                        LOG.error(msg);
                        throw new IncorrectParameterException(msg);
                    }
                }
                if (command.equals("PSO_CDS")) {
                    PSOComputeDigitalSignature pSOComputeDigitalSignature = new PSOComputeDigitalSignature(message, 0);
                } else if (command.equals("INT_AUTH")) {
                    InternalAuthenticate internalAuthenticate = new InternalAuthenticate(message, 0);
                } else if (command.equals("MSE_RESTORE")) {
                    ManageSecurityEnvironment.Restore restore = new ManageSecurityEnvironment.Restore(-74);
                } else if (command.equals("MSE_HASH")) {
                    ManageSecurityEnvironment.Set set = new ManageSecurityEnvironment.Set(65, -86);
                    TLV mseDataTLV = new TLV();
                    mseDataTLV.setTagNumWithClass((byte)-128);
                    mseDataTLV.setValue(hashRef);
                    set.setData(mseDataTLV.toBER());
                } else if (command.equals("PSO_HASH")) {
                    if (hashInfo == HashGenerationInfoType.LAST_ROUND_ON_CARD || hashInfo == HashGenerationInfoType.NOT_ON_CARD) {
                        PSOHash pSOHash = new PSOHash(-96, message);
                    } else {
                        PSOHash pSOHash = new PSOHash(-128, message);
                    }
                } else if (command.equals("MSE_DS")) {
                    mseData = tagAlgorithmIdentifier.toBER();
                    ManageSecurityEnvironment manageSecurityEnvironment = new ManageSecurityEnvironment(65, -74, mseData);
                } else if (command.equals("MSE_KEY_DS")) {
                    mseData = ByteUtils.concatenate(tagKeyReference.toBER(), tagAlgorithmIdentifier.toBER());
                    ManageSecurityEnvironment manageSecurityEnvironment = new ManageSecurityEnvironment(65, -74, mseData);
                } else if (command.equals("MSE_INT_AUTH")) {
                    mseData = tagKeyReference.toBER();
                    ManageSecurityEnvironment manageSecurityEnvironment = new ManageSecurityEnvironment(65, -92, mseData);
                } else {
                    if (!command.equals("MSE_KEY_INT_AUTH")) {
                        String msg = "The signature generation command '" + command + "' is unknown.";
                        throw new IncorrectParameterException(msg);
                    }
                    mseData = ByteUtils.concatenate(tagKeyReference.toBER(), tagAlgorithmIdentifier.toBER());
                    ManageSecurityEnvironment manageSecurityEnvironment = new ManageSecurityEnvironment(65, -92, mseData);
                }
            }
            responseAPDU = var11_26.transmit(this.dispatcher, slotHandle, Collections.emptyList());
        }
        byte[] signedMessage = responseAPDU.getData();
        while (responseAPDU.getTrailer()[0] == 97) {
            GetResponse getResponseData = new GetResponse();
            responseAPDU = getResponseData.transmit(this.dispatcher, slotHandle, Collections.emptyList());
            signedMessage = Arrays.concatenate(signedMessage, responseAPDU.getData());
        }
        if (!Arrays.areEqual(responseAPDU.getTrailer(), new byte[]{-112, 0})) {
            String minor = SALErrorUtils.getMinor(responseAPDU.getTrailer());
            response.setResult(WSHelper.makeResultError(minor, responseAPDU.getStatusMessage()));
            return response;
        }
        response.setSignature(signedMessage);
        return response;
    }

    private SignResponse performLegacySignature(CryptoMarkerType cryptoMarker, ConnectionHandleType connectionHandle, BaseTemplateContext templateCTX) throws APDUTemplateException, APDUException, WSHelper.WSException {
        SignResponse response = (SignResponse)WSHelper.makeResponse(SignResponse.class, WSHelper.makeResultOK());
        List<Object> legacyCommands = cryptoMarker.getLegacySignatureGenerationInfo();
        CardResponseAPDU responseAPDU = null;
        byte[] slotHandle = connectionHandle.getSlotHandle();
        for (Object next : legacyCommands) {
            if (next instanceof CardCallTemplateType) {
                CardCallTemplateType cctt = (CardCallTemplateType)next;
                CardCommandTemplate template = new CardCommandTemplate(cctt);
                CardCommandAPDU cmdAPDU = template.evaluate(templateCTX);
                responseAPDU = cmdAPDU.transmit(this.dispatcher, slotHandle, Collections.emptyList());
                continue;
            }
            if (!(next instanceof LegacySignatureGenerationType.APICommand)) continue;
            this.sendAPICommand(connectionHandle, (LegacySignatureGenerationType.APICommand)next);
        }
        byte[] signedMessage = responseAPDU.getData();
        while (responseAPDU.getTrailer()[0] == 97) {
            CardCommandAPDU getResponseData = new CardCommandAPDU(0, -64, 0, 0, responseAPDU.getTrailer()[1]);
            responseAPDU = getResponseData.transmit(this.dispatcher, slotHandle, Collections.emptyList());
            signedMessage = Arrays.concatenate(signedMessage, responseAPDU.getData());
        }
        if (!Arrays.areEqual(responseAPDU.getTrailer(), new byte[]{-112, 0})) {
            String minor = SALErrorUtils.getMinor(responseAPDU.getTrailer());
            response.setResult(WSHelper.makeResultError(minor, responseAPDU.getStatusMessage()));
            return response;
        }
        response.setSignature(signedMessage);
        return response;
    }

    private void sendAPICommand(ConnectionHandleType handle, LegacySignatureGenerationType.APICommand cmd) {
        Method func2;
        List<Object> callObjs = cmd.getAPICall().getAny();
        Object callObj = callObjs.get(0);
        try {
            func2 = callObj.getClass().getMethod("setConnectionHandle", ConnectionHandleType.class);
            func2.invoke(callObj, handle);
        }
        catch (NoSuchMethodException func2) {
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            LOG.warn("Failed to execute setConnectionHandle.", ex);
        }
        try {
            func2 = callObj.getClass().getMethod("setSlotHandle", byte[].class);
            func2.invoke(callObj, new Object[]{handle.getSlotHandle()});
        }
        catch (NoSuchMethodException func3) {
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            LOG.warn("Failed to execute setSlotHandle.", ex);
        }
        LOG.debug("Sending API call.");
        Object result = this.dispatcher.safeDeliver(callObj);
    }
}

