/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.sal.protocol.eac.crypto;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.openecard.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.openecard.bouncycastle.crypto.params.ECDomainParameters;
import org.openecard.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.openecard.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.openecard.bouncycastle.crypto.params.ElGamalParameters;
import org.openecard.bouncycastle.crypto.params.ElGamalPrivateKeyParameters;
import org.openecard.bouncycastle.crypto.params.ElGamalPublicKeyParameters;
import org.openecard.bouncycastle.jce.spec.ECParameterSpec;
import org.openecard.bouncycastle.jce.spec.ElGamalParameterSpec;
import org.openecard.bouncycastle.math.ec.ECPoint;
import org.openecard.common.tlv.TLV;
import org.openecard.common.tlv.TLVException;
import org.openecard.common.util.ByteUtils;
import org.openecard.common.util.SecureRandomFactory;
import org.openecard.crypto.common.asn1.eac.CADomainParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CAKey {
    private static final Logger logger = LoggerFactory.getLogger(CAKey.class);
    private static final SecureRandom rand = SecureRandomFactory.create(32);
    private static long counter = 0L;
    private AsymmetricKeyParameter sk;
    private AsymmetricKeyParameter pk;
    private final CADomainParameter cdp;

    private static void reseed() {
        rand.setSeed(++counter);
        rand.setSeed(System.nanoTime());
    }

    public CAKey(CADomainParameter cdp) {
        this.cdp = cdp;
    }

    public byte[] decodePublicKey(byte[] data) throws TLVException {
        byte[] keyBytes = data[0] == 124 ? TLV.fromBER(data).getChild().getValue() : (data[0] != 4 ? ByteUtils.concatenate((byte)4, data) : data);
        if (this.cdp.isECDH()) {
            ECParameterSpec p = (ECParameterSpec)this.cdp.getParameter();
            ECDomainParameters ecp = new ECDomainParameters(p.getCurve(), p.getG(), p.getN(), p.getH());
            ECPoint q = p.getCurve().decodePoint(keyBytes);
            this.pk = new ECPublicKeyParameters(q, ecp);
            return this.getEncodedPublicKey();
        }
        if (this.cdp.isDH()) {
            logger.error("Not implemented yet.");
            throw new UnsupportedOperationException("Not implemented yet.");
        }
        throw new IllegalArgumentException();
    }

    public void generateKeyPair() {
        CAKey.reseed();
        if (this.cdp.isDH()) {
            ElGamalParameterSpec p = (ElGamalParameterSpec)this.cdp.getParameter();
            int numBits = p.getG().bitLength();
            BigInteger d = new BigInteger(numBits, rand);
            ElGamalParameters egp = new ElGamalParameters(p.getP(), p.getG());
            this.sk = new ElGamalPrivateKeyParameters(d, egp);
            this.pk = new ElGamalPublicKeyParameters(egp.getG().multiply(d), egp);
        } else if (this.cdp.isECDH()) {
            ECParameterSpec p = (ECParameterSpec)this.cdp.getParameter();
            int numBits = p.getN().bitLength();
            BigInteger d = new BigInteger(numBits, rand);
            ECDomainParameters ecp = new ECDomainParameters(p.getCurve(), p.getG(), p.getN(), p.getH());
            this.sk = new ECPrivateKeyParameters(d, ecp);
            this.pk = new ECPublicKeyParameters(ecp.getG().multiply(d), ecp);
        } else {
            throw new IllegalArgumentException();
        }
    }

    public AsymmetricKeyParameter getPublicKey() {
        return this.pk;
    }

    public byte[] getEncodedPublicKey() {
        if (this.cdp.isDH()) {
            return ((ElGamalPublicKeyParameters)this.pk).getY().toByteArray();
        }
        if (this.cdp.isECDH()) {
            return ((ECPublicKeyParameters)this.pk).getQ().getEncoded();
        }
        throw new IllegalArgumentException();
    }

    public byte[] getEncodedCompressedPublicKey() {
        if (this.cdp.isDH()) {
            try {
                MessageDigest md = MessageDigest.getInstance("SHA-1");
                byte[] input = ((ElGamalPublicKeyParameters)this.pk).getY().toByteArray();
                byte[] compKey = md.digest(input);
                return compKey;
            }
            catch (NoSuchAlgorithmException e) {
                logger.error(e.getMessage(), e);
                throw new RuntimeException(e);
            }
        }
        if (this.cdp.isECDH()) {
            byte[] compKey = ((ECPublicKeyParameters)this.pk).getQ().getAffineXCoord().toBigInteger().toByteArray();
            return ByteUtils.cutLeadingNullByte(compKey);
        }
        throw new IllegalArgumentException();
    }

    public AsymmetricKeyParameter getPrivateKey() {
        return this.sk;
    }

    public byte[] getEncodedPrivateKey() {
        if (this.cdp.isDH()) {
            return ((ElGamalPrivateKeyParameters)this.sk).getX().toByteArray();
        }
        if (this.cdp.isECDH()) {
            return ((ECPrivateKeyParameters)this.sk).getD().toByteArray();
        }
        throw new IllegalArgumentException();
    }
}

