/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.sal.protocol.eac.anytype;

import iso.std.iso_iec._24727.tech.schema.KeyRefType;
import org.openecard.common.util.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PACEMarkerType {
    private KeyRefType passwordRef;
    private String passwordValue;
    private Integer minLength;
    private Integer maxLength;
    private String protocol;

    public PACEMarkerType(iso.std.iso_iec._24727.tech.schema.PACEMarkerType paceMarker) {
        this.protocol = paceMarker.getProtocol();
        for (Element elem : paceMarker.getAny()) {
            if (elem.getLocalName().equals("PasswordRef")) {
                this.passwordRef = new KeyRefType();
                NodeList algorithmInfoNodes = elem.getChildNodes();
                for (int i = 0; i < algorithmInfoNodes.getLength(); ++i) {
                    Node node = algorithmInfoNodes.item(i);
                    if (node.getLocalName().equals("KeyRef")) {
                        this.passwordRef.setKeyRef(StringUtils.toByteArray(node.getTextContent()));
                        continue;
                    }
                    if (!node.getLocalName().equals("Protected")) continue;
                    this.passwordRef.setProtected(Boolean.parseBoolean(node.getTextContent()));
                }
                continue;
            }
            if (elem.getLocalName().equals("PasswordValue")) {
                this.passwordValue = elem.getTextContent();
                continue;
            }
            if (elem.getLocalName().equals("minLength")) {
                this.minLength = Integer.parseInt(elem.getTextContent());
                continue;
            }
            if (elem.getLocalName().equals("maxLength")) {
                this.maxLength = Integer.parseInt(elem.getTextContent());
                continue;
            }
            if (!elem.getLocalName().equals("StateInfo")) continue;
        }
    }

    public int getMaxLength() {
        if (this.maxLength != null) {
            return this.maxLength;
        }
        return Integer.MAX_VALUE;
    }

    public int getMinLength() {
        if (this.minLength != null) {
            return this.minLength;
        }
        return 0;
    }

    public String getPasswordValue() {
        return this.passwordValue;
    }

    public KeyRefType getPasswordRef() {
        return this.passwordRef;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }
}

