/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.sal.protocol.eac.anytype;

import iso.std.iso_iec._24727.tech.schema.DIDAuthenticationDataType;
import org.openecard.common.anytype.AuthDataMap;
import org.openecard.common.anytype.AuthDataResponse;
import org.openecard.common.util.ByteUtils;

public class EAC2OutputType {
    public static final String CHALLENGE = "Challenge";
    public static final String EF_CARDSECURITY = "EFCardSecurity";
    public static final String TOKEN = "AuthenticationToken";
    public static final String NONCE = "Nonce";
    private final AuthDataMap authMap;
    private byte[] challenge;
    private byte[] efCardSecurity;
    private byte[] token;
    private byte[] nonce;

    protected EAC2OutputType(AuthDataMap authMap) {
        this.authMap = authMap;
    }

    public void setChallenge(byte[] challenge) {
        this.challenge = challenge;
    }

    public void setEFCardSecurity(byte[] efCardSecurity) {
        this.efCardSecurity = efCardSecurity;
    }

    public void setNonce(byte[] nonce) {
        this.nonce = nonce;
    }

    public void setToken(byte[] token) {
        this.token = token;
    }

    public DIDAuthenticationDataType getAuthDataType() {
        AuthDataResponse<iso.std.iso_iec._24727.tech.schema.EAC2OutputType> authResponse = this.authMap.createResponse(new iso.std.iso_iec._24727.tech.schema.EAC2OutputType());
        if (this.challenge != null) {
            authResponse.addElement(CHALLENGE, ByteUtils.toHexString(this.challenge));
        } else {
            authResponse.addElement(EF_CARDSECURITY, ByteUtils.toHexString(this.efCardSecurity));
            authResponse.addElement(TOKEN, ByteUtils.toHexString(this.token));
            authResponse.addElement(NONCE, ByteUtils.toHexString(this.nonce));
        }
        return authResponse.getResponse();
    }
}

