/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.sal.protocol.eac;

import iso.std.iso_iec._24727.tech.schema.DIDAuthenticate;
import iso.std.iso_iec._24727.tech.schema.DIDAuthenticateResponse;
import java.util.Map;
import org.openecard.addon.sal.FunctionType;
import org.openecard.addon.sal.ProtocolStep;
import org.openecard.common.DynamicContext;
import org.openecard.common.WSHelper;
import org.openecard.common.interfaces.Dispatcher;
import org.openecard.common.interfaces.ObjectSchemaValidator;
import org.openecard.common.interfaces.ObjectValidatorException;
import org.openecard.common.util.Promise;
import org.openecard.crypto.common.asn1.cvc.CardVerifiableCertificate;
import org.openecard.crypto.common.asn1.cvc.CardVerifiableCertificateChain;
import org.openecard.sal.protocol.eac.AuthenticationHelper;
import org.openecard.sal.protocol.eac.ChipAuthentication;
import org.openecard.sal.protocol.eac.TerminalAuthentication;
import org.openecard.sal.protocol.eac.anytype.EAC2InputType;
import org.openecard.sal.protocol.eac.anytype.EAC2OutputType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TerminalAuthenticationStep
implements ProtocolStep<DIDAuthenticate, DIDAuthenticateResponse> {
    private static final Logger logger = LoggerFactory.getLogger(TerminalAuthenticationStep.class.getName());
    private final Dispatcher dispatcher;

    public TerminalAuthenticationStep(Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    @Override
    public FunctionType getFunctionType() {
        return FunctionType.DIDAuthenticate;
    }

    @Override
    public DIDAuthenticateResponse perform(DIDAuthenticate didAuthenticate, Map<String, Object> internalData) {
        DIDAuthenticateResponse response = new DIDAuthenticateResponse();
        DynamicContext dynCtx = DynamicContext.getInstance("tr03112");
        try {
            ObjectSchemaValidator valid = (ObjectSchemaValidator)dynCtx.getPromise("org.openecard.tr03112.eac.schema_validator").deref();
            boolean messageValid = valid.validateObject(didAuthenticate);
            if (!messageValid) {
                String msg = "Validation of the EAC2InputType message failed.";
                logger.error(msg);
                dynCtx.put("org.openecard.tr03112.eac.authentication_failed", true);
                response.setResult(WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/common#incorrectParameter", msg));
                return response;
            }
        }
        catch (ObjectValidatorException ex) {
            String msg = "Validation of the EAC2InputType message failed due to invalid input data.";
            logger.error(msg, ex);
            dynCtx.put("org.openecard.tr03112.eac.authentication_failed", true);
            response.setResult(WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/common#internalError", msg));
            return response;
        }
        catch (InterruptedException ex) {
            String msg = "Thread interrupted while waiting for schema validator instance.";
            logger.error(msg, ex);
            dynCtx.put("org.openecard.tr03112.eac.authentication_failed", true);
            response.setResult(WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/common#internalError", msg));
            return response;
        }
        byte[] slotHandle = didAuthenticate.getConnectionHandle().getSlotHandle();
        try {
            EAC2InputType eac2Input = new EAC2InputType(didAuthenticate.getAuthenticationProtocolData());
            EAC2OutputType eac2Output = eac2Input.getOutputType();
            TerminalAuthentication ta = new TerminalAuthentication(this.dispatcher, slotHandle);
            CardVerifiableCertificateChain certificateChain = (CardVerifiableCertificateChain)internalData.get("Certificates");
            certificateChain.addCertificates(eac2Input.getCertificates());
            byte[] currentCAR = (byte[])internalData.get("CurrentCAR");
            byte[] previousCAR = (byte[])internalData.get("PreviousCAR");
            CardVerifiableCertificateChain tmpChain = certificateChain.getCertificateChainFromCAR(currentCAR);
            if (tmpChain.getCertificates().isEmpty() && previousCAR != null) {
                tmpChain = certificateChain.getCertificateChainFromCAR(previousCAR);
            }
            if ((certificateChain = tmpChain).getCertificates().isEmpty()) {
                String msg = "Failed to create a valid certificate chain from the transmitted certificates.";
                logger.error(msg);
                response.setResult(WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/common#incorrectParameter", msg));
                return response;
            }
            ta.verifyCertificates(certificateChain);
            CardVerifiableCertificate terminalCertificate = certificateChain.getTerminalCertificate();
            byte[] key = eac2Input.getEphemeralPublicKey();
            byte[] signature = eac2Input.getSignature();
            internalData.put("PKPCD", key);
            internalData.put("Signature", signature);
            internalData.put("TerminalCertificate", terminalCertificate);
            if (signature != null) {
                logger.trace("Signature has been provided in EAC2InputType.");
                ChipAuthentication ca = new ChipAuthentication(this.dispatcher, slotHandle);
                AuthenticationHelper auth = new AuthenticationHelper(ta, ca);
                eac2Output = auth.performAuth(eac2Output, internalData);
                DynamicContext ctx = DynamicContext.getInstance("tr03112");
                ctx.put("org.openecard.tr03112.eac.authentication_done", true);
            } else {
                logger.trace("Signature has not been provided in EAC2InputType.");
                byte[] rPICC = (byte[])internalData.get("Challenge");
                eac2Output.setChallenge(rPICC);
            }
            response.setResult(WSHelper.makeResultOK());
            response.setAuthenticationProtocolData(eac2Output.getAuthDataType());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            response.setResult(WSHelper.makeResultUnknownError(e.getMessage()));
            dynCtx.put("org.openecard.tr03112.eac.authentication_failed", true);
        }
        Promise<Object> p = dynCtx.getPromise("processing_canceled");
        if (p.derefNonblocking() == null) {
            return response;
        }
        response = new DIDAuthenticateResponse();
        String msg = "Authentication Canceled by the user.";
        response.setResult(WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/sal#cancellationByUser", msg));
        return response;
    }
}

