/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.richclient.gui.manage;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openecard.addon.AddonPropertiesException;
import org.openecard.addon.manifest.ScalarEntryType;
import org.openecard.addon.manifest.ScalarListEntryType;
import org.openecard.common.I18n;
import org.openecard.richclient.gui.components.CheckboxListItem;
import org.openecard.richclient.gui.components.FileListEntryItem;
import org.openecard.richclient.gui.components.MathNumberEditor;
import org.openecard.richclient.gui.components.OpenFileBrowserListener;
import org.openecard.richclient.gui.components.ScalarListItem;
import org.openecard.richclient.gui.components.SpinnerMathNumberModel;
import org.openecard.richclient.gui.manage.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SettingsGroup
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(SettingsGroup.class);
    protected final Settings properties;
    private final I18n lang = I18n.getTranslation("addon");
    private final JPanel container;
    private final HashMap<Component, JLabel> fieldLabels;
    protected int itemIdx;

    public SettingsGroup(@Nullable String title, @Nonnull Settings settings) {
        this.properties = settings;
        this.fieldLabels = new HashMap();
        Border frameBorder = BorderFactory.createEmptyBorder(2, 2, 2, 2);
        if (title != null) {
            TitledBorder titleBorder = BorderFactory.createTitledBorder(frameBorder, title);
            titleBorder.setTitleJustification(4);
            titleBorder.setTitlePosition(2);
            titleBorder.setTitleFont(new JLabel().getFont().deriveFont(1));
            frameBorder = titleBorder;
        }
        this.setBorder(frameBorder);
        this.setLayout(new BorderLayout());
        this.container = new JPanel();
        this.add((Component)this.container, "North");
        GridBagLayout layout = new GridBagLayout();
        layout.columnWidths = new int[]{0, 10, 0, 0};
        layout.rowHeights = new int[]{0, 0};
        layout.columnWeights = new double[]{0.0, 0.0, 1.0, Double.MIN_VALUE};
        layout.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.container.setLayout(layout);
    }

    protected final JPanel getContainer() {
        return this.container;
    }

    protected void saveProperties() throws IOException, SecurityException, AddonPropertiesException {
        this.properties.store();
    }

    protected void setEnabledComponent(Component element, boolean enabled) {
        JLabel label = this.fieldLabels.get(element);
        label.setVisible(enabled);
        element.setVisible(enabled);
    }

    protected JTextField addInputItem(@Nonnull String name, @Nullable String description, @Nonnull String property) {
        return this.addInputItem(name, description, property, false);
    }

    protected JTextField addInputItem(@Nonnull String name, @Nullable String description, final @Nonnull String property, boolean isPassword) {
        JLabel label = this.addLabel(name, description);
        String value = this.properties.getProperty(property);
        value = value == null ? "" : value;
        final JTextField input = isPassword ? new JPasswordField(value){

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                dim.width = 100;
                return dim;
            }
        } : new JTextField(value){

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                dim.width = 100;
                return dim;
            }
        };
        this.fieldLabels.put(input, label);
        input.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                SettingsGroup.this.properties.setProperty(property, input.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SettingsGroup.this.properties.setProperty(property, input.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.addComponent(input);
        ++this.itemIdx;
        return input;
    }

    protected ScalarListItem addScalarListItem(@Nonnull String name, @Nullable String desc, @Nonnull String property, @Nonnull ScalarListEntryType entry) {
        JLabel label = this.addListLabel(name, desc);
        ScalarListItem item = new ScalarListItem(property, this.properties, entry);
        this.fieldLabels.put(item, label);
        this.addComponent(item);
        ++this.itemIdx;
        return item;
    }

    protected JCheckBox addBoolItem(@Nonnull String name, @Nullable String description, final @Nonnull String property) {
        JLabel label = this.addLabel(name, description);
        String value = this.properties.getProperty(property);
        if (value == null || value.equals("")) {
            this.properties.setProperty(property, Boolean.FALSE.toString());
        }
        Boolean boolValue = Boolean.parseBoolean(value);
        final JCheckBox input = new JCheckBox();
        input.setSelected(boolValue);
        this.fieldLabels.put(input, label);
        input.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SettingsGroup.this.properties.setProperty(property, Boolean.toString(input.isSelected()));
            }
        });
        this.addComponent(input);
        ++this.itemIdx;
        return input;
    }

    protected JComboBox<String> addSelectionItem(@Nonnull String name, @Nullable String description, final @Nonnull String property, String ... values) {
        JLabel label = this.addLabel(name, description);
        JPanel test = new JPanel();
        JComboBox<String> comboBox = new JComboBox<String>(values);
        if (Arrays.asList(values).contains("")) {
            comboBox.setSelectedItem(this.properties.getProperty(property));
        } else {
            String prop = this.properties.getProperty(property);
            if (prop == null || prop.equals("")) {
                comboBox.setSelectedItem(values[0]);
            } else {
                comboBox.setSelectedItem(prop);
            }
        }
        comboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    SettingsGroup.this.properties.setProperty(property, (String)e.getItem());
                }
            }
        });
        this.addComponent(comboBox);
        this.fieldLabels.put(test, label);
        ++this.itemIdx;
        return comboBox;
    }

    protected JPanel addMultiSelectionItem(@Nonnull String name, @Nullable String description, @Nonnull String property, @Nonnull List<String> values) {
        JLabel optionName = this.addListLabel(name, description);
        JPanel contentPane = new JPanel(new GridBagLayout());
        JPanel checkboxPane = new JPanel(new GridBagLayout());
        int row = 0;
        int col = 0;
        String property2 = this.properties.getProperty(property);
        for (String value : values) {
            GridBagConstraints c = new GridBagConstraints();
            if (col != 0 && col % 3 == 0) {
                col = 0;
            }
            c.gridx = col;
            c.gridy = ++row;
            c.fill = 0;
            c.anchor = 18;
            if (property2 != null) {
                String[] multProps = property2.split(";");
                List<String> selectedOpts = Arrays.asList(multProps);
                if (selectedOpts.contains(value)) {
                    checkboxPane.add((Component)new CheckboxListItem(value, true, property, this.properties), c);
                } else {
                    checkboxPane.add((Component)new CheckboxListItem(value, false, property, this.properties), c);
                }
            } else {
                checkboxPane.add((Component)new CheckboxListItem(value, false, property, this.properties), c);
            }
            if (col == 2) {
                GridBagConstraints c2 = new GridBagConstraints();
                c2.fill = 1;
                c2.weightx = 1.0;
                c2.gridx = 3;
                c2.gridy = row;
                checkboxPane.add((Component)new JLabel(), c2);
            }
            ++col;
        }
        GridBagConstraints c3 = new GridBagConstraints();
        c3.anchor = 18;
        c3.fill = 2;
        c3.gridwidth = 0;
        c3.weightx = 1.0;
        contentPane.add((Component)checkboxPane, c3);
        this.addComponent(contentPane);
        ++this.itemIdx;
        this.fieldLabels.put(contentPane, optionName);
        return contentPane;
    }

    private JLabel addLabel(@Nonnull String name, @Nullable String description) {
        JLabel label = new JLabel(name);
        label.setToolTipText(description);
        label.setFont(label.getFont().deriveFont(0));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(5, 10, 0, 5);
        constraints.gridx = 0;
        constraints.gridy = this.itemIdx;
        constraints.anchor = 17;
        this.container.add((Component)label, constraints);
        return label;
    }

    private JLabel addListLabel(@Nonnull String name, @Nullable String description) {
        JLabel label = new JLabel(name);
        label.setToolTipText(description);
        label.setFont(label.getFont().deriveFont(0));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(5, 10, 0, 5);
        constraints.gridx = 0;
        constraints.gridy = this.itemIdx;
        constraints.anchor = 18;
        this.container.add((Component)label, constraints);
        return label;
    }

    private void addComponent(@Nonnull Component component) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(5, 3, 0, 5);
        constraints.fill = 2;
        constraints.gridx = 2;
        constraints.gridy = this.itemIdx;
        this.container.add(component, constraints);
    }

    protected JSpinner addScalarEntryTypNumber(@Nonnull String name, @Nullable String description, final @Nonnull String property, @Nonnull String type) {
        Number convertedValue;
        SpinnerMathNumberModel model;
        JLabel label = this.addLabel(name, description);
        String value = this.properties.getProperty(property);
        if (type.equals(ScalarEntryType.BIGDECIMAL.name())) {
            if (value == null || value.equals("")) {
                model = new SpinnerMathNumberModel(new BigDecimal("0.0"), null, null, new BigDecimal("0.1"));
            } else {
                convertedValue = new BigDecimal(value);
                model = new SpinnerMathNumberModel((BigDecimal)convertedValue, null, null, new BigDecimal("0.1"));
            }
        } else if (type.equals(ScalarEntryType.BIGINTEGER.name())) {
            if (value == null || value.equals("")) {
                model = new SpinnerMathNumberModel(BigInteger.ZERO, null, null, BigInteger.ONE);
            } else {
                convertedValue = new BigInteger(value);
                model = new SpinnerMathNumberModel((BigInteger)convertedValue, null, null, BigInteger.ONE);
            }
        } else {
            LOG.error("Type STRING and BOOLEAN are not allowed for the use of this function.");
            return null;
        }
        final JSpinner spinner = new JSpinner(model){

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                dim.width = 100;
                return dim;
            }
        };
        spinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SettingsGroup.this.properties.setProperty(property, spinner.getModel().getValue().toString());
            }
        });
        spinner.setEnabled(true);
        spinner.setEditor(new MathNumberEditor(spinner, (DecimalFormat)DecimalFormat.getInstance(spinner.getLocale())));
        this.addComponent(spinner);
        this.fieldLabels.put(spinner, label);
        ++this.itemIdx;
        return spinner;
    }

    protected JPanel addFileEntry(@Nonnull String name, @Nullable String description, final @Nonnull String property, @Nonnull String fileType, boolean requiredBeforeAction) {
        JPanel filePanel = new JPanel(new GridBagLayout());
        JLabel label = this.addLabel(name, description);
        String currentValue = this.properties.getProperty(property);
        final JTextField filePathField = new JTextField(){

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                dim.width = 100;
                return dim;
            }
        };
        if (currentValue != null) {
            filePathField.setText(currentValue);
            filePathField.setToolTipText(currentValue);
        }
        filePathField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                File file = new File(filePathField.getText());
                if (file.exists() && file.isFile()) {
                    SettingsGroup.this.properties.setProperty(property, filePathField.getText());
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                File file = new File(filePathField.getText());
                if (file.exists() && file.isFile() || filePathField.getText().equals("")) {
                    SettingsGroup.this.properties.setProperty(property, filePathField.getText());
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        GridBagConstraints fieldConstraint = new GridBagConstraints();
        fieldConstraint.anchor = 17;
        fieldConstraint.fill = 2;
        fieldConstraint.gridx = 0;
        fieldConstraint.gridy = 0;
        fieldConstraint.weightx = 2.0;
        filePanel.add((Component)filePathField, fieldConstraint);
        JButton browseButton = new JButton(this.lang.translationForKey("addon.settings.browse", new Object[0]));
        browseButton.addActionListener(new OpenFileBrowserListener(fileType, filePathField));
        GridBagConstraints buttonConstraint = new GridBagConstraints();
        buttonConstraint.anchor = 13;
        buttonConstraint.fill = 0;
        buttonConstraint.gridx = 1;
        buttonConstraint.gridy = 0;
        buttonConstraint.weightx = 0.0;
        buttonConstraint.gridwidth = 0;
        buttonConstraint.insets = new Insets(0, 5, 0, 0);
        filePanel.add((Component)browseButton, buttonConstraint);
        this.addComponent(filePanel);
        ++this.itemIdx;
        this.fieldLabels.put(filePanel, label);
        return filePanel;
    }

    public JPanel addFileListEntry(@Nonnull String name, @Nonnull String description, @Nonnull String property, @Nonnull String fileType, boolean isRequired) {
        JLabel label = this.addListLabel(name, description);
        FileListEntryItem item = new FileListEntryItem(fileType, property, this.properties);
        GridBagConstraints constraints2 = new GridBagConstraints();
        constraints2.anchor = 18;
        constraints2.insets = new Insets(5, 3, 0, 0);
        constraints2.fill = 2;
        constraints2.gridx = 2;
        constraints2.gridy = this.itemIdx++;
        this.container.add((Component)item, constraints2);
        this.fieldLabels.put(item, label);
        return item;
    }
}

