/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.richclient.gui.manage;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import org.openecard.addon.AddonManager;
import org.openecard.addon.manifest.AddonSpecification;
import org.openecard.common.I18n;
import org.openecard.richclient.gui.manage.ManagementDialog;

public class AboutPanel
extends JPanel {
    private static final String LANGUAGE_CODE = System.getProperty("user.language");
    private final I18n lang = I18n.getTranslation("addon");
    private final AddonSpecification addonSpec;
    private final AddonManager manager;
    private final GridBagLayout layout = new GridBagLayout();
    private final String license;
    private final String about;
    private final ManagementDialog dialog;
    private JEditorPane display;
    private final ItemListener action = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 2) {
                AboutPanel.this.display.setText(AboutPanel.this.license);
            } else if (e.getStateChange() == 1) {
                AboutPanel.this.display.setText(AboutPanel.this.about);
            }
            AboutPanel.this.display.setCaretPosition(0);
        }
    };

    public AboutPanel(AddonSpecification addonSpecification, boolean coreAddon, AddonManager manager, ManagementDialog dialog) {
        this.setLayout(this.layout);
        this.manager = manager;
        this.dialog = dialog;
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.addonSpec = addonSpecification;
        this.license = addonSpecification.getLicenseText(LANGUAGE_CODE);
        this.about = addonSpecification.getAbout(LANGUAGE_CODE);
        this.setupHead();
        this.setupBody();
        this.setupFooter(coreAddon);
    }

    private void setupHead() {
        JPanel basePane = new JPanel(new GridBagLayout());
        basePane.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        basePane.setLayout(new GridLayout(2, 1));
        JLabel versionLabel = new JLabel(this.lang.translationForKey("addon.about.version", new Object[0]) + ":");
        JLabel licenseLabel = new JLabel(this.lang.translationForKey("addon.about.license.type", new Object[0]) + ":");
        GridBagConstraints lc = new GridBagConstraints();
        lc.anchor = 17;
        lc.gridx = 0;
        lc.gridy = 0;
        lc.weightx = 1.0;
        lc.weighty = 1.0;
        basePane.add((Component)versionLabel, lc);
        GridBagConstraints lc2 = new GridBagConstraints();
        lc2.anchor = 17;
        lc2.fill = 2;
        lc2.gridwidth = 0;
        lc2.gridx = 1;
        lc2.gridy = 0;
        lc2.weightx = 1.0;
        lc2.weighty = 1.0;
        basePane.add(new JLabel(this.addonSpec.getVersion()));
        GridBagConstraints lc3 = new GridBagConstraints();
        lc3.anchor = 17;
        lc3.gridx = 1;
        lc3.gridy = 2;
        lc3.weightx = 1.0;
        lc3.weighty = 1.0;
        basePane.add((Component)licenseLabel, lc3);
        GridBagConstraints lc4 = new GridBagConstraints();
        lc4.anchor = 17;
        lc4.fill = 2;
        lc4.gridwidth = 0;
        lc4.gridx = 1;
        lc4.gridy = 0;
        lc4.weightx = 1.0;
        lc4.weighty = 1.0;
        basePane.add(new JLabel(this.addonSpec.getLicense()));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 11;
        this.layout.setConstraints(basePane, c);
        this.add(basePane);
    }

    private void setupBody() {
        this.display = new JEditorPane();
        this.display.setContentType("text/html");
        this.display.setText(this.about);
        this.display.setEditable(false);
        if (this.about.equals("")) {
            this.display.setText("No about text available.");
        }
        JPanel buttonPane = new JPanel(new FlowLayout(3));
        buttonPane.setBorder(BorderFactory.createEmptyBorder());
        if (!this.license.equals("") && !this.about.equals("")) {
            JRadioButton aButton = new JRadioButton(this.lang.translationForKey("addon.about.about", new Object[0]));
            aButton.addItemListener(this.action);
            aButton.setSelected(true);
            JRadioButton lButton = new JRadioButton(this.lang.translationForKey("addon.about.license", new Object[0]));
            ButtonGroup btnGrp = new ButtonGroup();
            btnGrp.add(aButton);
            btnGrp.add(lButton);
            buttonPane.add(aButton);
            buttonPane.add(lButton);
        } else if (!this.license.equals("") && this.about.equals("")) {
            JLabel licenseLabel2 = new JLabel(this.lang.translationForKey("addon.about.license", new Object[0]));
            buttonPane.add(licenseLabel2);
            this.display.setText(this.license);
        } else if (this.license.equals("") && !this.about.equals("")) {
            JLabel aboutLabel = new JLabel(this.lang.translationForKey("addon.about.about", new Object[0]));
            buttonPane.add(aboutLabel);
        }
        GridBagLayout scrollLayout = new GridBagLayout();
        JPanel panel = new JPanel(scrollLayout);
        JScrollPane aboutScroll = new JScrollPane(this.display);
        aboutScroll.setBorder(BorderFactory.createEmptyBorder());
        aboutScroll.setHorizontalScrollBarPolicy(31);
        aboutScroll.setVerticalScrollBarPolicy(20);
        aboutScroll.setMinimumSize(new Dimension(150, 100));
        aboutScroll.getVerticalScrollBar().setBlockIncrement(16);
        aboutScroll.getVerticalScrollBar().setUnitIncrement(16);
        this.display.setMinimumSize(new Dimension(150, 100));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridwidth = 0;
        c.gridheight = 2;
        c.weightx = 1.0;
        c.weighty = 10.0;
        c.anchor = 11;
        this.layout.setConstraints(panel, c);
        GridBagConstraints c2 = new GridBagConstraints();
        c2.anchor = 17;
        c2.fill = 0;
        c2.gridwidth = 0;
        c2.gridheight = 1;
        c2.weightx = 1.0;
        c2.weighty = 1.0;
        scrollLayout.setConstraints(buttonPane, c2);
        panel.add(buttonPane);
        GridBagConstraints c3 = new GridBagConstraints();
        c3.anchor = 10;
        c3.fill = 1;
        c3.gridwidth = 0;
        c3.gridheight = 2;
        c3.weightx = 1.0;
        c3.weighty = 5.0;
        scrollLayout.setConstraints(aboutScroll, c3);
        panel.add(aboutScroll);
        this.add(panel);
    }

    private void setupFooter(boolean coreAddon) {
        if (!coreAddon) {
            JPanel panel = new JPanel(new FlowLayout(3));
            JButton uninstallButton = new JButton(this.lang.translationForKey("addon.about.uninstall", new Object[0]));
            uninstallButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AboutPanel.this.manager.uninstallAddon(AboutPanel.this.addonSpec);
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    AboutPanel.this.dialog.updateGui();
                }
            });
            panel.add(uninstallButton);
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 2;
            c.gridwidth = 0;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.anchor = 15;
            this.layout.setConstraints(panel, c);
            this.add(panel);
        }
    }
}

