/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.richclient.gui.components;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.swing.AbstractSpinnerModel;

public class SpinnerMathNumberModel
extends AbstractSpinnerModel
implements Serializable {
    private Number value;
    private Number stepSize;
    private Comparable maximum;
    private Comparable minimum;

    public SpinnerMathNumberModel(BigInteger value, BigInteger minimum, BigInteger maximum, BigInteger stepSize) {
        this.spinnerMathNumberModelSetter(value, minimum, maximum, stepSize);
    }

    public SpinnerMathNumberModel(BigDecimal value, BigDecimal minimum, BigDecimal maximum, BigDecimal stepSize) {
        this.spinnerMathNumberModelSetter(value, minimum, maximum, stepSize);
    }

    private void spinnerMathNumberModelSetter(Number value, Comparable minimum, Comparable maximum, Number stepSize) {
        if (value == null) {
            throw new IllegalArgumentException("NULL is not allowed as value.");
        }
        this.value = value;
        if (stepSize == null) {
            throw new IllegalArgumentException("The value NULL for the stepSize field is invalid.");
        }
        this.stepSize = stepSize;
        this.maximum = maximum;
        this.minimum = minimum;
    }

    private Number incrementValue(int dir) {
        Number newValue = null;
        switch (dir) {
            case -1: {
                if (this.value instanceof BigInteger) {
                    BigInteger oldValue = (BigInteger)this.value;
                    newValue = oldValue.subtract((BigInteger)this.stepSize);
                    break;
                }
                BigDecimal oldValue = (BigDecimal)this.value;
                newValue = oldValue.subtract((BigDecimal)this.stepSize);
                break;
            }
            case 1: {
                if (this.value instanceof BigInteger) {
                    BigInteger oldValue = (BigInteger)this.value;
                    newValue = oldValue.add((BigInteger)this.stepSize);
                    break;
                }
                BigDecimal oldValue = (BigDecimal)this.value;
                newValue = oldValue.add((BigDecimal)this.stepSize);
            }
        }
        return newValue;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            throw new IllegalArgumentException("NULL is not allowed as value.");
        }
        if (!(value instanceof BigInteger) && !(value instanceof BigDecimal)) {
            throw new IllegalArgumentException("The argument must be of type BigInteger or BigDecimal");
        }
        if (!this.value.getClass().equals(value.getClass())) {
            String msg = "The current value is of type " + this.value.getClass().getSimpleName() + " and the given value is of type " + value.getClass().getSimpleName();
            throw new IllegalArgumentException(msg);
        }
        if (this.value instanceof BigInteger) {
            BigInteger convValue = (BigInteger)value;
            this.value = this.minimum != null && convValue.compareTo((BigInteger)this.minimum) == -1 ? (BigInteger)this.minimum : (this.maximum != null && convValue.compareTo((BigInteger)this.maximum) == 1 ? (BigInteger)this.maximum : convValue);
        } else {
            BigDecimal convValue = (BigDecimal)value;
            this.value = this.minimum != null && convValue.compareTo((BigDecimal)this.minimum) == -1 ? (BigDecimal)this.minimum : (this.maximum != null && convValue.compareTo((BigDecimal)this.maximum) == 1 ? (BigDecimal)this.maximum : (BigDecimal)value);
        }
        this.fireStateChanged();
    }

    @Override
    public Object getNextValue() {
        return this.incrementValue(1);
    }

    @Override
    public Object getPreviousValue() {
        return this.incrementValue(-1);
    }

    public Number getMinimum() {
        if (this.minimum instanceof BigInteger) {
            return (BigInteger)this.minimum;
        }
        return (BigDecimal)this.minimum;
    }

    public Number getMaximum() {
        if (this.maximum instanceof BigDecimal) {
            return (BigDecimal)this.maximum;
        }
        return (BigInteger)this.maximum;
    }
}

