/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.richclient.gui.components;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openecard.addon.manifest.ScalarListEntryType;
import org.openecard.gui.swing.common.GUIDefaults;
import org.openecard.richclient.gui.components.MathNumberEditor;
import org.openecard.richclient.gui.components.SpinnerMathNumberModel;
import org.openecard.richclient.gui.manage.Settings;

public class ScalarListItem
extends JPanel {
    private static final Icon openedIndicator = GUIDefaults.getImage("ToggleText.selectedIcon");
    private static final Icon closedIndicator = GUIDefaults.getImage("ToggleText.icon");
    private final ArrayList<JTextField> textFieldList;
    private final ArrayList<JSpinner> spinnerList;
    private final ScalarListEntryType type;
    private final Settings properties;
    private final String property;
    private int currentRow = 0;
    private JButton lastPlus;

    public ScalarListItem(@Nonnull String property, @Nonnull Settings properties, @Nonnull ScalarListEntryType type) {
        this.type = type.equals((Object)ScalarListEntryType.BIGDECIMAL) ? ScalarListEntryType.BIGDECIMAL : (type.equals((Object)ScalarListEntryType.BIGINTEGER) ? ScalarListEntryType.BIGINTEGER : ScalarListEntryType.STRING);
        this.properties = properties;
        this.property = property;
        this.setLayout(new GridBagLayout());
        if (type.equals((Object)ScalarListEntryType.BIGDECIMAL) || type.equals((Object)ScalarListEntryType.BIGINTEGER)) {
            this.spinnerList = new ArrayList();
            this.textFieldList = null;
        } else {
            this.textFieldList = new ArrayList();
            this.spinnerList = null;
        }
        String entriesList = properties.getProperty(property);
        if (entriesList != null) {
            String[] singleEntries;
            for (String entry : singleEntries = entriesList.split(";")) {
                this.addRow(entry);
            }
        } else {
            this.addEmptyRow();
        }
    }

    private void addEmptyRow() {
        this.addRow(null);
    }

    private void addRow(String entry) {
        JComponent item = null;
        switch (this.type) {
            case BIGDECIMAL: 
            case BIGINTEGER: {
                JSpinner spinner = this.createNumberEntry(entry);
                this.spinnerList.add(spinner);
                item = spinner;
                break;
            }
            case STRING: {
                JTextField field = this.createStringEntry(entry);
                this.textFieldList.add(field);
                item = field;
            }
        }
        this.addComponent(item);
    }

    private void addComponent(JComponent item) {
        JButton plusButton = this.createButton(true, item);
        if (this.lastPlus != null) {
            this.lastPlus.setVisible(false);
        }
        this.lastPlus = plusButton;
        JButton minusButton = this.createButton(false, item);
        GridBagConstraints componentConstraints = new GridBagConstraints();
        componentConstraints.anchor = 17;
        componentConstraints.fill = 2;
        componentConstraints.gridx = 0;
        componentConstraints.gridy = this.currentRow;
        componentConstraints.weightx = 1.0;
        this.add((Component)item, componentConstraints);
        GridBagConstraints plusConstraints = new GridBagConstraints();
        plusConstraints.anchor = 17;
        plusConstraints.fill = 0;
        plusConstraints.gridx = 2;
        plusConstraints.gridy = this.currentRow;
        this.add((Component)plusButton, plusConstraints);
        GridBagConstraints minusConstraints = new GridBagConstraints();
        minusConstraints.anchor = 17;
        minusConstraints.fill = 0;
        minusConstraints.gridx = 1;
        minusConstraints.gridy = this.currentRow++;
        minusConstraints.insets = new Insets(0, 10, 0, 10);
        this.add((Component)minusButton, minusConstraints);
    }

    private JButton createButton(boolean isAdd, JComponent item) {
        JButton button = new JButton();
        if (isAdd) {
            button.setIcon(closedIndicator);
            button.addActionListener(new AddRowListener(button, item));
        } else {
            button.setIcon(openedIndicator);
            button.addActionListener(new RemoveRowListener(item));
        }
        button.setOpaque(true);
        button.setFocusPainted(false);
        button.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
        button.setHorizontalAlignment(2);
        button.setMargin(new Insets(0, 0, 0, 0));
        button.setBounds(0, 0, 0, 0);
        button.setContentAreaFilled(false);
        button.setHorizontalTextPosition(11);
        return button;
    }

    private JSpinner createNumberEntry(String value) {
        JSpinner spinner = new JSpinner(){

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                dim.width = 100;
                return dim;
            }
        };
        if (this.type.equals((Object)ScalarListEntryType.BIGDECIMAL)) {
            BigDecimal val = value == null || value.equals("") ? new BigDecimal("0") : new BigDecimal(value);
            spinner.setModel(new SpinnerMathNumberModel(val, null, null, new BigDecimal("0.1")));
        } else {
            BigInteger val = value == null || value.equals("") ? new BigInteger("0") : new BigInteger(value, 10);
            spinner.setModel(new SpinnerMathNumberModel(val, null, null, new BigInteger("1")));
        }
        spinner.setEditor(new MathNumberEditor(spinner, (DecimalFormat)DecimalFormat.getInstance(spinner.getLocale())));
        spinner.addChangeListener(new SpinnerValueChangedListener());
        return spinner;
    }

    private JTextField createStringEntry(String value) {
        JTextField input = new JTextField(value){

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                dim.width = 100;
                return dim;
            }
        };
        input.getDocument().addDocumentListener(new DocumentJoinListener());
        return input;
    }

    private JCheckBox createBooleanEntry(String value) {
        final JCheckBox box = new JCheckBox();
        if (value != null && value.equalsIgnoreCase("true")) {
            box.setSelected(true);
        } else {
            box.setSelected(false);
        }
        box.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ScalarListItem.this.properties.setProperty(ScalarListItem.this.property, Boolean.toString(box.isSelected()));
            }
        });
        return box;
    }

    private void rebuild() {
        this.removeAll();
        this.currentRow = 0;
        if (this.textFieldList == null) {
            this.spinnerList.clear();
        } else {
            this.textFieldList.clear();
        }
        String props = this.properties.getProperty(this.property);
        if (props != null && !props.equals("")) {
            String[] props2;
            for (String entry : props2 = props.split(";")) {
                this.addRow(entry);
            }
        } else {
            this.addEmptyRow();
        }
        this.revalidate();
        this.repaint();
    }

    private class RemoveRowListener
    implements ActionListener {
        private final JComponent item;

        private RemoveRowListener(JComponent item) {
            this.item = item;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ScalarListItem.this.properties.getProperty(ScalarListItem.this.property) != null) {
                if (ScalarListItem.this.textFieldList == null) {
                    if (ScalarListItem.this.type.equals((Object)ScalarListEntryType.BIGDECIMAL)) {
                        String currentVal = ((BigDecimal)((JSpinner)this.item).getModel().getValue()).toPlainString() + ";";
                        String props = ScalarListItem.this.properties.getProperty(ScalarListItem.this.property);
                        props = props.replaceFirst(currentVal, "");
                        ScalarListItem.this.properties.setProperty(ScalarListItem.this.property, props);
                    } else {
                        String currentVal = ((BigInteger)((JSpinner)this.item).getModel().getValue()).toString(10) + ";";
                        String props = ScalarListItem.this.properties.getProperty(ScalarListItem.this.property);
                        props = props.replaceFirst(currentVal, "");
                        ScalarListItem.this.properties.setProperty(ScalarListItem.this.property, props);
                    }
                    ScalarListItem.this.spinnerList.remove((JSpinner)this.item);
                } else {
                    ((JTextField)this.item).setText("");
                    ScalarListItem.this.textFieldList.remove((JTextField)this.item);
                }
            }
            ScalarListItem.this.rebuild();
        }
    }

    private class AddRowListener
    implements ActionListener {
        private final JButton button;
        private final JComponent field;

        private AddRowListener(JButton button, JComponent field) {
            this.button = button;
            this.field = field;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ScalarListItem.this.textFieldList != null && !((JTextField)this.field).getText().equals("")) {
                ScalarListItem.this.addEmptyRow();
                this.button.setVisible(false);
            } else if (ScalarListItem.this.spinnerList != null && ScalarListItem.this.properties.getProperty(ScalarListItem.this.property) != null) {
                ScalarListItem.this.addEmptyRow();
                this.button.setVisible(false);
            }
        }
    }

    private class SpinnerValueChangedListener
    implements ChangeListener {
        private SpinnerValueChangedListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            StringBuilder sb = new StringBuilder();
            for (JSpinner spinner : ScalarListItem.this.spinnerList) {
                if (ScalarListItem.this.type.equals((Object)ScalarListEntryType.BIGDECIMAL)) {
                    BigDecimal dec = (BigDecimal)spinner.getModel().getValue();
                    sb.append(dec.toPlainString());
                } else {
                    BigInteger inte = (BigInteger)spinner.getModel().getValue();
                    sb.append(inte.toString(10));
                }
                sb.append(";");
            }
            ScalarListItem.this.properties.setProperty(ScalarListItem.this.property, sb.toString());
        }
    }

    private class DocumentJoinListener
    implements DocumentListener {
        private DocumentJoinListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            ScalarListItem.this.properties.setProperty(ScalarListItem.this.property, this.joinContent());
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            ScalarListItem.this.properties.setProperty(ScalarListItem.this.property, this.joinContent());
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        private String joinContent() {
            StringBuilder sb = new StringBuilder();
            for (JTextField field : ScalarListItem.this.textFieldList) {
                if (field.getText() == null || field.getText().equals("")) continue;
                sb.append(field.getText());
                sb.append(";");
            }
            return sb.toString();
        }
    }
}

