/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.richclient.gui.components;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.text.NumberFormatter;
import org.openecard.richclient.gui.components.SpinnerMathNumberModel;

public class MathNumberEditorFormatter
extends NumberFormatter {
    private final SpinnerMathNumberModel model;

    public MathNumberEditorFormatter(SpinnerMathNumberModel model, NumberFormat format) {
        this.model = model;
        this.setFormat(format);
        this.setOverwriteMode(false);
        this.setAllowsInvalid(true);
        this.setCommitsOnValidEdit(false);
        this.setValueClass(model.getValue().getClass());
    }

    private Object convertValueToValueClass(Object value, Class valueClass) {
        if (valueClass != null && value instanceof Number) {
            Number numberValue = (Number)value;
            if (valueClass == BigInteger.class) {
                return (BigInteger)numberValue;
            }
            if (valueClass == BigDecimal.class) {
                return (BigDecimal)numberValue;
            }
        }
        return value;
    }

    Object stringToValue(String text, Format f) throws ParseException {
        if (f == null) {
            return text;
        }
        Object value = f.parseObject(text);
        return this.convertValueToValueClass(value, this.getValueClass());
    }
}

