/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.richclient.gui.components;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.openecard.common.I18n;

public class FileChooserItem
extends JFileChooser {
    private final I18n lang = I18n.getTranslation("addon");

    FileChooserItem(String fileTypes) {
        super(new File(System.getProperty("user.home")));
        this.setDialogTitle(this.lang.translationForKey("addon.settings.file.select", new Object[0]));
        this.setFileFilter(new GenericFileTypeFilter(fileTypes));
        this.setDialogType(0);
        this.setFileSelectionMode(2);
    }

    private class GenericFileTypeFilter
    extends FileFilter {
        private final List<String> fileTypes;

        public GenericFileTypeFilter(String fileTypes) {
            String[] types = fileTypes.split(";");
            this.fileTypes = new ArrayList<String>(Arrays.asList(types));
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            int startPosSuffix = file.getName().lastIndexOf(".");
            if (startPosSuffix > -1) {
                for (String elem : this.fileTypes) {
                    String suffix = file.getName().substring(startPosSuffix);
                    if (!(suffix = suffix.replace(".", "")).equalsIgnoreCase(elem)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public String getDescription() {
            StringBuilder msg = new StringBuilder();
            for (String type : this.fileTypes) {
                msg.append(".");
                msg.append(type);
                msg.append(", ");
            }
            return msg.toString();
        }
    }
}

