/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.richclient.gui.components;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import javax.swing.JCheckBox;
import org.openecard.addon.AddonPropertiesException;
import org.openecard.richclient.gui.manage.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckboxListItem
extends JCheckBox {
    private static final Logger logger = LoggerFactory.getLogger(CheckboxListItem.class);
    private final String itemLabel;
    private final String propName;
    private final Settings properties;

    public CheckboxListItem(String name, boolean selected, String propertyName, Settings props) {
        this.setSelected(selected);
        this.setText(name);
        this.itemLabel = name;
        this.propName = propertyName;
        this.properties = props;
        this.construct();
    }

    private void construct() {
        this.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                String propValue = CheckboxListItem.this.properties.getProperty(CheckboxListItem.this.propName);
                if (e.getStateChange() == 1) {
                    if (propValue == null) {
                        CheckboxListItem.this.properties.setProperty(CheckboxListItem.this.propName, CheckboxListItem.this.itemLabel);
                    } else {
                        CheckboxListItem.this.properties.setProperty(CheckboxListItem.this.propName, propValue.concat(";" + CheckboxListItem.this.itemLabel));
                    }
                } else if (e.getStateChange() == 2) {
                    if (propValue.equals(CheckboxListItem.this.itemLabel)) {
                        CheckboxListItem.this.properties.setProperty(CheckboxListItem.this.propName, "");
                    } else if (propValue.contains(";" + CheckboxListItem.this.itemLabel + ";")) {
                        propValue = propValue.replace(";" + CheckboxListItem.this.itemLabel + ";", ";");
                        CheckboxListItem.this.properties.setProperty(CheckboxListItem.this.propName, propValue);
                    } else if (propValue.contains(";" + CheckboxListItem.this.itemLabel)) {
                        propValue = propValue.replace(";" + CheckboxListItem.this.itemLabel, ";");
                        CheckboxListItem.this.properties.setProperty(CheckboxListItem.this.propName, propValue);
                    } else {
                        propValue = propValue.replace(CheckboxListItem.this.itemLabel + ";", "");
                        CheckboxListItem.this.properties.setProperty(CheckboxListItem.this.propName, propValue);
                    }
                }
                try {
                    CheckboxListItem.this.properties.store();
                }
                catch (IOException | AddonPropertiesException ex) {
                    logger.error("Failed to save settings.", ex);
                }
            }
        });
    }
}

