/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.richclient.gui;

import iso.std.iso_iec._24727.tech.schema.CardInfoType;
import iso.std.iso_iec._24727.tech.schema.CardTypeType;
import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.annotation.Nullable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oasis.names.tc.dss._1_0.core.schema.InternationalStringType;
import org.openecard.addon.AddonManager;
import org.openecard.common.AppVersion;
import org.openecard.common.I18n;
import org.openecard.common.event.EventObject;
import org.openecard.common.event.EventType;
import org.openecard.common.interfaces.Environment;
import org.openecard.common.interfaces.EventCallback;
import org.openecard.gui.about.AboutDialog;
import org.openecard.richclient.gui.AppTray;
import org.openecard.richclient.gui.GradientPanel;
import org.openecard.richclient.gui.GuiUtils;
import org.openecard.richclient.gui.InfoPopup;
import org.openecard.richclient.gui.StatusContainer;
import org.openecard.richclient.gui.manage.ManagementDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Status
implements EventCallback {
    private static final Logger LOG = LoggerFactory.getLogger(Status.class);
    private static final String NO_TERMINAL_CONNECTED = "noTerminalConnected";
    private final I18n lang = I18n.getTranslation("richclient");
    private final Map<String, JPanel> infoMap = new ConcurrentSkipListMap<String, JPanel>();
    private final Map<String, EventType> cardStatus = new ConcurrentSkipListMap<String, EventType>();
    private final HashMap<String, ImageIcon> cardIcons = new HashMap();
    private JPanel contentPane;
    private JPanel infoView;
    private JPanel noTerminal;
    private StatusContainer popup;
    private final AppTray appTray;
    private final Environment env;
    private final AddonManager manager;

    public Status(AppTray appTray, Environment env, AddonManager manager) {
        this.appTray = appTray;
        this.env = env;
        this.manager = manager;
        this.setupBaseUI();
    }

    public void showInfo() {
        this.showInfo(null);
    }

    public void showInfo(Point p) {
        if (this.popup != null && this.popup instanceof Window) {
            ((Window)((Object)this.popup)).dispose();
        }
        this.popup = new InfoPopup(this.contentPane, p);
    }

    public void setInfoPanel(StatusContainer frame) {
        this.popup = frame;
        this.popup.setContentPane(this.contentPane);
    }

    private void setupBaseUI() {
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new BorderLayout());
        this.contentPane.setBackground(Color.white);
        this.contentPane.setBorder(BorderFactory.createBevelBorder(0, Color.LIGHT_GRAY, Color.DARK_GRAY));
        this.noTerminal = new JPanel();
        this.noTerminal.setLayout(new FlowLayout(0));
        this.noTerminal.setBackground(Color.white);
        this.noTerminal.add(this.createInfoLabel());
        this.infoMap.put(NO_TERMINAL_CONNECTED, this.noTerminal);
        this.infoView = new JPanel();
        this.infoView.setLayout(new BoxLayout(this.infoView, 3));
        this.infoView.setBackground(Color.white);
        this.infoView.add(Box.createRigidArea(new Dimension(0, 5)));
        this.infoView.add(this.noTerminal);
        JLabel label = new JLabel(" " + this.lang.translationForKey("tray.title", AppVersion.getName()) + " ");
        label.setFont(new Font("SansSerif", 1, 16));
        GradientPanel panel = new GradientPanel(new Color(106, 163, 213), new Color(80, 118, 177));
        panel.setOpaque(false);
        panel.add(label);
        JPanel btnPanel = new JPanel();
        btnPanel.setLayout(new FlowLayout(2));
        btnPanel.setBackground(Color.white);
        JButton btnExit = new JButton(this.lang.translationForKey("tray.exit", new Object[0]));
        btnExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LOG.debug("Shutdown button pressed.");
                try {
                    Status.this.appTray.shutdown();
                }
                catch (Throwable ex) {
                    LOG.error("Exiting client threw an error.", ex);
                    throw ex;
                }
            }
        });
        JButton btnAbout = new JButton(this.lang.translationForKey("tray.about", new Object[0]));
        btnAbout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LOG.debug("About button pressed.");
                try {
                    AboutDialog.showDialog();
                }
                catch (Throwable ex) {
                    LOG.error("Show About dialog threw an error.", ex);
                    throw ex;
                }
            }
        });
        JButton btnSettings = new JButton(this.lang.translationForKey("tray.config", new Object[0]));
        btnSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LOG.debug("Settings button pressed.");
                try {
                    ManagementDialog.showDialog(Status.this.manager);
                }
                catch (Throwable ex) {
                    LOG.error("Show Settings dialog threw an error.", ex);
                    throw ex;
                }
            }
        });
        btnPanel.add(btnSettings);
        btnPanel.add(btnAbout);
        btnPanel.add(btnExit);
        this.contentPane.add((Component)panel, "North");
        this.contentPane.add((Component)this.infoView, "Center");
        this.contentPane.add((Component)btnPanel, "South");
    }

    private synchronized void addInfo(String ifdName, @Nullable ConnectionHandleType.RecognitionInfo info) {
        if (this.infoMap.containsKey(NO_TERMINAL_CONNECTED)) {
            this.infoMap.remove(NO_TERMINAL_CONNECTED);
            this.infoView.removeAll();
        }
        if (this.infoMap.containsKey(ifdName)) {
            return;
        }
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(0));
        panel.add(this.createInfoLabel(ifdName, info));
        this.infoMap.put(ifdName, panel);
        this.infoView.add(panel);
        if (this.popup != null) {
            this.popup.updateContent(this.contentPane);
        }
    }

    private synchronized void updateInfo(String ifdName, @Nullable ConnectionHandleType.RecognitionInfo info) {
        JPanel panel = this.infoMap.get(ifdName);
        if (panel != null) {
            panel.removeAll();
            panel.add(this.createInfoLabel(ifdName, info));
            panel.repaint();
            if (this.popup != null) {
                this.popup.updateContent(this.contentPane);
            }
        }
    }

    private synchronized void removeInfo(String ifdName) {
        JPanel panel = this.infoMap.get(ifdName);
        if (panel != null) {
            this.infoMap.remove(ifdName);
            this.infoView.remove(panel);
            if (this.infoMap.isEmpty()) {
                this.infoMap.put(NO_TERMINAL_CONNECTED, this.noTerminal);
                this.infoView.add(this.noTerminal);
            }
            if (this.popup != null) {
                this.popup.updateContent(this.contentPane);
            }
        }
    }

    private synchronized ImageIcon getCardIcon(String cardType) {
        if (cardType == null) {
            cardType = "http://openecard.org/cif/no-card";
        }
        if (!this.cardIcons.containsKey(cardType)) {
            InputStream is = this.env.getRecognition().getCardImage(cardType);
            if (is == null) {
                is = this.env.getRecognition().getUnknownCardImage();
            }
            ImageIcon icon = GuiUtils.getImageIcon(is);
            this.cardIcons.put(cardType, icon);
        }
        return this.cardIcons.get(cardType);
    }

    private String getCardType(ConnectionHandleType.RecognitionInfo info) {
        if (info != null) {
            String cardType = info.getCardType();
            if (cardType != null) {
                return this.resolveCardType(cardType);
            }
            return this.lang.translationForKey("status.nocard", new Object[0]);
        }
        return this.lang.translationForKey("status.nocard", new Object[0]);
    }

    private String resolveCardType(String cardType) {
        CardTypeType type;
        if (cardType.equals("http://bsi.bund.de/cif/unknown")) {
            return this.lang.translationForKey("status.unknowncard", new Object[0]);
        }
        CardInfoType cif = this.env.getRecognition().getCardInfo(cardType);
        String cardTypeName = cardType;
        if (cif != null && (type = cif.getCardType()) != null) {
            String[] languages;
            boolean found = false;
            block0: for (String language : languages = new String[]{Locale.getDefault().getLanguage(), "en"}) {
                if (found) break;
                List<InternationalStringType> cardTypeNames = type.getCardTypeName();
                for (InternationalStringType ist : cardTypeNames) {
                    if (!ist.getLang().equalsIgnoreCase(language)) continue;
                    cardTypeName = ist.getValue();
                    found = true;
                    continue block0;
                }
            }
        }
        return cardTypeName;
    }

    private JLabel createInfoLabel() {
        return this.createInfoLabel(null, null);
    }

    private JLabel createInfoLabel(String ifdName, @Nullable ConnectionHandleType.RecognitionInfo info) {
        JLabel label = new JLabel();
        if (ifdName != null) {
            String cardType = info != null ? info.getCardType() : "http://openecard.org/cif/no-card";
            label.setIcon(this.getCardIcon(cardType));
            label.setText("<html><b>" + this.getCardType(info) + "</b><br><i>" + ifdName + "</i></html>");
        } else {
            label.setIcon(this.getCardIcon("http://openecard.org/cif/no-terminal"));
            label.setText("<html><i>" + this.lang.translationForKey("status.noterminal", new Object[0]) + "</i></html>");
        }
        label.setIconTextGap(10);
        label.setBackground(Color.white);
        Dimension dim = label.getPreferredSize();
        label.setPreferredSize(new Dimension(dim.width + 10, dim.height));
        return label;
    }

    @Override
    public void signalEvent(EventType eventType, EventObject eventData) {
        LOG.debug("Event: {}", (Object)eventType);
        ConnectionHandleType ch = eventData.getHandle();
        if (ch == null) {
            LOG.error("No handle provided in event {}.", (Object)eventType);
            return;
        }
        LOG.debug("ConnectionHandle: {}", (Object)ch);
        ConnectionHandleType.RecognitionInfo info = ch.getRecognitionInfo();
        LOG.debug("RecognitionInfo: {}", (Object)info);
        String ifdName = ch.getIFDName();
        LOG.debug("IFDName: {}", (Object)ifdName);
        if (null != eventType) {
            switch (eventType) {
                case TERMINAL_ADDED: {
                    this.addInfo(ifdName, info);
                    break;
                }
                case TERMINAL_REMOVED: {
                    this.removeInfo(ifdName);
                    break;
                }
                default: {
                    EventType lastStatus = this.cardStatus.get(ifdName);
                    if (EventType.CARD_RECOGNIZED == lastStatus) {
                        if (EventType.CARD_REMOVED != eventType) break;
                        this.cardStatus.remove(ifdName);
                        this.updateInfo(ifdName, info);
                        break;
                    }
                    if (EventType.CARD_REMOVED == eventType) {
                        this.cardStatus.remove(ifdName);
                    } else {
                        this.cardStatus.put(ifdName, eventType);
                    }
                    this.updateInfo(ifdName, info);
                }
            }
        }
    }
}

