/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.richclient.gui;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import org.openecard.richclient.gui.StatusContainer;

public class InfoPopup
extends JDialog
implements StatusContainer {
    private static final long serialVersionUID = 1L;
    private static final int DISTANCE_TO_TASKBAR = 2;
    private Point point;

    public InfoPopup(Container c) {
        this(c, null);
    }

    public InfoPopup(Container c, Point p) {
        this.point = p;
        this.setupUI(c);
    }

    @Override
    public void updateContent(Container c) {
        this.setContentPane(c);
        this.pack();
        this.repaint();
        this.setLocation(this.calculatePosition(c, this.point));
    }

    private Point calculatePosition(Container c, Point p) {
        int y;
        int x;
        GraphicsEnvironment gEnv = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Rectangle scrnSize = gEnv.getDefaultScreenDevice().getDefaultConfiguration().getBounds();
        Rectangle winSize = gEnv.getMaximumWindowBounds();
        Dimension popupSize = c.getPreferredSize();
        if (winSize.x > 5) {
            x = winSize.x + 2;
            y = p.y > winSize.height / 2 ? p.y - popupSize.height : p.y;
        } else if (winSize.y > 5) {
            x = p.x > winSize.width / 2 ? p.x - popupSize.width : p.x;
            y = winSize.y + 2;
        } else if (scrnSize.width > winSize.width) {
            x = winSize.width - popupSize.width - 2;
            y = p.y > winSize.height / 2 ? p.y - popupSize.height : p.y;
        } else {
            x = p.x > winSize.width / 2 ? p.x - popupSize.width : p.x;
            y = winSize.height - popupSize.height - 2;
        }
        return new Point(x, y);
    }

    private void setupUI(Container c) {
        this.setAlwaysOnTop(true);
        this.setUndecorated(true);
        this.setContentPane(c);
        this.pack();
        if (this.point != null) {
            this.setLocation(this.calculatePosition(c, this.point));
        }
        this.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowLostFocus(WindowEvent e) {
                InfoPopup.this.dispose();
            }
        });
        this.setVisible(true);
    }
}

