/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.richclient;

import ch.qos.logback.core.joran.spi.JoranException;
import iso.std.iso_iec._24727.tech.schema.EstablishContext;
import iso.std.iso_iec._24727.tech.schema.EstablishContextResponse;
import iso.std.iso_iec._24727.tech.schema.Initialize;
import iso.std.iso_iec._24727.tech.schema.ReleaseContext;
import iso.std.iso_iec._24727.tech.schema.Terminate;
import java.io.IOException;
import java.net.BindException;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.openecard.addon.AddonManager;
import org.openecard.common.AppVersion;
import org.openecard.common.ClientEnv;
import org.openecard.common.I18n;
import org.openecard.common.WSHelper;
import org.openecard.common.event.EventDispatcherImpl;
import org.openecard.common.event.EventType;
import org.openecard.common.interfaces.EventCallback;
import org.openecard.common.sal.state.CardStateMap;
import org.openecard.common.sal.state.SALStateCallback;
import org.openecard.control.binding.http.HttpBinding;
import org.openecard.gui.message.DialogType;
import org.openecard.gui.swing.SwingDialogWrapper;
import org.openecard.gui.swing.SwingUserConsent;
import org.openecard.gui.swing.common.GUIDefaults;
import org.openecard.ifd.protocol.pace.PACEProtocolFactory;
import org.openecard.ifd.scio.IFD;
import org.openecard.management.TinyManagement;
import org.openecard.mdlw.event.MwStateCallback;
import org.openecard.mdlw.sal.MiddlewareSAL;
import org.openecard.mdlw.sal.config.MiddlewareConfigLoader;
import org.openecard.mdlw.sal.config.MiddlewareSALConfig;
import org.openecard.recognition.CardRecognitionImpl;
import org.openecard.richclient.LogbackConfig;
import org.openecard.richclient.gui.AppTray;
import org.openecard.richclient.gui.SettingsAndDefaultViewWrapper;
import org.openecard.sal.SelectorSAL;
import org.openecard.sal.TinySAL;
import org.openecard.transport.dispatcher.MessageDispatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RichClient {
    private static final Logger LOG;
    private static final I18n LANG;
    private AppTray tray;
    private HttpBinding httpBinding;
    private ClientEnv env = new ClientEnv();
    private IFD ifd;
    private SelectorSAL sal;
    private AddonManager manager;
    private EventDispatcherImpl eventDispatcher;
    private CardRecognitionImpl recognition;
    private CardStateMap cardStates;
    private byte[] contextHandle;

    public static void main(String[] args) {
        LOG.info("Starting {} {} ...", (Object)AppVersion.getName(), (Object)AppVersion.getVersion());
        RichClient client = new RichClient();
        client.setup();
    }

    public void setup() {
        GUIDefaults.initialize();
        String title = LANG.translationForKey("client.startup.failed.headline", AppVersion.getName());
        String message = null;
        SwingUserConsent gui = new SwingUserConsent(new SwingDialogWrapper());
        try {
            this.tray = new AppTray(this);
            this.tray.beginSetup();
            this.env = new ClientEnv();
            MessageDispatcher dispatcher = new MessageDispatcher(this.env);
            this.env.setDispatcher(dispatcher);
            this.eventDispatcher = new EventDispatcherImpl();
            this.env.setEventDispatcher(this.eventDispatcher);
            TinyManagement management = new TinyManagement(this.env);
            this.env.setManagement(management);
            MiddlewareConfigLoader mwConfigLoader = new MiddlewareConfigLoader();
            List<MiddlewareSALConfig> mwSALConfigs = mwConfigLoader.getMiddlewareSALConfigs();
            this.recognition = new CardRecognitionImpl(this.env);
            this.recognition.setGUI(gui);
            this.env.setRecognition(this.recognition);
            this.cardStates = new CardStateMap();
            SALStateCallback salCallback = new SALStateCallback(this.env, this.cardStates);
            this.eventDispatcher.add(salCallback);
            MwStateCallback mwCallback = new MwStateCallback(this.env, this.cardStates, mwConfigLoader);
            this.eventDispatcher.add(mwCallback);
            this.ifd = new IFD();
            this.ifd.addProtocol("urn:oid:0.4.0.127.0.7.2.2.4", new PACEProtocolFactory());
            this.ifd.setGUI(gui);
            this.ifd.setEnvironment(this.env);
            this.env.setIFD(this.ifd);
            TinySAL mainSal = new TinySAL(this.env, this.cardStates);
            mainSal.setGUI(gui);
            this.sal = new SelectorSAL(mainSal, this.env);
            this.env.setSAL(this.sal);
            this.env.setCIFProvider(this.sal);
            for (MiddlewareSALConfig mwSALConfig : mwSALConfigs) {
                if (mwSALConfig.isDisabled()) continue;
                MiddlewareSAL mwSal = new MiddlewareSAL(this.env, this.cardStates, mwSALConfig);
                mwSal.setGui(gui);
                this.sal.addSpecializedSAL(mwSal);
            }
            SettingsAndDefaultViewWrapper guiWrapper = new SettingsAndDefaultViewWrapper();
            try {
                this.manager = new AddonManager(this.env, gui, this.cardStates, guiWrapper);
                guiWrapper.setAddonManager(this.manager);
                mainSal.setAddonManager(this.manager);
                this.httpBinding = new HttpBinding(24727);
                this.httpBinding.setAddonManager(this.manager);
                this.httpBinding.start();
            }
            catch (BindException e) {
                message = LANG.translationForKey("client.startup.failed.portinuse", AppVersion.getName());
                throw e;
            }
            this.tray.endSetup(this.env, this.manager);
            this.eventDispatcher.add((EventCallback)this.tray.status(), EventType.TERMINAL_ADDED, EventType.TERMINAL_REMOVED, EventType.CARD_INSERTED, EventType.CARD_RECOGNIZED, EventType.CARD_REMOVED);
            this.eventDispatcher.start();
            WSHelper.checkResult(this.sal.initialize(new Initialize()));
            try {
                EstablishContext establishContext = new EstablishContext();
                EstablishContextResponse establishContextResponse = this.ifd.establishContext(establishContext);
                WSHelper.checkResult(establishContextResponse);
                this.contextHandle = establishContextResponse.getContextHandle();
            }
            catch (WSHelper.WSException ex) {
                message = LANG.translationForKey("client.startup.failed.nocontext", new Object[0]);
                throw ex;
            }
            new Timer().schedule((TimerTask)new GCTask(), 5000L);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e);
            if (message == null || message.isEmpty()) {
                message = e.getMessage();
            }
            String msg = String.format("%s%n%n%s", title, message);
            gui.obtainMessageDialog().showMessageDialog(msg, AppVersion.getName(), DialogType.ERROR_MESSAGE);
            this.teardown();
        }
        catch (Throwable ex) {
            LOG.error("Unexpected error occurred. Exiting client.");
            System.exit(1);
        }
    }

    public void teardown() {
        try {
            if (this.eventDispatcher != null) {
                this.eventDispatcher.terminate();
            }
            if (this.manager != null) {
                this.manager.shutdown();
            }
            if (this.httpBinding != null) {
                this.httpBinding.stop();
            }
            if (this.sal != null) {
                Terminate terminate = new Terminate();
                this.sal.terminate(terminate);
            }
            if (this.ifd != null && this.contextHandle != null) {
                ReleaseContext releaseContext = new ReleaseContext();
                releaseContext.setContextHandle(this.contextHandle);
                this.ifd.releaseContext(releaseContext);
            }
        }
        catch (Exception ex) {
            LOG.error("Failed to stop Richclient.", ex);
        }
        System.exit(0);
    }

    static {
        try {
            LogbackConfig.load();
        }
        catch (JoranException | IOException ex) {
            System.err.println("Failed to load logback config from user config.");
            ex.printStackTrace(System.err);
            try {
                LogbackConfig.loadDefault();
            }
            catch (JoranException ex2) {
                System.err.println("Failed to load logback default config.");
                ex.printStackTrace(System.err);
            }
        }
        LOG = LoggerFactory.getLogger(RichClient.class.getName());
        LANG = I18n.getTranslation("richclient");
    }

    private static class GCTask
    extends TimerTask {
        private GCTask() {
        }

        @Override
        public void run() {
            System.gc();
            System.runFinalization();
            System.gc();
            new Timer().schedule((TimerTask)new GCTask(), 300000L);
        }
    }
}

