/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.recognition.staticrepo;

import iso.std.iso_iec._24727.tech.schema.CardInfoType;
import iso.std.iso_iec._24727.tech.schema.GetCardInfoOrACDResponse;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import oasis.names.tc.dss._1_0.core.schema.Result;
import org.openecard.common.WSHelper;
import org.openecard.ws.GetCardInfoOrACD;
import org.openecard.ws.marshal.WSMarshaller;
import org.openecard.ws.marshal.WSMarshallerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class LocalCifRepo
implements GetCardInfoOrACD {
    private static final Logger logger = LoggerFactory.getLogger(LocalCifRepo.class);
    private final WSMarshaller m;
    private final HashMap<String, Document> cifs = new HashMap();

    public LocalCifRepo(WSMarshaller m) throws IOException, WSMarshallerException, SAXException {
        String[] files;
        this.m = m;
        InputStream propStream = LocalCifRepo.getStream("repo-config.properties");
        Properties conf = new Properties();
        conf.load(propStream);
        String fileNames = conf.getProperty("cifFiles");
        for (String next : files = fileNames.split(",")) {
            InputStream cifStream = LocalCifRepo.getStream(next.trim());
            Document cifDoc = m.str2doc(cifStream);
            CardInfoType cif = (CardInfoType)m.unmarshal(cifDoc);
            String cardType = cif.getCardType().getObjectIdentifier();
            this.cifs.put(cardType, cifDoc);
        }
    }

    private static InputStream getStream(String res) throws FileNotFoundException {
        String prefix = "cif-repo/";
        InputStream s = LocalCifRepo.class.getResourceAsStream(prefix + res);
        if (s == null) {
            s = LocalCifRepo.class.getResourceAsStream("/" + prefix + res);
        }
        if (s == null) {
            throw new FileNotFoundException("Unable to load file " + res + ".");
        }
        return s;
    }

    @Override
    public GetCardInfoOrACDResponse getCardInfoOrACD(iso.std.iso_iec._24727.tech.schema.GetCardInfoOrACD parameters) {
        List<String> cardTypes = parameters.getCardTypeIdentifier();
        ArrayList<CardInfoType> cifsResult = new ArrayList<CardInfoType>(cardTypes.size());
        Result result = WSHelper.makeResultOK();
        try {
            if ("http://www.bsi.bund.de/ecard/api/1.1/cardinfo/action#getSpecifiedFile".equals(parameters.getAction())) {
                ArrayList<String> missingTypes = new ArrayList<String>();
                for (String string : cardTypes) {
                    Document document = this.cifs.get(string);
                    if (document == null) {
                        missingTypes.add(string);
                        continue;
                    }
                    cifsResult.add((CardInfoType)this.m.unmarshal(document));
                }
                if (!missingTypes.isEmpty()) {
                    StringBuilder error = new StringBuilder("The following card types could not be found:");
                    for (String string : missingTypes) {
                        error.append("\n  ").append(string);
                    }
                    result = WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/sal#unknownCardType", error.toString());
                }
            } else if ("http://www.bsi.bund.de/ecard/api/1.1/cardinfo/action#getOtherFiles".equals(parameters.getAction())) {
                HashMap<String, Document> cifsTmp = new HashMap<String, Document>();
                cifsTmp.putAll(this.cifs);
                for (String string : cardTypes) {
                    cifsTmp.remove(string);
                }
                for (Map.Entry entry : cifsTmp.entrySet()) {
                    Document document = (Document)entry.getValue();
                    cifsResult.add((CardInfoType)this.m.unmarshal(document));
                }
            } else {
                result = WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/common#internalError", "Given action is unsupported.");
            }
            GetCardInfoOrACDResponse res = (GetCardInfoOrACDResponse)WSHelper.makeResponse(GetCardInfoOrACDResponse.class, result);
            res.getCardInfoOrCapabilityInfo().addAll(cifsResult);
            return res;
        }
        catch (WSMarshallerException ex) {
            String msg = "Failed to unmarshal a CIF document.";
            logger.error(msg, ex);
            result = WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/common#internalError", msg);
            GetCardInfoOrACDResponse getCardInfoOrACDResponse = (GetCardInfoOrACDResponse)WSHelper.makeResponse(GetCardInfoOrACDResponse.class, result);
            return getCardInfoOrACDResponse;
        }
    }
}

