/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.plugins.pinplugin.gui;

import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import java.util.ArrayList;
import java.util.List;
import org.openecard.common.AppVersion;
import org.openecard.common.I18n;
import org.openecard.common.interfaces.Dispatcher;
import org.openecard.gui.UserConsent;
import org.openecard.gui.UserConsentNavigator;
import org.openecard.gui.definition.PasswordField;
import org.openecard.gui.definition.Step;
import org.openecard.gui.definition.Text;
import org.openecard.gui.definition.UserConsentDescription;
import org.openecard.gui.executor.ExecutionEngine;
import org.openecard.plugins.pinplugin.RecognizedState;
import org.openecard.plugins.pinplugin.gui.PUKStepAction;

public class UnblockPINDialog {
    private final I18n lang = I18n.getTranslation("pinplugin");
    private static final String TITLE = "action.unblockpin.userconsent.title";
    private static final String PUKSTEP_DESCRIPTION = "action.unblockpin.userconsent.pukstep.description";
    private static final String PUKSTEP_NATIVE_DESCRIPTION = "action.unblockpin.userconsent.pukstep.native_description";
    private static final String PUKSTEP_TITLE = "action.unblockpin.userconsent.pukstep.title";
    private static final String PUKSTEP_PUK = "action.unblockpin.userconsent.pukstep.puk";
    private static final String ERRORSTEP_TITLE = "action.unblockpin.userconsent.errorstep.title";
    private static final String ERRORSTEP_DESCRIPTION = "action.unblockpin.userconsent.errorstep.description";
    private static final String SUCCESSSTEP_TITLE = "action.unblockpin.userconsent.successstep.title";
    private static final String SUCCESSSTEP_DESCRIPTION = "action.unblockpin.userconsent.successstep.description";
    private final UserConsent gui;
    private final ConnectionHandleType conHandle;
    private RecognizedState state;
    private boolean capturePin;
    private Dispatcher dispatcher;
    public static final String PUK_FIELD = "PUK_FIELD";

    public UnblockPINDialog(UserConsent gui, Dispatcher dispatcher, ConnectionHandleType conHandle, RecognizedState state, boolean capturePin) {
        this.gui = gui;
        this.conHandle = conHandle;
        this.state = state;
        this.capturePin = capturePin;
        this.dispatcher = dispatcher;
    }

    private UserConsentDescription createUserConsentDescription() {
        UserConsentDescription uc = new UserConsentDescription(this.lang.translationForKey(TITLE, AppVersion.getName()));
        uc.getSteps().addAll(this.createSteps());
        return uc;
    }

    private List<Step> createSteps() {
        ArrayList<Step> steps = new ArrayList<Step>();
        if (this.state.equals((Object)RecognizedState.PIN_blocked)) {
            Step pukStep = this.createPUKStep();
            steps.add(pukStep);
            Step successStep = this.createSuccessStep();
            steps.add(successStep);
        } else {
            Step errorStep = this.createErrorStep();
            steps.add(errorStep);
        }
        return steps;
    }

    private Step createSuccessStep() {
        Step successStep = new Step("success", this.lang.translationForKey(SUCCESSSTEP_TITLE, new Object[0]));
        Text i1 = new Text();
        i1.setText(this.lang.translationForKey(SUCCESSSTEP_DESCRIPTION, new Object[0]));
        successStep.getInputInfoUnits().add(i1);
        return successStep;
    }

    private Step createErrorStep() {
        Step errorStep = new Step("insert-card", this.lang.translationForKey(ERRORSTEP_TITLE, new Object[0]));
        Text i1 = new Text();
        i1.setText(this.lang.translationForKey(ERRORSTEP_DESCRIPTION, new Object[0]));
        errorStep.getInputInfoUnits().add(i1);
        return errorStep;
    }

    private Step createPUKStep() {
        Step pukStep = new Step("insert-card", this.lang.translationForKey(PUKSTEP_TITLE, new Object[0]));
        Text i1 = new Text();
        pukStep.getInputInfoUnits().add(i1);
        if (!this.capturePin) {
            pukStep.setInstantReturn(true);
            i1.setText(this.lang.translationForKey(PUKSTEP_NATIVE_DESCRIPTION, new Object[0]));
        } else {
            i1.setText(this.lang.translationForKey(PUKSTEP_DESCRIPTION, new Object[0]));
            PasswordField pukField = new PasswordField(PUK_FIELD);
            pukField.setDescription(this.lang.translationForKey(PUKSTEP_PUK, new Object[0]));
            pukStep.getInputInfoUnits().add(pukField);
        }
        PUKStepAction pinAction = new PUKStepAction(this.capturePin, this.conHandle.getSlotHandle(), this.dispatcher, pukStep);
        pukStep.setAction(pinAction);
        return pukStep;
    }

    public void show() {
        UserConsentNavigator ucr = this.gui.obtainNavigator(this.createUserConsentDescription());
        ExecutionEngine exec = new ExecutionEngine(ucr);
        exec.process();
    }
}

