/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.mdlw.sal.exceptions;

import java.util.HashMap;
import javax.annotation.Nonnull;

public abstract class CryptokiException
extends Exception {
    private static final HashMap<Long, String> ERRORS = new HashMap<Long, String>(){
        {
            this.put(0L, "CKR_OK");
            this.put(1L, "CKR_CANCE0L");
            this.put(2L, "CKR_HOST_MEMORY");
            this.put(3L, "CKR_SLOT_ID_INVALID");
            this.put(5L, "CKR_GENERAL_ERROR");
            this.put(6L, "CKR_FUNCTION_FAILED");
            this.put(7L, "CKR_ARGUMENTS_BAD");
            this.put(8L, "CKR_NO_EVENT");
            this.put(9L, "CKR_NEED_TO_CREATE_THREADS");
            this.put(10L, "CKR_CANT_LOCK");
            this.put(16L, "CKR_ATTRIBUTE_READ_ONLY");
            this.put(17L, "CKR_ATTRIBUTE_SENSITIVE");
            this.put(18L, "CKR_ATTRIBUTE_TYPE_INVALID");
            this.put(19L, "CKR_ATTRIBUTE_VALUE_INVALID");
            this.put(27L, "CKR_ACTION_PROHIBITED");
            this.put(32L, "CKR_DATA_INVALID");
            this.put(33L, "CKR_DATA_LEN_RANGE");
            this.put(48L, "CKR_DEVICE_ERROR");
            this.put(49L, "CKR_DEVICE_MEMORY");
            this.put(50L, "CKR_DEVICE_REMOVED");
            this.put(64L, "CKR_ENCRYPTED_DATA_INVALID");
            this.put(65L, "CKR_ENCRYPTED_DATA_LEN_RANGE");
            this.put(80L, "CKR_FUNCTION_CANCELED");
            this.put(81L, "CKR_FUNCTION_NOT_PARALLEL");
            this.put(84L, "CKR_FUNCTION_NOT_SUPPORTED");
            this.put(96L, "CKR_KEY_HANDLE_INVALID");
            this.put(98L, "CKR_KEY_SIZE_RANGE");
            this.put(99L, "CKR_KEY_TYPE_INCONSISTENT");
            this.put(100L, "CKR_KEY_NOT_NEEDED");
            this.put(101L, "CKR_KEY_CHANGED");
            this.put(102L, "CKR_KEY_NEEDED");
            this.put(103L, "CKR_KEY_INDIGESTIBLE");
            this.put(104L, "CKR_KEY_FUNCTION_NOT_PERMITTED");
            this.put(105L, "CKR_KEY_NOT_WRAPPABLE");
            this.put(106L, "CKR_KEY_UNEXTRACTABLE");
            this.put(112L, "CKR_MECHANISM_INVALID");
            this.put(113L, "CKR_MECHANISM_PARAM_INVALID");
            this.put(130L, "CKR_OBJECT_HANDLE_INVALID");
            this.put(144L, "CKR_OPERATION_ACTIVE");
            this.put(145L, "CKR_OPERATION_NOT_INITIALIZED");
            this.put(160L, "CKR_PIN_INCORRECT");
            this.put(161L, "CKR_PIN_INVALID");
            this.put(162L, "CKR_PIN_LEN_RANGE");
            this.put(163L, "CKR_PIN_EXPIRED");
            this.put(164L, "CKR_PIN_LOCKED");
            this.put(176L, "CKR_SESSION_CLOSED");
            this.put(177L, "CKR_SESSION_COUNT");
            this.put(179L, "CKR_SESSION_HANDLE_INVALID");
            this.put(180L, "CKR_SESSION_PARALLEL_NOT_SUPPORTED");
            this.put(181L, "CKR_SESSION_READ_ONLY");
            this.put(182L, "CKR_SESSION_EXISTS");
            this.put(183L, "CKR_SESSION_READ_ONLY_EXISTS");
            this.put(184L, "CKR_SESSION_READ_WRITE_SO_EXISTS");
            this.put(192L, "CKR_SIGNATURE_INVALID");
            this.put(193L, "CKR_SIGNATURE_LEN_RANGE");
            this.put(208L, "CKR_TEMPLATE_INCOMPLETE");
            this.put(209L, "CKR_TEMPLATE_INCONSISTENT");
            this.put(224L, "CKR_TOKEN_NOT_PRESENT");
            this.put(225L, "CKR_TOKEN_NOT_RECOGNIZED");
            this.put(226L, "CKR_TOKEN_WRITE_PROTECTED");
            this.put(240L, "CKR_UNWRAPPING_KEY_HANDLE_INVALID");
            this.put(241L, "CKR_UNWRAPPING_KEY_SIZE_RANGE");
            this.put(242L, "CKR_UNWRAPPING_KEY_TYPE_INCONSISTENT");
            this.put(256L, "CKR_USER_ALREADY_LOGGED_IN");
            this.put(257L, "CKR_USER_NOT_LOGGED_IN");
            this.put(258L, "CKR_USER_PIN_NOT_INITIALIZED");
            this.put(259L, "CKR_USER_TYPE_INVALID");
            this.put(260L, "CKR_USER_ANOTHER_ALREADY_LOGGED_IN");
            this.put(261L, "CKR_USER_TOO_MANY_TYPES");
            this.put(272L, "CKR_WRAPPED_KEY_INVALID");
            this.put(274L, "CKR_WRAPPED_KEY_LEN_RANGE");
            this.put(275L, "CKR_WRAPPING_KEY_HANDLE_INVALID");
            this.put(276L, "CKR_WRAPPING_KEY_SIZE_RANGE");
            this.put(277L, "CKR_WRAPPING_KEY_TYPE_INCONSISTENT");
            this.put(288L, "CKR_RANDOM_SEED_NOT_SUPPORTED");
            this.put(289L, "CKR_RANDOM_NO_RNG");
            this.put(304L, "CKR_DOMAIN_PARAMS_INVALID");
            this.put(320L, "CKR_CURVE_NOT_SUPPORTED");
            this.put(336L, "CKR_BUFFER_TOO_SMALL");
            this.put(352L, "CKR_SAVED_STATE_INVALID");
            this.put(368L, "CKR_INFORMATION_SENSITIVE");
            this.put(384L, "CKR_STATE_UNSAVEABLE");
            this.put(400L, "CKR_CRYPTOKI_NOT_INITIALIZED");
            this.put(401L, "CKR_CRYPTOKI_ALREADY_INITIALIZED");
            this.put(416L, "CKR_MUTEX_BAD");
            this.put(417L, "CKR_MUTEX_NOT_LOCKED");
            this.put(432L, "CKR_NEW_PIN_MODE");
            this.put(433L, "CKR_NEXT_OTP");
            this.put(437L, "CKR_EXCEEDED_MAX_ITERATIONS");
            this.put(438L, "CKR_FIPS_SELF_TEST_FAILED");
            this.put(439L, "CKR_LIBRARY_LOAD_FAILED");
            this.put(440L, "CKR_PIN_TOO_WEAK");
            this.put(441L, "CKR_PUBLIC_KEY_INVALID");
            this.put(512L, "CKR_FUNCTION_REJECTED");
            this.put(0x80000000L, "CKR_VENDOR_DEFINED");
        }
    };
    private final long errorCode;

    public CryptokiException(String msg, long resultCode) {
        super(msg);
        this.errorCode = resultCode;
    }

    @Override
    public String getMessage() {
        return String.format("[%s] %s", this.getErrorConstantName(), super.getMessage());
    }

    public long getErrorCode() {
        return this.errorCode;
    }

    @Nonnull
    public String getErrorConstantName() {
        return CryptokiException.getErrorConstantName(this.errorCode);
    }

    @Nonnull
    public static String getErrorConstantName(long resultCode) {
        String res = ERRORS.get(resultCode);
        if (res != null && !res.equals("")) {
            return ERRORS.get(resultCode);
        }
        return "UNKOWN ERROR";
    }
}

