/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.mdlw.sal.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiddlewareProperties {
    private static final Logger LOG = LoggerFactory.getLogger(MiddlewareProperties.class);
    private static MiddlewareProperties INST;
    private final Properties props;

    private MiddlewareProperties() {
        this.props = new Properties();
    }

    private MiddlewareProperties(String propsResource) throws IOException {
        InputStream is = this.getClass().getResourceAsStream(propsResource);
        this.props = new Properties();
        this.props.load(is);
    }

    private static synchronized MiddlewareProperties getInstance() {
        if (INST == null) {
            try {
                INST = new MiddlewareProperties("/middleware/mw.properties");
            }
            catch (IOException ex) {
                LOG.error("The bundled properties file could not be loaded.", ex);
                INST = new MiddlewareProperties();
            }
        }
        return INST;
    }

    public static boolean isLoadExternalModules() {
        String val = MiddlewareProperties.getInstance().props.getProperty("modules.load-external", "true");
        return Boolean.parseBoolean(val);
    }

    public static boolean isForceLoadInternalModules() {
        String val = MiddlewareProperties.getInstance().props.getProperty("modules.internal.force-enable", "false");
        return Boolean.parseBoolean(val);
    }
}

