/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.mdlw.sal;

import javax.annotation.Nonnull;
import org.openecard.common.I18n;
import org.openecard.gui.definition.PasswordField;
import org.openecard.gui.definition.Step;
import org.openecard.gui.definition.Text;
import org.openecard.gui.executor.CancelAction;
import org.openecard.mdlw.sal.MwSession;
import org.openecard.mdlw.sal.PinEntryStepAction;
import org.openecard.mdlw.sal.enums.PinState;
import org.openecard.mdlw.sal.exceptions.CryptokiException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PinEntryStep
extends Step {
    private static final Logger LOG = LoggerFactory.getLogger(PinEntryStep.class);
    private static final I18n LANG = I18n.getTranslation("pinplugin");
    public static final String STEP_ID = "sal.middleware.pin-compare.gui-entry.pin-step.id";
    protected static final String PIN_FIELD = "PIN_FIELD";
    private final boolean protectedAuthPath;
    private final MwSession session;
    private PinState pinState;
    private boolean lastTryFailed = false;
    private boolean pinAuthenticated = false;
    private boolean pinBlocked = false;
    private boolean unkownError = false;

    public PinEntryStep(boolean protectedAuthPath, @Nonnull MwSession session) throws CryptokiException {
        super(STEP_ID);
        this.protectedAuthPath = protectedAuthPath;
        this.session = session;
        this.setAction(new PinEntryStepAction(this));
        this.updateState();
    }

    protected MwSession getSession() {
        return this.session;
    }

    boolean isProtectedAuthPath() {
        return this.protectedAuthPath;
    }

    void setPinAuthenticated() {
        this.pinAuthenticated = true;
    }

    void setPinBlocked() {
        this.pinBlocked = true;
    }

    void setUnkownError() {
        this.unkownError = true;
    }

    private void generateGui() {
        if (this.pinBlocked) {
            this.setTitle(LANG.translationForKey("action.error.title", new Object[0]));
            this.setAction(new CancelAction(this));
            this.createBlockedGui();
            return;
        }
        if (this.unkownError) {
            this.setTitle(LANG.translationForKey("action.error.title", new Object[0]));
            this.setAction(new CancelAction(this));
            this.createErrorGui();
            return;
        }
        switch (this.pinState) {
            case PIN_OK: 
            case PIN_COUNT_LOW: 
            case PIN_FINAL_TRY: {
                this.setTitle(LANG.translationForKey("action.changepin.userconsent.pinstep.title", new Object[0]));
                if (this.protectedAuthPath) {
                    this.createPinEntryNativeGui();
                    break;
                }
                this.createPinEntryGui();
                break;
            }
            case PIN_LOCKED: 
            case PIN_NEEDS_CHANGE: 
            case PIN_NOT_INITIALIZED: {
                this.setTitle(LANG.translationForKey("action.error.title", new Object[0]));
                this.setAction(new CancelAction(this));
                this.createBlockedGui();
                break;
            }
            default: {
                String msg = "Invalid pin state found.";
                LOG.error(msg);
                throw new IllegalStateException(msg);
            }
        }
    }

    protected void setLastTryFailed() {
        this.lastTryFailed = true;
    }

    protected final void updateState() throws CryptokiException {
        this.pinState = PinState.getUserPinState(this.session.getSlot().getTokenInfo());
        this.setStatusFlags();
        this.getInputInfoUnits().clear();
        this.generateGui();
    }

    private void setStatusFlags() {
        switch (this.pinState) {
            case PIN_LOCKED: 
            case PIN_NEEDS_CHANGE: 
            case PIN_NOT_INITIALIZED: {
                this.setPinBlocked();
            }
        }
    }

    private void createPinEntryGui() {
        this.setInstantReturn(false);
        if (this.lastTryFailed) {
            this.addVerifyFailed();
        } else {
            String desc = LANG.translationForKey("action.pinentry.userconsent.pinstep.enter_pin", new Object[0]);
            Text descText = new Text(desc);
            this.getInputInfoUnits().add(descText);
        }
        PasswordField pass = new PasswordField(PIN_FIELD);
        pass.setDescription("PIN");
        pass.setMinLength(4);
        this.getInputInfoUnits().add(pass);
        if (this.pinState == PinState.PIN_FINAL_TRY) {
            String noteStr = LANG.translationForKey("action.pinentry.userconsent.pinstep.final_try_note", new Object[0]);
            Text noteText = new Text(noteStr);
            this.getInputInfoUnits().add(noteText);
        }
    }

    private void createPinEntryNativeGui() {
        this.setInstantReturn(true);
        if (this.lastTryFailed) {
            this.addVerifyFailed();
        } else {
            String desc = LANG.translationForKey("action.pinentry.userconsent.pinstep.enter_pin_term", new Object[0]);
            Text descText = new Text(desc);
            this.getInputInfoUnits().add(descText);
        }
        if (this.pinState == PinState.PIN_FINAL_TRY) {
            String noteStr = LANG.translationForKey("action.pinentry.userconsent.pinstep.final_try_note", new Object[0]);
            Text noteText = new Text(noteStr);
            this.getInputInfoUnits().add(noteText);
        }
    }

    private void createBlockedGui() {
        this.setInstantReturn(false);
        this.setReversible(false);
        String errorStr = LANG.translationForKey("action.changepin.userconsent.errorstep.blocked", new Object[0]);
        Text errorText = new Text(errorStr);
        this.getInputInfoUnits().add(errorText);
    }

    private void createErrorGui() {
        this.setInstantReturn(false);
        this.setReversible(false);
        String errorStr = LANG.translationForKey("action.error.internal", new Object[0]);
        Text errorText = new Text(errorStr);
        this.getInputInfoUnits().add(errorText);
    }

    private void addVerifyFailed() {
        Text incorrectInput = new Text();
        incorrectInput.setText(LANG.translationForKey("action.changepin.userconsent.pinstep.incorrect_input", "PIN"));
        this.getInputInfoUnits().add(incorrectInput);
    }

    boolean isPinAuthenticated() {
        return this.pinAuthenticated;
    }

    boolean isPinBlocked() {
        return this.pinBlocked;
    }
}

