/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.mdlw.sal;

import java.util.ArrayList;
import java.util.List;
import org.openecard.mdlw.sal.MiddleWareWrapper;
import org.openecard.mdlw.sal.MwMechanism;
import org.openecard.mdlw.sal.MwModule;
import org.openecard.mdlw.sal.MwSession;
import org.openecard.mdlw.sal.MwToken;
import org.openecard.mdlw.sal.exceptions.CryptokiException;
import org.openecard.mdlw.sal.struct.CkSlot;

public class MwSlot {
    private final MiddleWareWrapper mw;
    private final MwModule module;
    private final CkSlot slotInfo;

    MwSlot(MiddleWareWrapper mw, MwModule module, CkSlot slotInfo) {
        this.mw = mw;
        this.module = module;
        this.slotInfo = slotInfo;
    }

    public CkSlot getSlotInfo() {
        return this.slotInfo;
    }

    public MwToken getTokenInfo() throws CryptokiException {
        return this.mw.getTokenInfo(this.slotInfo.getSlotID());
    }

    public MwSession openSession() throws CryptokiException {
        long handle = this.mw.openSession(this.slotInfo.getSlotID(), 6L);
        MwSession s = new MwSession(this.mw, this, handle);
        return s;
    }

    public List<MwMechanism> getMechanismList() throws CryptokiException {
        long id = this.slotInfo.getSlotID();
        ArrayList<MwMechanism> list = new ArrayList<MwMechanism>();
        long[] arr = this.mw.getMechanismList(id);
        for (int i = 0; i < arr.length; ++i) {
            list.add(this.mw.getMechanismInfo(id, arr[i]));
        }
        return list;
    }
}

