/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.mdlw.sal;

import com.sun.jna.NativeLong;
import com.sun.jna.ptr.NativeLongByReference;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openecard.common.ThreadTerminateException;
import org.openecard.mdlw.sal.MiddleWareWrapper;
import org.openecard.mdlw.sal.MwCertificate;
import org.openecard.mdlw.sal.MwData;
import org.openecard.mdlw.sal.MwPrivateKey;
import org.openecard.mdlw.sal.MwPublicKey;
import org.openecard.mdlw.sal.MwSlot;
import org.openecard.mdlw.sal.cryptoki.CK_ATTRIBUTE;
import org.openecard.mdlw.sal.enums.UserType;
import org.openecard.mdlw.sal.exceptions.CryptokiException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MwSession {
    private static final Logger LOG = LoggerFactory.getLogger(MwSession.class);
    private static final NativeLong CKA_CLASS = new NativeLong(0L);
    private final MiddleWareWrapper mw;
    private final MwSlot slot;
    private final long sessionHandle;

    MwSession(MiddleWareWrapper mw, MwSlot slot, long sessionHandle) throws CryptokiException {
        this.mw = mw;
        this.slot = slot;
        this.sessionHandle = sessionHandle;
    }

    public MwSlot getSlot() {
        return this.slot;
    }

    public void closeSession() throws CryptokiException {
        this.mw.closeSession(this.sessionHandle);
    }

    public List<MwPrivateKey> getPrivateKeys() throws CryptokiException {
        LOG.debug("Trying to get private key objects from middleware.");
        NativeLong privkey = new NativeLong(3L, true);
        NativeLongByReference temp = new NativeLongByReference(privkey);
        CK_ATTRIBUTE pTemplate = new CK_ATTRIBUTE();
        pTemplate.setType(CKA_CLASS);
        pTemplate.setPValue(temp.getPointer());
        pTemplate.setUlValueLen(new NativeLong((long)NativeLong.SIZE));
        List<Long> res = this.findObjects(pTemplate);
        ArrayList<MwPrivateKey> keyList = new ArrayList<MwPrivateKey>();
        for (long l : res) {
            try {
                MwPrivateKey key = new MwPrivateKey(l, this.mw, this);
                LOG.debug("Found private key {} (handle={}).", (Object)key, (Object)l);
                keyList.add(key);
            }
            catch (CryptokiException ex) {
                LOG.warn("Skipping private key due to error.", ex);
            }
        }
        return keyList;
    }

    public List<MwData> getData() throws CryptokiException {
        NativeLongByReference temp = new NativeLongByReference(new NativeLong(0L, true));
        CK_ATTRIBUTE pTemplate = new CK_ATTRIBUTE();
        pTemplate.setType(CKA_CLASS);
        pTemplate.setPValue(temp.getPointer());
        pTemplate.setUlValueLen(new NativeLong((long)NativeLong.SIZE));
        List<Long> res = this.findObjects(pTemplate);
        ArrayList<MwData> dataList = new ArrayList<MwData>();
        for (long l : res) {
            try {
                dataList.add(new MwData(l, this.mw, this));
            }
            catch (CryptokiException ex) {
                LOG.warn("Skipping data object due to error.", ex);
            }
        }
        return dataList;
    }

    public List<MwCertificate> getCertificates() throws CryptokiException {
        NativeLongByReference temp = new NativeLongByReference(new NativeLong(1L, true));
        CK_ATTRIBUTE pTemplate = new CK_ATTRIBUTE();
        pTemplate.setType(CKA_CLASS);
        pTemplate.setPValue(temp.getPointer());
        pTemplate.setUlValueLen(new NativeLong((long)NativeLong.SIZE));
        List<Long> res = this.findObjects(pTemplate);
        ArrayList<MwCertificate> cerList = new ArrayList<MwCertificate>();
        for (long l : res) {
            try {
                cerList.add(new MwCertificate(l, this.mw, this));
            }
            catch (CryptokiException ex) {
                LOG.warn("Skipping certificate due to error.", ex);
            }
        }
        return cerList;
    }

    public List<MwPublicKey> getPublicKeys() throws CryptokiException {
        ArrayList<MwPublicKey> keyList = new ArrayList<MwPublicKey>();
        NativeLongByReference temp = new NativeLongByReference(new NativeLong(2L, true));
        CK_ATTRIBUTE pTemplate = new CK_ATTRIBUTE();
        pTemplate.setType(CKA_CLASS);
        pTemplate.setPValue(temp.getPointer());
        pTemplate.setUlValueLen(new NativeLong((long)NativeLong.SIZE));
        List<Long> res = this.findObjects(pTemplate);
        for (long l : res) {
            try {
                keyList.add(new MwPublicKey(l, this.mw, this));
            }
            catch (CryptokiException ex) {
                LOG.warn("Skipping public key due to error.", ex);
            }
        }
        return keyList;
    }

    public long getSessionId() {
        return this.sessionHandle;
    }

    public void initPin(@Nullable char[] newPin) throws CryptokiException {
        byte[] pin = null;
        if (newPin != null) {
            pin = this.convertPin(newPin);
        }
        try {
            this.mw.initPin(this.sessionHandle, pin);
        }
        finally {
            if (pin != null) {
                Arrays.fill(pin, (byte)0);
            }
        }
    }

    public void initPinExternal() throws CryptokiException {
        this.initPin(null);
    }

    private byte[] convertPin(char[] pin) {
        ByteBuffer bb = StandardCharsets.UTF_8.encode(CharBuffer.wrap(pin));
        byte[] pinBytes = new byte[bb.remaining()];
        bb.get(pinBytes);
        if (bb.hasArray()) {
            Arrays.fill(bb.array(), (byte)0);
        }
        return pinBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void login(@Nonnull UserType userType, @Nullable char[] pPin) throws CryptokiException {
        byte[] pin = null;
        if (pPin != null) {
            pin = this.convertPin(pPin);
        }
        try {
            this.mw.login(this.sessionHandle, userType.getValue(), pin);
        }
        finally {
            if (pin != null) {
                Arrays.fill(pin, (byte)0);
            }
        }
    }

    public void loginExternal(UserType userType) throws CryptokiException {
        this.login(userType, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changePin(@Nullable char[] oldPin, @Nullable char[] newPin) throws CryptokiException {
        byte[] oldPinBytes = null;
        byte[] newPinBytes = null;
        if (oldPin != null) {
            oldPinBytes = this.convertPin(oldPin);
        }
        if (newPin != null) {
            newPinBytes = this.convertPin(newPin);
        }
        try {
            this.mw.setPin(this.sessionHandle, oldPinBytes, newPinBytes);
        }
        finally {
            if (oldPinBytes != null) {
                Arrays.fill(oldPinBytes, (byte)0);
            }
            if (newPinBytes != null) {
                Arrays.fill(newPinBytes, (byte)0);
            }
        }
    }

    public void changePinExternal() throws CryptokiException {
        this.changePin(null, null);
    }

    public void logout() throws CryptokiException {
        this.mw.logout(this.sessionHandle);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<Long> findObjects(CK_ATTRIBUTE pTemplate) throws CryptokiException {
        try (MiddleWareWrapper.LockedMiddlewareWrapper lmw = this.mw.lock();){
            lmw.findObjectsInit(this.sessionHandle, pTemplate, 1);
            List<Long> res = lmw.findObjects(this.sessionHandle);
            lmw.findObjectsFinalize(this.sessionHandle);
            List<Long> list = res;
            return list;
        }
        catch (InterruptedException ex) {
            throw new ThreadTerminateException("Thread interrupted while waiting for Middleware lock.", ex);
        }
    }
}

