/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.mdlw.sal;

import javax.annotation.Nullable;
import org.openecard.mdlw.sal.AttributeUtils;
import org.openecard.mdlw.sal.MiddleWareWrapper;
import org.openecard.mdlw.sal.MwSession;
import org.openecard.mdlw.sal.exceptions.CryptokiException;
import org.openecard.mdlw.sal.struct.CkAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MwAbstractKey {
    private static final Logger LOG = LoggerFactory.getLogger(MwAbstractKey.class);
    protected final long objectHandle;
    protected final MiddleWareWrapper mw;
    protected final MwSession session;
    private final long keyType;
    private final byte[] keyId;
    private final long[] allowedMechanisms;

    public MwAbstractKey(long objectHandle, MiddleWareWrapper mw, MwSession session) throws CryptokiException {
        this.objectHandle = objectHandle;
        this.mw = mw;
        this.session = session;
        this.keyType = this.loadAttrValueKeyType();
        this.keyId = this.loadAttrValueKeyID();
        this.allowedMechanisms = this.loadAttrValAllowedMechanisms();
    }

    @Nullable
    protected CkAttribute getAttributeChecked(int type) throws CryptokiException {
        try {
            return this.mw.getAttributeValue(this.session.getSessionId(), this.objectHandle, type);
        }
        catch (CryptokiException ex) {
            switch ((int)ex.getErrorCode()) {
                case 18: {
                    LOG.debug("Error retrieving attribute value, but ignoring it.", ex);
                    return null;
                }
            }
            throw ex;
        }
    }

    private long loadAttrValueKeyType() throws CryptokiException {
        CkAttribute raw = this.mw.getAttributeValue(this.session.getSessionId(), this.objectHandle, 256L);
        return AttributeUtils.getLong(raw);
    }

    private byte[] loadAttrValueKeyID() throws CryptokiException {
        CkAttribute raw = this.mw.getAttributeValue(this.session.getSessionId(), this.objectHandle, 258L);
        return AttributeUtils.getBytes(raw);
    }

    private long[] loadAttrValAllowedMechanisms() throws CryptokiException {
        CkAttribute raw = this.getAttributeChecked(0x40000600);
        if (raw != null) {
            return AttributeUtils.getLongs(raw);
        }
        LOG.warn("Failed to read allowed mechanisms from key object.");
        return new long[0];
    }

    public long getKeyType() {
        return this.keyType;
    }

    public String getKeyTypeName() {
        switch ((int)this.keyType) {
            case 0: {
                return "CKK_RSA";
            }
            case 1: {
                return "CKK_DSA";
            }
            case 2: {
                return "CKK_ECDSA";
            }
            case 3: {
                return "CKK_EC";
            }
            case 4: {
                return "CKK_X9_42_DH";
            }
            case 5: {
                return "CKK_KEA";
            }
            case 16: {
                return "CKK_GENERIC_SECRET";
            }
            case 17: {
                return "CKK_RC2";
            }
            case 18: {
                return "CKK_RC4";
            }
            case 19: {
                return "CKK_DES";
            }
            case 20: {
                return "CKK_DES2";
            }
            case 21: {
                return "CKK_DES3";
            }
            case 22: {
                return "CKK_CAST";
            }
            case 23: {
                return "CKK_CAST3";
            }
            case 24: {
                return "CKK_CAST128";
            }
            case 25: {
                return "CKK_RC5";
            }
            case 26: {
                return "CKK_IDEA";
            }
            case 27: {
                return "CKK_SKIPJACK";
            }
            case 28: {
                return "CKK_BATON";
            }
            case 29: {
                return "CKK_JUNIPER";
            }
            case 30: {
                return "CKK_CDMF";
            }
            case 31: {
                return "CKK_AES";
            }
            case 32: {
                return "CKK_BLOWFISH";
            }
            case 33: {
                return "CKK_TWOFISH";
            }
            case 34: {
                return "CKK_SECURID";
            }
            case 35: {
                return "CKK_HOTP";
            }
            case 36: {
                return "CKK_ACTI";
            }
            case 37: {
                return "CKK_CAMELLIA";
            }
            case 38: {
                return "CKK_ARIA";
            }
            case 39: {
                return "CKK_MD5_HMAC";
            }
            case 40: {
                return "CKK_SHA_1_HMAC";
            }
            case 41: {
                return "CKK_RIPEMD128_HMAC";
            }
            case 42: {
                return "CKK_RIPEMD160_HMAC";
            }
            case 43: {
                return "CKK_SHA256_HMAC";
            }
            case 44: {
                return "CKK_SHA384_HMAC";
            }
            case 45: {
                return "CKK_SHA512_HMAC";
            }
            case 46: {
                return "CKK_SHA224_HMAC";
            }
            case 47: {
                return "CKK_SEED";
            }
            case 48: {
                return "CKK_GOSTR3410";
            }
            case 49: {
                return "CKK_GOSTR3411";
            }
            case 50: {
                return "CKK_GOST28147";
            }
        }
        return "Unknown key mechanism";
    }

    public byte[] getKeyID() {
        return this.keyId;
    }

    public long[] getAllowedMechanisms() {
        return this.allowedMechanisms;
    }
}

