/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.mdlw.sal;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.NativeLongByReference;
import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.Semaphore;
import javax.annotation.Nullable;
import org.openecard.common.ThreadTerminateException;
import org.openecard.crypto.common.UnsupportedAlgorithmException;
import org.openecard.mdlw.sal.MutexStore;
import org.openecard.mdlw.sal.MwMechanism;
import org.openecard.mdlw.sal.MwToken;
import org.openecard.mdlw.sal.NativeLongArray;
import org.openecard.mdlw.sal.config.MiddlewareSALConfig;
import org.openecard.mdlw.sal.cryptoki.CK_ATTRIBUTE;
import org.openecard.mdlw.sal.cryptoki.CK_C_INITIALIZE_ARGS;
import org.openecard.mdlw.sal.cryptoki.CK_INFO;
import org.openecard.mdlw.sal.cryptoki.CK_MECHANISM;
import org.openecard.mdlw.sal.cryptoki.CK_MECHANISM_INFO;
import org.openecard.mdlw.sal.cryptoki.CK_SESSION_INFO;
import org.openecard.mdlw.sal.cryptoki.CK_SLOT_INFO;
import org.openecard.mdlw.sal.cryptoki.CK_TOKEN_INFO;
import org.openecard.mdlw.sal.cryptoki.CryptokiLibrary;
import org.openecard.mdlw.sal.exceptions.AlreadyInitializedException;
import org.openecard.mdlw.sal.exceptions.AuthenticationException;
import org.openecard.mdlw.sal.exceptions.CancellationException;
import org.openecard.mdlw.sal.exceptions.CryptographicException;
import org.openecard.mdlw.sal.exceptions.CryptokiException;
import org.openecard.mdlw.sal.exceptions.DataInvalidException;
import org.openecard.mdlw.sal.exceptions.GeneralError;
import org.openecard.mdlw.sal.exceptions.InvalidArgumentsException;
import org.openecard.mdlw.sal.exceptions.PinBlockedException;
import org.openecard.mdlw.sal.exceptions.PinIncorrectException;
import org.openecard.mdlw.sal.exceptions.SessionException;
import org.openecard.mdlw.sal.exceptions.TokenException;
import org.openecard.mdlw.sal.struct.CkAttribute;
import org.openecard.mdlw.sal.struct.CkInfo;
import org.openecard.mdlw.sal.struct.CkSlot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiddleWareWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(MiddleWareWrapper.class);
    private final CryptokiLibrary lib;
    private static int libIdx = 0;
    private final Semaphore threadLock;

    public MiddleWareWrapper(MiddlewareSALConfig mwSALConfig) throws UnsatisfiedLinkError {
        String libName = mwSALConfig.getLibName();
        LOG.info("Loading Middleware {}: Library={}", (Object)mwSALConfig.getMiddlewareName(), (Object)libName);
        String arch = System.getProperty("os.arch", "");
        for (String searchPath : mwSALConfig.getSearchPaths()) {
            NativeLibrary.addSearchPath(libName, searchPath);
        }
        if ("x86".equals(arch) || "i386".equals(arch)) {
            for (String x32SearchPath : mwSALConfig.getX32SearchPaths()) {
                NativeLibrary.addSearchPath(libName, x32SearchPath);
            }
        } else if ("amd64".equals(arch) || "ia64".equals(arch)) {
            for (String x64SearchPath : mwSALConfig.getX64SearchPaths()) {
                NativeLibrary.addSearchPath(libName, x64SearchPath);
            }
        }
        HashMap<String, Integer> options = new HashMap<String, Integer>();
        options.put("lib-index", libIdx++);
        this.lib = Native.loadLibrary(libName, CryptokiLibrary.class, options);
        this.threadLock = new Semaphore(1, true);
    }

    private LockedObject lockInternal() throws InterruptedException {
        try {
            this.threadLock.acquire();
            return new LockedObject();
        }
        catch (InterruptedException ex) {
            throw new ThreadTerminateException("Waiting for middleware mutex failed.");
        }
    }

    public LockedMiddlewareWrapper lock() throws InterruptedException {
        this.threadLock.acquire();
        return new LockedMiddlewareWrapper();
    }

    public void initialize(@Nullable CK_C_INITIALIZE_ARGS arg) throws CryptokiException {
        Pointer p = null;
        if (arg != null) {
            p = arg.getPointer();
            arg.write();
        }
        MiddleWareWrapper.check("C_Initialize", this.lib.C_Initialize(p));
    }

    public void initialize() throws CryptokiException {
        try {
            CK_C_INITIALIZE_ARGS arg = new CK_C_INITIALIZE_ARGS();
            arg.setFlags(2L);
            this.initialize(arg);
            return;
        }
        catch (CryptokiException ex) {
            LOG.warn("Failed to initialize middleware to perform locking by itself.");
            try {
                CK_C_INITIALIZE_ARGS arg = new CK_C_INITIALIZE_ARGS();
                arg.setFlags(2L);
                MutexStore mutexStore = new MutexStore();
                arg.setCreateMutex(mutexStore.getCreateMutexFun());
                arg.setDestroyMutex(mutexStore.getDestroyMutexFun());
                arg.setLockMutex(mutexStore.getLockMutexFun());
                arg.setUnlockMutex(mutexStore.getUnlockMutexFun());
                this.initialize(arg);
                return;
            }
            catch (CryptokiException ex2) {
                LOG.warn("Failed to initialize middleware to perform locking with Java locks.");
                LOG.warn("Initializing middleware without thread safety values.");
                this.initialize(null);
                return;
            }
        }
    }

    public void destroy(@Nullable Pointer arg) throws CryptokiException {
        MiddleWareWrapper.check("C_Finalize", this.lib.C_Finalize(arg));
    }

    public void destroy() throws CryptokiException {
        this.destroy(Pointer.NULL);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CkInfo getInfo() throws CryptokiException {
        try (LockedObject lo = this.lockInternal();){
            CK_INFO info = new CK_INFO();
            MiddleWareWrapper.check("C_GetInfo", this.lib.C_GetInfo(info));
            CkInfo ckInfo = new CkInfo(info);
            return ckInfo;
        }
        catch (InterruptedException ex) {
            throw new IllegalStateException("Failed to release lock for middleware access.");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long[] getSlotList(boolean withToken) throws CryptokiException {
        long slotsAvailable = this.getSlotsAvailable(withToken);
        if (slotsAvailable <= 0L) return new long[0];
        NativeLongArray slots = new NativeLongArray((int)slotsAvailable);
        NativeLongByReference slotCountRef = new NativeLongByReference(new NativeLong(slotsAvailable));
        byte tokenPresent = (byte)(withToken ? 1 : 0);
        try (LockedObject lo = this.lockInternal();){
            long[] result;
            MiddleWareWrapper.check("C_GetSlotList", this.lib.C_GetSlotList(tokenPresent, slots.getReference(), slotCountRef));
            long[] lArray = result = slots.getValues(slotCountRef.getValue().intValue());
            return lArray;
        }
        catch (InterruptedException ex) {
            throw new IllegalStateException("Failed to release lock for middleware access.");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long getSlotsAvailable(boolean withToken) throws CryptokiException {
        NativeLongByReference count = new NativeLongByReference();
        byte tokenPresent = (byte)(withToken ? 1 : 0);
        try (LockedObject lo = this.lockInternal();){
            MiddleWareWrapper.check("C_GetSlotList", this.lib.C_GetSlotList(tokenPresent, null, count));
            long l = count.getValue().longValue();
            return l;
        }
        catch (InterruptedException ex) {
            throw new IllegalStateException("Failed to release lock for middleware access.");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CkSlot getSlotInfo(long slotID) throws CryptokiException {
        CK_SLOT_INFO info = new CK_SLOT_INFO();
        try (LockedObject lo = this.lockInternal();){
            MiddleWareWrapper.check("C_GetSlotInfo", this.lib.C_GetSlotInfo(new NativeLong(slotID), info));
            CkSlot ckSlot = new CkSlot(info, slotID);
            return ckSlot;
        }
        catch (InterruptedException ex) {
            throw new IllegalStateException("Failed to release lock for middleware access.");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MwToken getTokenInfo(long slotID) throws CryptokiException {
        CK_TOKEN_INFO pInfo = new CK_TOKEN_INFO();
        try (LockedObject lo = this.lockInternal();){
            MiddleWareWrapper.check("C_GetTokenInfo", this.lib.C_GetTokenInfo(new NativeLong(slotID), pInfo));
            MwToken mwToken = new MwToken(pInfo);
            return mwToken;
        }
        catch (InterruptedException ex) {
            throw new IllegalStateException("Failed to release lock for middleware access.");
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public MwMechanism getMechanismInfo(long slotID, long type) throws CryptokiException {
        CK_MECHANISM_INFO info = new CK_MECHANISM_INFO();
        try {
            Throwable throwable = null;
            try (LockedObject lo = this.lockInternal();){
                MiddleWareWrapper.check("C_GetMechanismInfo", this.lib.C_GetMechanismInfo(new NativeLong(slotID), new NativeLong(type), info));
                try {
                    MwMechanism mwMechanism = new MwMechanism(info, type);
                    return mwMechanism;
                }
                catch (UnsupportedAlgorithmException ex) {
                    try {
                        MiddleWareWrapper.raiseError(112L);
                        throw new IllegalStateException("Unreachable code reached.");
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
            }
        }
        catch (InterruptedException ex) {
            throw new IllegalStateException("Failed to release lock for middleware access.");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long getMechanismListCnt(long slotID) throws CryptokiException {
        NativeLongByReference pulCount = new NativeLongByReference(new NativeLong(0L));
        try (LockedObject lo = this.lockInternal();){
            MiddleWareWrapper.check("C_GetMechanismList", this.lib.C_GetMechanismList(new NativeLong(slotID), null, pulCount));
            long l = pulCount.getValue().longValue();
            return l;
        }
        catch (InterruptedException ex) {
            throw new IllegalStateException("Failed to release lock for middleware access.");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long[] getMechanismList(long slotID) throws CryptokiException {
        long cnt = this.getMechanismListCnt(slotID);
        if (cnt <= 0L) return new long[0];
        NativeLongArray pMechanismList = new NativeLongArray((int)cnt);
        NativeLongByReference pulCount = new NativeLongByReference(new NativeLong(cnt));
        try (LockedObject lo = this.lockInternal();){
            long[] result;
            MiddleWareWrapper.check("C_GetMechanismList", this.lib.C_GetMechanismList(new NativeLong(slotID), pMechanismList.getReference(), pulCount));
            long[] lArray = result = pMechanismList.getValues(pulCount.getValue().intValue());
            return lArray;
        }
        catch (InterruptedException ex) {
            throw new IllegalStateException("Failed to release lock for middleware access.");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long openSession(long slotID, long flags) throws CryptokiException {
        NativeLongByReference session = new NativeLongByReference();
        Memory pApplication = new Memory(NativeLong.SIZE);
        try (LockedObject lo = this.lockInternal();){
            MiddleWareWrapper.check("C_OpenSession", this.lib.C_OpenSession(new NativeLong(slotID), new NativeLong(flags), pApplication, null, session));
            long l = session.getValue().longValue();
            return l;
        }
        catch (InterruptedException ex) {
            throw new IllegalStateException("Failed to release lock for middleware access.");
        }
    }

    public void closeSession(long session) throws CryptokiException {
        try (LockedObject lo = this.lockInternal();){
            MiddleWareWrapper.check("C_CloseSession", this.lib.C_CloseSession(new NativeLong(session)));
        }
        catch (InterruptedException ex) {
            throw new IllegalStateException("Failed to release lock for middleware access.");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CK_SESSION_INFO getSessionInfo(long session) throws CryptokiException {
        NativeLong sessionId = new NativeLong(session);
        CK_SESSION_INFO sessionInfo = new CK_SESSION_INFO();
        try (LockedObject lo = this.lockInternal();){
            MiddleWareWrapper.check("C_CloseSession", this.lib.C_GetSessionInfo(sessionId, sessionInfo));
            CK_SESSION_INFO cK_SESSION_INFO = sessionInfo;
            return cK_SESSION_INFO;
        }
        catch (InterruptedException ex) {
            throw new IllegalStateException("Failed to release lock for middleware access.");
        }
    }

    public void initPin(long hSession, @Nullable byte[] newPin) throws CryptokiException {
        ByteBuffer pinBytes = null;
        NativeLong pinLen = new NativeLong(0L);
        if (newPin != null) {
            pinBytes = ByteBuffer.wrap(newPin);
            pinLen.setValue(newPin.length);
        }
        try (LockedObject lo = this.lockInternal();){
            MiddleWareWrapper.check("C_InitPIN", this.lib.C_InitPIN(new NativeLong(hSession), pinBytes, pinLen));
        }
        catch (InterruptedException ex) {
            throw new IllegalStateException("Failed to release lock for middleware access.");
        }
    }

    public void setPin(long hSession, @Nullable byte[] oldPin, @Nullable byte[] newPin) throws CryptokiException {
        try (LockedObject lo = this.lockInternal();){
            if (oldPin != null && oldPin.length > 0 && newPin != null && newPin.length > 0) {
                NativeLong oldPinlen = new NativeLong((long)oldPin.length);
                ByteBuffer oldPinBytes = ByteBuffer.wrap(oldPin);
                NativeLong newPinLen = new NativeLong((long)newPin.length);
                ByteBuffer newPinBytes = ByteBuffer.wrap(newPin);
                MiddleWareWrapper.check("C_SetPIN", this.lib.C_SetPIN(new NativeLong(hSession), oldPinBytes, oldPinlen, newPinBytes, newPinLen));
            } else {
                MiddleWareWrapper.check("C_SetPIN", this.lib.C_SetPIN(new NativeLong(hSession), (ByteBuffer)null, new NativeLong(0L), (ByteBuffer)null, new NativeLong(0L)));
            }
        }
        catch (InterruptedException ex) {
            throw new IllegalStateException("Failed to release lock for middleware access.");
        }
    }

    public void login(final long hSession, final long userType, @Nullable byte[] pPin) throws CryptokiException {
        ByteBuffer pinBytesTmp = null;
        final NativeLong pinLen = new NativeLong(0L);
        if (pPin != null) {
            pinBytesTmp = ByteBuffer.wrap(pPin);
            pinLen.setValue(pPin.length);
        }
        final ByteBuffer pinBytes = pinBytesTmp;
        try (LockedObject lo = this.lockInternal();){
            FutureTask<Void> task = new FutureTask<Void>(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    MiddleWareWrapper.check("C_Login", MiddleWareWrapper.this.lib.C_Login(new NativeLong(hSession), new NativeLong(userType), pinBytes, pinLen), new Long[]{0L, 256L});
                    return null;
                }
            });
            Thread t = new Thread(task, "Middleware-Login");
            t.setDaemon(true);
            t.start();
            try {
                task.get();
            }
            catch (ExecutionException ex) {
                Throwable cause = ex.getCause();
                if (cause instanceof CryptokiException) {
                    throw (CryptokiException)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new RuntimeException("Unexpected error received during C_Login call.", cause);
            }
            catch (InterruptedException ex) {
                task.cancel(true);
                LOG.info("Interrupted while waiting for C_Login task.", ex);
                throw new ThreadTerminateException("Waiting interrupted by an external thread.", ex);
            }
        }
        catch (InterruptedException ex) {
            throw new IllegalStateException("Failed to release lock for middleware access.");
        }
    }

    public void logout(long hSession) throws CryptokiException {
        try (LockedObject lo = this.lockInternal();){
            MiddleWareWrapper.check("C_Logout", this.lib.C_Logout(new NativeLong(hSession)));
        }
        catch (InterruptedException ex) {
            throw new IllegalStateException("Failed to release lock for middleware access.");
        }
    }

    public CkAttribute getAttributeValue(long hSession, long hObject, long type) throws CryptokiException {
        return this.getAttributeValues(hSession, hObject, type).get(0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<CkAttribute> getAttributeValues(long hSession, long hObject, long ... types) throws CryptokiException {
        CK_ATTRIBUTE baseAttr = new CK_ATTRIBUTE();
        CK_ATTRIBUTE[] attrs = (CK_ATTRIBUTE[])baseAttr.toArray(types.length);
        for (int i = 0; i < types.length; ++i) {
            CK_ATTRIBUTE attr = attrs[i];
            attr.setType(new NativeLong(types[i]));
            attr.setPValue(Pointer.NULL);
            attr.setUlValueLen(new NativeLong(0L));
        }
        try (LockedObject lo = this.lockInternal();){
            MiddleWareWrapper.check("C_GetAttributeValue", this.lib.C_GetAttributeValue(new NativeLong(hSession), new NativeLong(hObject), baseAttr, new NativeLong((long)attrs.length)));
            for (CK_ATTRIBUTE next : attrs) {
                long valueLen = next.getUlValueLen().longValue();
                if (valueLen <= 0L) continue;
                Memory newMem = new Memory(valueLen);
                next.setPValue(newMem);
            }
            MiddleWareWrapper.check("C_GetAttributeValue", this.lib.C_GetAttributeValue(new NativeLong(hSession), new NativeLong(hObject), baseAttr, new NativeLong((long)attrs.length)));
            ArrayList<CkAttribute> result = new ArrayList<CkAttribute>();
            for (CK_ATTRIBUTE next : attrs) {
                CkAttribute resultAttr = new CkAttribute(next.getPValue(), next.getUlValueLen());
                result.add(resultAttr);
            }
            ArrayList<CkAttribute> arrayList = result;
            return arrayList;
        }
        catch (InterruptedException ex) {
            throw new IllegalStateException("Failed to release lock for middleware access.");
        }
    }

    public long waitForSlotEvent(long flags) throws CryptokiException {
        NativeLongByReference pSlot = new NativeLongByReference();
        MiddleWareWrapper.check("C_WaitForSlotEvent", this.lib.C_WaitForSlotEvent(new NativeLong(flags), pSlot, Pointer.NULL));
        return pSlot.getValue().longValue();
    }

    private static void check(String fname, NativeLong result, Long ... validResults) throws CryptokiException {
        if (LOG.isDebugEnabled()) {
            long resultValue = result.longValue();
            String constantName = CryptokiException.getErrorConstantName(resultValue);
            LOG.debug("Return code for {}: {} -> {}", fname, String.format("%#08X", resultValue), constantName);
        }
        if (!Arrays.asList(validResults).contains(result.longValue())) {
            MiddleWareWrapper.raiseError(result.longValue());
        }
    }

    private static void check(String fname, NativeLong result) throws CryptokiException {
        MiddleWareWrapper.check(fname, result, 0L);
    }

    private static void raiseError(long errorCode) throws CryptokiException {
        switch ((int)errorCode) {
            case 401: {
                String msg = "The middleware is already initialized.";
                throw new AlreadyInitializedException(msg, errorCode);
            }
            case 5: {
                String msg = "Some unrecoverable error has occurred.";
                throw new GeneralError(msg, errorCode);
            }
            case 2: {
                String msg = "The computer has insufficient memory to perform the requested function.";
                throw new GeneralError(msg, errorCode);
            }
            case 6: {
                String msg = "The requested function could not be performed.";
                throw new GeneralError(msg, errorCode);
            }
            case 84: {
                String msg = "Function not supported.";
                throw new GeneralError(msg, errorCode);
            }
            case 400: {
                String msg = "The middleware is not initialized.";
                throw new GeneralError(msg, errorCode);
            }
            case 145: {
                String msg = "The operation is not initialized..";
                throw new GeneralError(msg, errorCode);
            }
            case 112: {
                String msg = "Mechanism invalid.";
                throw new GeneralError(msg, errorCode);
            }
            case 179: {
                String msg = "The session handle is invalid.";
                throw new SessionException(msg, errorCode);
            }
            case 176: {
                String msg = "The session has been closed during the execution of the function.";
                throw new SessionException(msg, errorCode);
            }
            case 3: {
                String msg = "Slot ID is invalid.";
                throw new SessionException(msg, errorCode);
            }
            case 96: {
                String msg = "Key handle is invalid.";
                throw new SessionException(msg, errorCode);
            }
            case 130: {
                String msg = "Object handle invalid.";
                throw new SessionException(msg, errorCode);
            }
            case 144: {
                String msg = "There is already an active operation or combination of active operations.";
                throw new SessionException(msg, errorCode);
            }
            case 50: {
                String msg = "The token was removed from its slot during the execution of the function.";
                throw new SessionException(msg, errorCode);
            }
            case 224: {
                String msg = "The token was not present in its slot at the time that the function was invoked.";
                throw new SessionException(msg, errorCode);
            }
            case 101: {
                String msg = "One of the keys specified is not the same key that was being used in the original session.";
                throw new SessionException(msg, errorCode);
            }
            case 49: {
                String msg = "The token does not have sufficient memory to perform the requested function.";
                throw new TokenException(msg, errorCode);
            }
            case 48: {
                String msg = "Some problem has occurred with the token and/or slot.";
                throw new TokenException(msg, errorCode);
            }
            case 258: {
                String msg = "The user PIN is not initialized.";
                throw new TokenException(msg, errorCode);
            }
            case 160: {
                String msg = "Pin incorrect.";
                throw new PinIncorrectException(msg, errorCode);
            }
            case 161: {
                String msg = "The PIN contains invalid characters.";
                throw new PinIncorrectException(msg, errorCode);
            }
            case 162: {
                String msg = "The PIN is too short or too long.";
                throw new PinIncorrectException(msg, errorCode);
            }
            case 440: {
                String msg = "The PIN is too weak.";
                throw new PinIncorrectException(msg, errorCode);
            }
            case 256: {
                String msg = "The user is already logged in.";
                throw new AuthenticationException(msg, errorCode);
            }
            case 260: {
                String msg = "Another user is already logged in.";
                throw new AuthenticationException(msg, errorCode);
            }
            case 164: {
                String msg = "The PIN is locked.";
                throw new PinBlockedException(msg, errorCode);
            }
            case 163: {
                String msg = "The PIN is expired.";
                throw new PinBlockedException(msg, errorCode);
            }
            case 104: {
                String msg = "Use of a key for a cryptographic purpose that the key's attributes are not set to allow it to do.";
                throw new CryptographicException(msg, errorCode);
            }
            case 103: {
                String msg = "Indicates that the value of the specified key cannot be digested for some reason.";
                throw new CryptographicException(msg, errorCode);
            }
            case 102: {
                String msg = "Key used in the original sesion needs to be supplied.";
                throw new CryptographicException(msg, errorCode);
            }
            case 100: {
                String msg = "An extraneous key was supplied.";
                throw new CryptographicException(msg, errorCode);
            }
            case 105: {
                String msg = "Unable to wrap the key as requested.";
                throw new CryptographicException(msg, errorCode);
            }
            case 98: {
                String msg = "The supplied key's size is outside the range of key sizes that it can handle.";
                throw new CryptographicException(msg, errorCode);
            }
            case 99: {
                String msg = "The specified key is not the correct type of key to use with the specified mechanism.";
                throw new CryptographicException(msg, errorCode);
            }
            case 106: {
                String msg = "The specified private or secret key can't be wrapped.";
                throw new CryptographicException(msg, errorCode);
            }
            case 18: {
                String msg = "Attribute type invalid.";
                throw new InvalidArgumentsException(msg, errorCode);
            }
            case 209: {
                String msg = "Template inconsistent.";
                throw new InvalidArgumentsException(msg, errorCode);
            }
            case 7: {
                String msg = "Bad arguments.";
                throw new InvalidArgumentsException(msg, errorCode);
            }
            case 113: {
                String msg = "Invalid parameters were supplied to the mechanism specified to the cryptographic operation.";
                throw new InvalidArgumentsException(msg, errorCode);
            }
            case 80: {
                String msg = "The function has been cancelled.";
                throw new CancellationException(msg, errorCode);
            }
            case 32: {
                String msg = "Data is invalid.";
                throw new DataInvalidException(msg, errorCode);
            }
        }
        String msg = "Undefined error occurred.";
        throw new GeneralError(msg, errorCode);
    }

    public class LockedMiddlewareWrapper
    extends LockedObject {
        public void findObjectsInit(long hSession, CK_ATTRIBUTE pTemplate, int ulCount) throws CryptokiException {
            NativeLong arraySizeRef = new NativeLong((long)ulCount);
            MiddleWareWrapper.check("C_FindObjectsInit", MiddleWareWrapper.this.lib.C_FindObjectsInit(new NativeLong(hSession), pTemplate, arraySizeRef));
        }

        public List<Long> findObjects(long hSession) throws CryptokiException {
            int maxObjects = 2048;
            NativeLongArray phObject = new NativeLongArray(maxObjects);
            NativeLongByReference pulObjectCount = new NativeLongByReference();
            MiddleWareWrapper.check("C_FindObjects", MiddleWareWrapper.this.lib.C_FindObjects(new NativeLong(hSession), phObject.getReference(), new NativeLong((long)maxObjects), pulObjectCount));
            long[] result = phObject.getValues(pulObjectCount.getValue().intValue());
            ArrayList<Long> resultLst = new ArrayList<Long>(result.length);
            for (int i = 0; i < result.length; ++i) {
                resultLst.add(result[i]);
            }
            return resultLst;
        }

        public void findObjectsFinalize(long hSession) throws CryptokiException {
            MiddleWareWrapper.check("C_FindObjectsFinal", MiddleWareWrapper.this.lib.C_FindObjectsFinal(new NativeLong(hSession)));
        }

        public void signInit(long hSession, CK_MECHANISM pMechanism, long hKey) throws CryptokiException {
            MiddleWareWrapper.check("C_SignInit", MiddleWareWrapper.this.lib.C_SignInit(new NativeLong(hSession), pMechanism, new NativeLong(hKey)));
        }

        public byte[] sign(long hSession, byte[] data) throws CryptokiException {
            ByteBuffer dataBuf = ByteBuffer.wrap(data);
            int maxSigLen = 8192;
            ByteBuffer sigValue = ByteBuffer.allocate(maxSigLen);
            NativeLongByReference sigLen = new NativeLongByReference(new NativeLong((long)maxSigLen));
            MiddleWareWrapper.check("C_Sign", MiddleWareWrapper.this.lib.C_Sign(new NativeLong(hSession), dataBuf, new NativeLong((long)data.length), sigValue, sigLen));
            byte[] result = new byte[sigLen.getValue().intValue()];
            sigValue.get(result);
            return result;
        }
    }

    private class LockedObject
    implements Closeable {
        private LockedObject() {
        }

        @Override
        public void close() {
            MiddleWareWrapper.this.threadLock.release();
        }
    }
}

