/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.mdlw.sal;

import iso.std.iso_iec._24727.tech.schema.APIAccessEntryPointName;
import iso.std.iso_iec._24727.tech.schema.AccessControlListType;
import iso.std.iso_iec._24727.tech.schema.AccessRuleType;
import iso.std.iso_iec._24727.tech.schema.ActionNameType;
import iso.std.iso_iec._24727.tech.schema.AlgorithmIdentifierType;
import iso.std.iso_iec._24727.tech.schema.AlgorithmInfoType;
import iso.std.iso_iec._24727.tech.schema.AuthorizationServiceActionName;
import iso.std.iso_iec._24727.tech.schema.CardApplicationServiceActionName;
import iso.std.iso_iec._24727.tech.schema.CardApplicationType;
import iso.std.iso_iec._24727.tech.schema.CardInfoType;
import iso.std.iso_iec._24727.tech.schema.CertificateRefType;
import iso.std.iso_iec._24727.tech.schema.ConnectionServiceActionName;
import iso.std.iso_iec._24727.tech.schema.CryptoMarkerType;
import iso.std.iso_iec._24727.tech.schema.CryptographicServiceActionName;
import iso.std.iso_iec._24727.tech.schema.DIDAuthenticationStateType;
import iso.std.iso_iec._24727.tech.schema.DIDInfoType;
import iso.std.iso_iec._24727.tech.schema.DIDMarkerType;
import iso.std.iso_iec._24727.tech.schema.DIDScopeType;
import iso.std.iso_iec._24727.tech.schema.DataSetInfoType;
import iso.std.iso_iec._24727.tech.schema.DifferentialIdentityServiceActionName;
import iso.std.iso_iec._24727.tech.schema.DifferentialIdentityType;
import iso.std.iso_iec._24727.tech.schema.NamedDataServiceActionName;
import iso.std.iso_iec._24727.tech.schema.PathType;
import iso.std.iso_iec._24727.tech.schema.SecurityConditionType;
import java.io.ByteArrayInputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.openecard.common.util.ByteUtils;
import org.openecard.crypto.common.SignatureAlgorithms;
import org.openecard.crypto.common.UnsupportedAlgorithmException;
import org.openecard.mdlw.sal.MwCertificate;
import org.openecard.mdlw.sal.MwMechanism;
import org.openecard.mdlw.sal.MwPublicKey;
import org.openecard.mdlw.sal.MwSession;
import org.openecard.mdlw.sal.didfactory.CryptoMarkerBuilder;
import org.openecard.mdlw.sal.exceptions.CryptokiException;
import org.openecard.mdlw.sal.exceptions.NoCertificateChainException;
import org.openecard.ws.marshal.WSMarshallerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CIFCreator {
    private static final Logger LOG = LoggerFactory.getLogger(CIFCreator.class);
    private final MwSession session;
    private final CardInfoType cif;
    private String PIN_NAME;
    private CertificateFactory certFactory;

    public CIFCreator(MwSession session, CardInfoType cifTemplate) {
        this.session = session;
        this.cif = cifTemplate;
    }

    public CardInfoType addTokenInfo() throws WSMarshallerException, CryptokiException {
        LOG.debug("Adding information to CardInfo file for card type {}.", (Object)this.cif.getCardType().getObjectIdentifier());
        DIDInfoType pinDid = this.getPinDID();
        List<DIDInfoType> cryptoDids = this.getSignatureCryptoDIDs();
        List<DataSetInfoType> datasets = this.getCertificateDatasets();
        CardApplicationType app = this.cif.getApplicationCapabilities().getCardApplication().get(0);
        app.getDIDInfo().addAll(cryptoDids);
        app.getDataSetInfo().addAll(datasets);
        return this.cif;
    }

    private DIDInfoType getPinDID() {
        this.PIN_NAME = "USER_PIN";
        return null;
    }

    private List<DIDInfoType> getSignatureCryptoDIDs() throws WSMarshallerException, CryptokiException {
        LOG.debug("Reading infos for CryptoDID generation.");
        ArrayList<DIDInfoType> didInfos = new ArrayList<DIDInfoType>();
        List<MwPublicKey> pubKeys = this.session.getPublicKeys();
        for (MwPublicKey pubKey : pubKeys) {
            LOG.debug("Found key object {}.", (Object)pubKey);
            if (!Boolean.TRUE.equals(pubKey.getVerify())) {
                LOG.info("Skipping non-signing key {}.", (Object)pubKey.getKeyLabel());
                continue;
            }
            try {
                List<MwCertificate> mwCerts = this.createChain(this.session.getCertificates(), pubKey.getKeyID());
                if (mwCerts.isEmpty()) {
                    LOG.info("No certificates available for the key object.");
                    continue;
                }
                MwCertificate eeCert = mwCerts.get(0);
                switch (eeCert.getCertificateCategory()) {
                    case CK_CERTIFICATE_CATEGORY_TOKEN_USER: 
                    case CK_CERTIFICATE_CATEGORY_UNSPECIFIED: {
                        break;
                    }
                    default: {
                        LOG.info("Skipping key '{}' as certificate has wrong category.", (Object)pubKey.getKeyLabel());
                    }
                }
                if (!this.canSign(eeCert)) {
                    LOG.info("Certificate '{}' can not be used to perform a signature.", (Object)eeCert.getLabel());
                    continue;
                }
                List<MwMechanism> allMechanisms = this.session.getSlot().getMechanismList();
                for (MwMechanism mechanism : allMechanisms) {
                    try {
                        if (!mechanism.isSignatureAlgorithm()) continue;
                        SignatureAlgorithms sigalg = mechanism.getSignatureAlgorithm();
                        LOG.debug("Card signature algorithm: {}", (Object)sigalg);
                        long keyType = sigalg.getKeyType().getPkcs11Mechanism();
                        if (keyType != pubKey.getKeyType()) continue;
                        LOG.debug("Allowing signature algorithm: {}", (Object)sigalg);
                        DIDInfoType did = this.createCryptoDID(mwCerts, sigalg);
                        didInfos.add(did);
                    }
                    catch (UnsupportedAlgorithmException unsupportedAlgorithmException) {}
                }
            }
            catch (NoCertificateChainException ex) {
                LOG.warn("Could not create a certificate chain for requested key.", ex);
            }
        }
        return didInfos;
    }

    private List<MwCertificate> createChain(List<MwCertificate> unsortedCerts, byte[] keyId) throws NoCertificateChainException {
        ArrayList<MwCertificate> sortedCerts = new ArrayList<MwCertificate>();
        MwCertificate endEntity = null;
        for (MwCertificate cert : unsortedCerts) {
            if (!ByteUtils.compare(cert.getID(), keyId)) continue;
            sortedCerts.add(cert);
            endEntity = cert;
            break;
        }
        if (endEntity == null) {
            throw new NoCertificateChainException("No certificate chain found for requested key.");
        }
        MwCertificate currentCert = endEntity;
        while (!ByteUtils.compare(currentCert.getSubject(), currentCert.getIssuer())) {
            boolean nothingFound = true;
            for (MwCertificate cert : unsortedCerts) {
                if (!ByteUtils.compare(cert.getSubject(), currentCert.getIssuer()) || sortedCerts.contains(cert)) continue;
                sortedCerts.add(cert);
                currentCert = cert;
                nothingFound = false;
                break;
            }
            if (!nothingFound) continue;
            LOG.warn("Certificate chain is not complete.");
            break;
        }
        return sortedCerts;
    }

    private DIDInfoType createCryptoDID(List<MwCertificate> mwCerts, SignatureAlgorithms sigalg) throws WSMarshallerException {
        LOG.debug("Creating Crypto DID object.");
        DIDInfoType di = new DIDInfoType();
        String keyLabel = mwCerts.get(0).getLabel();
        DifferentialIdentityType did = new DifferentialIdentityType();
        di.setDifferentialIdentity(did);
        String didName = keyLabel + "_" + mwCerts.get(0).getLabel() + "_" + sigalg.getJcaAlg();
        LOG.debug("DIDName: {}", (Object)didName);
        did.setDIDName(didName);
        did.setDIDProtocol("urn:oid:1.3.162.15480.3.0.25");
        did.setDIDScope(DIDScopeType.LOCAL);
        CryptoMarkerBuilder markerBuilder = new CryptoMarkerBuilder();
        AlgorithmInfoType algInfo = new AlgorithmInfoType();
        algInfo.setAlgorithm(sigalg.getJcaAlg());
        AlgorithmIdentifierType algIdentifier = new AlgorithmIdentifierType();
        algIdentifier.setAlgorithm(sigalg.getAlgId());
        algInfo.setAlgorithmIdentifier(algIdentifier);
        algInfo.getSupportedOperations().add("Compute-signature");
        markerBuilder.setAlgInfo(algInfo);
        markerBuilder.setLegacyKeyname(keyLabel);
        for (MwCertificate nextCert : mwCerts) {
            CertificateRefType certRef = new CertificateRefType();
            certRef.setDataSetName(nextCert.getLabel());
            markerBuilder.getCertRefs().add(certRef);
        }
        CryptoMarkerType marker = markerBuilder.build();
        DIDMarkerType markerWrapper = new DIDMarkerType();
        markerWrapper.setCryptoMarker(marker);
        did.setDIDMarker(markerWrapper);
        AccessControlListType acl = new AccessControlListType();
        di.setDIDACL(acl);
        List<AccessRuleType> rules = acl.getAccessRule();
        rules.add(this.createRuleTrue(AuthorizationServiceActionName.ACL_LIST));
        rules.add(this.createRuleTrue(DifferentialIdentityServiceActionName.DID_GET));
        AccessRuleType signRule = this.createRuleTrue(CryptographicServiceActionName.SIGN);
        signRule.setSecurityCondition(this.createDidCond(this.PIN_NAME));
        rules.add(signRule);
        return di;
    }

    private List<DataSetInfoType> getCertificateDatasets() throws CryptokiException {
        ArrayList<DataSetInfoType> datasets = new ArrayList<DataSetInfoType>();
        List<MwCertificate> mwCerts = this.session.getCertificates();
        for (MwCertificate cert : mwCerts) {
            DataSetInfoType ds = new DataSetInfoType();
            ds.setDataSetName(cert.getLabel());
            PathType path = new PathType();
            ds.setDataSetPath(path);
            path.setEfIdOrPath(new byte[]{-1});
            AccessControlListType acl = new AccessControlListType();
            ds.setDataSetACL(acl);
            List<AccessRuleType> rules = acl.getAccessRule();
            rules.add(this.createRuleTrue(AuthorizationServiceActionName.ACL_LIST));
            rules.add(this.createRuleTrue(NamedDataServiceActionName.DSI_READ));
            rules.add(this.createRuleTrue(NamedDataServiceActionName.DSI_LIST));
            rules.add(this.createRuleTrue(NamedDataServiceActionName.DATA_SET_SELECT));
            datasets.add(ds);
        }
        return datasets;
    }

    private AccessRuleType createRuleTrue(AuthorizationServiceActionName actionName) {
        AccessRuleType rule = new AccessRuleType();
        rule.setCardApplicationServiceName("AuthorizationService");
        rule.setAction(this.createAction(actionName));
        rule.setSecurityCondition(this.createTrueCond());
        return rule;
    }

    private AccessRuleType createRuleTrue(NamedDataServiceActionName actionName) {
        AccessRuleType rule = new AccessRuleType();
        rule.setCardApplicationServiceName("NamedDataService");
        rule.setAction(this.createAction(actionName));
        rule.setSecurityCondition(this.createTrueCond());
        return rule;
    }

    private AccessRuleType createRuleTrue(DifferentialIdentityServiceActionName actionName) {
        AccessRuleType rule = new AccessRuleType();
        rule.setCardApplicationServiceName("DifferentialIdentityService");
        rule.setAction(this.createAction(actionName));
        rule.setSecurityCondition(this.createTrueCond());
        return rule;
    }

    private AccessRuleType createRuleTrue(CryptographicServiceActionName actionName) {
        AccessRuleType rule = new AccessRuleType();
        rule.setCardApplicationServiceName("CryptographicService");
        rule.setAction(this.createAction(actionName));
        rule.setSecurityCondition(this.createTrueCond());
        return rule;
    }

    private SecurityConditionType createTrueCond() {
        SecurityConditionType cond = new SecurityConditionType();
        cond.setAlways(true);
        return cond;
    }

    private SecurityConditionType createDidCond(String didName) {
        SecurityConditionType cond = new SecurityConditionType();
        DIDAuthenticationStateType authState = new DIDAuthenticationStateType();
        authState.setDIDName(didName);
        authState.setDIDState(true);
        cond.setDIDAuthentication(authState);
        return cond;
    }

    private ActionNameType createAction(APIAccessEntryPointName actionName) {
        ActionNameType action = new ActionNameType();
        action.setAPIAccessEntryPoint(actionName);
        return action;
    }

    private ActionNameType createAction(AuthorizationServiceActionName actionName) {
        ActionNameType action = new ActionNameType();
        action.setAuthorizationServiceAction(actionName);
        return action;
    }

    private ActionNameType createAction(CardApplicationServiceActionName actionName) {
        ActionNameType action = new ActionNameType();
        action.setCardApplicationServiceAction(actionName);
        return action;
    }

    private ActionNameType createAction(ConnectionServiceActionName actionName) {
        ActionNameType action = new ActionNameType();
        action.setConnectionServiceAction(actionName);
        return action;
    }

    private ActionNameType createAction(CryptographicServiceActionName actionName) {
        ActionNameType action = new ActionNameType();
        action.setCryptographicServiceAction(actionName);
        return action;
    }

    private ActionNameType createAction(DifferentialIdentityServiceActionName actionName) {
        ActionNameType action = new ActionNameType();
        action.setDifferentialIdentityServiceAction(actionName);
        return action;
    }

    private ActionNameType createAction(NamedDataServiceActionName actionName) {
        ActionNameType action = new ActionNameType();
        action.setNamedDataServiceAction(actionName);
        return action;
    }

    private ActionNameType createAction(String actionName) {
        ActionNameType action = new ActionNameType();
        action.setLoadedAction(actionName);
        return action;
    }

    private boolean canSign(MwCertificate eeCert) {
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(eeCert.getValue());
            X509Certificate cert = (X509Certificate)this.getCertFactory().generateCertificate(in);
            if (cert.getBasicConstraints() != -1) {
                return false;
            }
            boolean[] certUsage = cert.getKeyUsage();
            boolean authCert = certUsage[0];
            boolean signCert = certUsage[1];
            return authCert || signCert;
        }
        catch (NullPointerException | CertificateException ex) {
            LOG.error("Failed to parse certificate.");
            return false;
        }
    }

    private CertificateFactory getCertFactory() throws CertificateException {
        if (this.certFactory == null) {
            this.certFactory = CertificateFactory.getInstance("X.509");
        }
        return this.certFactory;
    }
}

