/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.mdlw.event;

import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import javax.annotation.Nonnull;
import org.openecard.common.event.EventObject;
import org.openecard.common.util.ByteUtils;
import org.openecard.mdlw.sal.MwSlot;

public class MwEventObject
extends EventObject {
    private final MwSlot slot;

    public MwEventObject(@Nonnull ConnectionHandleType handle, MwSlot slot) {
        super(handle);
        this.slot = slot;
    }

    public MwSlot getMwSlot() {
        return this.slot;
    }

    @Override
    @Nonnull
    public ConnectionHandleType getHandle() {
        return super.getHandle();
    }

    public String toString() {
        ConnectionHandleType handle = this.getHandle();
        String ifdName = handle.getIFDName();
        String slotHandle = ByteUtils.toHexString(handle.getSlotHandle());
        ConnectionHandleType.RecognitionInfo recInfo = handle.getRecognitionInfo();
        String cardType = recInfo != null ? recInfo.getCardType() : null;
        return String.format("MwEventObject={ifdName=%s, slot=%s, cardType=%s}", ifdName, slotHandle, cardType);
    }
}

