/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.ifd.scio.wrapper;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import org.openecard.common.apdu.common.CardCommandAPDU;
import org.openecard.common.apdu.common.CardCommandStatus;
import org.openecard.common.apdu.common.CardResponseAPDU;
import org.openecard.common.ifd.Protocol;
import org.openecard.common.ifd.scio.SCIOCard;
import org.openecard.common.ifd.scio.SCIOChannel;
import org.openecard.common.ifd.scio.SCIOErrorCode;
import org.openecard.common.ifd.scio.SCIOException;
import org.openecard.common.ifd.scio.SCIOProtocol;
import org.openecard.common.ifd.scio.SCIOTerminal;
import org.openecard.common.util.ByteUtils;
import org.openecard.ifd.scio.TransmitException;
import org.openecard.ifd.scio.wrapper.IfdChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleThreadChannel
implements IfdChannel {
    private static final Logger LOG = LoggerFactory.getLogger(SingleThreadChannel.class);
    private static final AtomicInteger THREAD_NUM = new AtomicInteger(1);
    private final ExecutorService exec = Executors.newSingleThreadExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            int num = SingleThreadChannel.this.channel.getChannelNumber();
            String termName = SingleThreadChannel.this.channel.getCard().getTerminal().getName();
            String name = String.format("Channel-%d %d '%s'", THREAD_NUM.getAndIncrement(), num, termName);
            Thread t = new Thread(r, name);
            t.setDaemon(true);
            return t;
        }
    });
    private SCIOChannel channel;
    private Protocol smProtocol = null;

    public SingleThreadChannel(SCIOTerminal term, boolean isBasic) throws SCIOException {
        SCIOCard card = SingleThreadChannel.connectCard(term);
        this.channel = isBasic ? card.getBasicChannel() : card.openLogicalChannel();
    }

    @Override
    public void shutdown() throws SCIOException {
        this.exec.shutdown();
        this.channel.close();
    }

    private static SCIOCard connectCard(SCIOTerminal term) throws SCIOException {
        SCIOCard card;
        try {
            card = term.connect(SCIOProtocol.T1);
        }
        catch (SCIOException e1) {
            try {
                card = term.connect(SCIOProtocol.TCL);
            }
            catch (SCIOException e2) {
                try {
                    card = term.connect(SCIOProtocol.T0);
                }
                catch (SCIOException e3) {
                    try {
                        card = term.connect(SCIOProtocol.ANY);
                    }
                    catch (SCIOException ex) {
                        throw new SCIOException("Reader refused to connect card with any protocol.", ex.getCode());
                    }
                }
            }
        }
        LOG.info("Card connected with protocol {}.", (Object)card.getProtocol());
        return card;
    }

    @Override
    public void reconnect() throws SCIOException {
        if (!this.channel.isBasicChannel()) {
            throw new RuntimeException("Reconnect called on logical channel.");
        }
        SCIOCard card = this.channel.getCard();
        SCIOTerminal term = card.getTerminal();
        this.channel.close();
        card.disconnect(true);
        card = SingleThreadChannel.connectCard(term);
        this.channel = card.getBasicChannel();
        this.removeSecureMessaging();
    }

    @Override
    @Nonnull
    public SCIOChannel getChannel() {
        return this.channel;
    }

    @Nonnull
    private CardResponseAPDU transmit(final @Nonnull byte[] command) throws SCIOException, IllegalStateException {
        Future<CardResponseAPDU> result = this.exec.submit(new Callable<CardResponseAPDU>(){

            @Override
            public CardResponseAPDU call() throws Exception {
                return SingleThreadChannel.this.channel.transmit(command);
            }
        });
        try {
            return result.get();
        }
        catch (ExecutionException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof SCIOException) {
                throw (SCIOException)cause;
            }
            if (cause instanceof IllegalStateException) {
                throw (IllegalStateException)cause;
            }
            if (cause instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)cause;
            }
            if (cause instanceof NullPointerException) {
                throw (NullPointerException)cause;
            }
            String msg = "Unknown error during APDU submission.";
            throw new SCIOException(msg, SCIOErrorCode.SCARD_F_UNKNOWN_ERROR, cause);
        }
        catch (InterruptedException ex) {
            result.cancel(true);
            throw new IllegalStateException("Running command cancelled during execution.");
        }
    }

    @Nonnull
    private CardResponseAPDU transmit(@Nonnull CardCommandAPDU command) throws SCIOException, IllegalStateException {
        return this.transmit(command.toByteArray());
    }

    @Override
    @Nonnull
    public byte[] transmit(@Nonnull byte[] input, @Nonnull List<byte[]> responses) throws TransmitException, SCIOException, IllegalStateException {
        byte[] inputAPDU = input;
        if (this.isSM()) {
            LOG.debug("Apply secure messaging to APDU: {}", (Object)ByteUtils.toHexString(inputAPDU, true));
            inputAPDU = this.smProtocol.applySM(inputAPDU);
        }
        LOG.debug("Send APDU: {}", (Object)ByteUtils.toHexString(inputAPDU, true));
        CardResponseAPDU rapdu = this.transmit(inputAPDU);
        byte[] result = rapdu.toByteArray();
        LOG.debug("Receive APDU: {}", (Object)ByteUtils.toHexString(result, true));
        if (this.isSM()) {
            result = this.smProtocol.removeSM(result);
            LOG.debug("Remove secure messaging from APDU: {}", (Object)ByteUtils.toHexString(result, true));
        }
        byte[] sw = new byte[]{result[result.length - 2], result[result.length - 1]};
        if (responses.isEmpty()) {
            return result;
        }
        for (byte[] expected : responses) {
            if (!ByteUtils.isPrefix(expected, sw)) continue;
            return result;
        }
        String msg = "The returned status code is not in the list of expected status codes. The returned code is:\n";
        TransmitException tex = new TransmitException(result, msg + CardCommandStatus.getMessage(sw));
        throw tex;
    }

    @Override
    @Nonnull
    public byte[] transmitControlCommand(final int controlCode, final @Nonnull byte[] command) throws SCIOException, IllegalStateException, NullPointerException {
        Future<byte[]> result = this.exec.submit(new Callable<byte[]>(){

            @Override
            public byte[] call() throws Exception {
                return SingleThreadChannel.this.channel.getCard().transmitControlCommand(controlCode, command);
            }
        });
        try {
            return result.get();
        }
        catch (ExecutionException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof SCIOException) {
                throw (SCIOException)cause;
            }
            if (cause instanceof IllegalStateException) {
                throw (IllegalStateException)cause;
            }
            if (cause instanceof NullPointerException) {
                throw (NullPointerException)cause;
            }
            String msg = "Unknown error during control command submission.";
            throw new SCIOException(msg, SCIOErrorCode.SCARD_F_UNKNOWN_ERROR, cause);
        }
        catch (InterruptedException ex) {
            result.cancel(true);
            throw new IllegalStateException("Running command cancelled during execution.");
        }
    }

    @Override
    public void beginExclusive() throws SCIOException, IllegalStateException {
        this.submitTransaction(true);
    }

    @Override
    public void endExclusive() throws SCIOException, IllegalStateException {
        this.submitTransaction(false);
    }

    private void submitTransaction(final boolean start) throws SCIOException, IllegalStateException {
        Future<Void> result = this.exec.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                SCIOCard card = SingleThreadChannel.this.channel.getCard();
                if (start) {
                    card.beginExclusive();
                } else {
                    card.endExclusive();
                }
                return null;
            }
        });
        try {
            result.get();
        }
        catch (ExecutionException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof SCIOException) {
                throw (SCIOException)cause;
            }
            if (cause instanceof IllegalStateException) {
                throw (IllegalStateException)cause;
            }
            String msg = String.format("Unknown error during transaction submission (start=%b).", start);
            throw new SCIOException(msg, SCIOErrorCode.SCARD_F_UNKNOWN_ERROR, cause);
        }
        catch (InterruptedException ex) {
            result.cancel(true);
            throw new IllegalStateException("Running command cancelled during execution.");
        }
    }

    @Override
    public boolean isSM() {
        boolean result = this.smProtocol != null;
        return result;
    }

    @Override
    public void addSecureMessaging(Protocol protocol) {
        this.smProtocol = protocol;
    }

    @Override
    public void removeSecureMessaging() {
        this.smProtocol = null;
    }
}

