/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.ifd.scio;

import iso.std.iso_iec._24727.tech.schema.ActionType;
import iso.std.iso_iec._24727.tech.schema.BeginTransaction;
import iso.std.iso_iec._24727.tech.schema.BeginTransactionResponse;
import iso.std.iso_iec._24727.tech.schema.BioSensorCapabilityType;
import iso.std.iso_iec._24727.tech.schema.Cancel;
import iso.std.iso_iec._24727.tech.schema.CancelResponse;
import iso.std.iso_iec._24727.tech.schema.ChannelHandleType;
import iso.std.iso_iec._24727.tech.schema.Connect;
import iso.std.iso_iec._24727.tech.schema.ConnectResponse;
import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import iso.std.iso_iec._24727.tech.schema.ControlIFD;
import iso.std.iso_iec._24727.tech.schema.ControlIFDResponse;
import iso.std.iso_iec._24727.tech.schema.DIDAuthenticationDataType;
import iso.std.iso_iec._24727.tech.schema.DestroyChannel;
import iso.std.iso_iec._24727.tech.schema.DestroyChannelResponse;
import iso.std.iso_iec._24727.tech.schema.Disconnect;
import iso.std.iso_iec._24727.tech.schema.DisconnectResponse;
import iso.std.iso_iec._24727.tech.schema.DisplayCapabilityType;
import iso.std.iso_iec._24727.tech.schema.EndTransaction;
import iso.std.iso_iec._24727.tech.schema.EndTransactionResponse;
import iso.std.iso_iec._24727.tech.schema.EstablishChannel;
import iso.std.iso_iec._24727.tech.schema.EstablishChannelResponse;
import iso.std.iso_iec._24727.tech.schema.EstablishContext;
import iso.std.iso_iec._24727.tech.schema.EstablishContextResponse;
import iso.std.iso_iec._24727.tech.schema.GetIFDCapabilities;
import iso.std.iso_iec._24727.tech.schema.GetIFDCapabilitiesResponse;
import iso.std.iso_iec._24727.tech.schema.GetStatus;
import iso.std.iso_iec._24727.tech.schema.GetStatusResponse;
import iso.std.iso_iec._24727.tech.schema.IFDCapabilitiesType;
import iso.std.iso_iec._24727.tech.schema.IFDStatusType;
import iso.std.iso_iec._24727.tech.schema.InputAPDUInfoType;
import iso.std.iso_iec._24727.tech.schema.KeyPadCapabilityType;
import iso.std.iso_iec._24727.tech.schema.ListIFDs;
import iso.std.iso_iec._24727.tech.schema.ListIFDsResponse;
import iso.std.iso_iec._24727.tech.schema.ModifyVerificationData;
import iso.std.iso_iec._24727.tech.schema.ModifyVerificationDataResponse;
import iso.std.iso_iec._24727.tech.schema.Output;
import iso.std.iso_iec._24727.tech.schema.OutputResponse;
import iso.std.iso_iec._24727.tech.schema.ReleaseContext;
import iso.std.iso_iec._24727.tech.schema.ReleaseContextResponse;
import iso.std.iso_iec._24727.tech.schema.SlotCapabilityType;
import iso.std.iso_iec._24727.tech.schema.SlotStatusType;
import iso.std.iso_iec._24727.tech.schema.Transmit;
import iso.std.iso_iec._24727.tech.schema.TransmitResponse;
import iso.std.iso_iec._24727.tech.schema.VerifyUser;
import iso.std.iso_iec._24727.tech.schema.VerifyUserResponse;
import iso.std.iso_iec._24727.tech.schema.Wait;
import iso.std.iso_iec._24727.tech.schema.WaitResponse;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jws.WebService;
import oasis.names.tc.dss._1_0.core.schema.Result;
import org.openecard.common.ThreadTerminateException;
import org.openecard.common.WSHelper;
import org.openecard.common.ifd.PACECapabilities;
import org.openecard.common.ifd.Protocol;
import org.openecard.common.ifd.ProtocolFactory;
import org.openecard.common.ifd.anytype.PACEInputType;
import org.openecard.common.ifd.anytype.PACEOutputType;
import org.openecard.common.ifd.scio.NoSuchTerminal;
import org.openecard.common.ifd.scio.SCIOCard;
import org.openecard.common.ifd.scio.SCIOErrorCode;
import org.openecard.common.ifd.scio.SCIOException;
import org.openecard.common.ifd.scio.SCIOTerminal;
import org.openecard.common.interfaces.Environment;
import org.openecard.common.interfaces.InvocationTargetExceptionUnchecked;
import org.openecard.common.interfaces.Publish;
import org.openecard.common.util.ByteUtils;
import org.openecard.common.util.HandlerBuilder;
import org.openecard.common.util.ValueGenerators;
import org.openecard.gui.UserConsent;
import org.openecard.ifd.event.IfdEventManager;
import org.openecard.ifd.scio.AbstractTerminal;
import org.openecard.ifd.scio.EventWatcher;
import org.openecard.ifd.scio.IFDException;
import org.openecard.ifd.scio.ProtocolFactories;
import org.openecard.ifd.scio.TransmitException;
import org.openecard.ifd.scio.reader.EstablishPACERequest;
import org.openecard.ifd.scio.reader.EstablishPACEResponse;
import org.openecard.ifd.scio.reader.ExecutePACERequest;
import org.openecard.ifd.scio.reader.ExecutePACEResponse;
import org.openecard.ifd.scio.wrapper.ChannelManager;
import org.openecard.ifd.scio.wrapper.NoSuchChannel;
import org.openecard.ifd.scio.wrapper.SingleThreadChannel;
import org.openecard.ifd.scio.wrapper.TerminalInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebService(endpointInterface="org.openecard.ws.IFD")
public class IFD
implements org.openecard.ws.IFD {
    private static final Logger LOG = LoggerFactory.getLogger(IFD.class);
    private byte[] ctxHandle = null;
    private ChannelManager cm;
    private Environment env;
    private UserConsent gui = null;
    private final ProtocolFactories protocolFactories = new ProtocolFactories();
    private IfdEventManager evManager;
    private AtomicInteger numClients;
    private ExecutorService threadPool;
    private ConcurrentSkipListMap<String, Future<List<IFDStatusType>>> asyncWaitThreads;
    private Future<List<IFDStatusType>> syncWaitThread;

    protected synchronized void removeAsnycTerminal(String session) {
        if (this.asyncWaitThreads != null) {
            this.asyncWaitThreads.remove(session);
        }
    }

    private boolean hasContext() {
        boolean hasContext = this.ctxHandle != null;
        return hasContext;
    }

    public void setEnvironment(Environment env) {
        this.env = env;
    }

    public void setGUI(UserConsent gui) {
        this.gui = gui;
    }

    public boolean addProtocol(String proto, ProtocolFactory factory) {
        return this.protocolFactories.add(proto, factory);
    }

    @Override
    public synchronized EstablishContextResponse establishContext(EstablishContext parameters) {
        try {
            if (this.ctxHandle == null) {
                this.cm = new ChannelManager();
                this.ctxHandle = ChannelManager.createCtxHandle();
                this.numClients = new AtomicInteger(1);
                this.threadPool = Executors.newCachedThreadPool(new ThreadFactory(){
                    private final AtomicInteger num = new AtomicInteger(0);
                    private final ThreadGroup group = new ThreadGroup("IFD Wait");

                    @Override
                    public Thread newThread(Runnable r) {
                        String name = String.format("SCIO Watcher %d", this.num.getAndIncrement());
                        Thread t = new Thread(this.group, r, name);
                        t.setDaemon(false);
                        return t;
                    }
                });
                this.asyncWaitThreads = new ConcurrentSkipListMap();
                this.evManager = new IfdEventManager(this.env, this.cm, this.ctxHandle);
                this.evManager.initialize();
            } else {
                this.numClients.incrementAndGet();
            }
            EstablishContextResponse response = (EstablishContextResponse)WSHelper.makeResponse(EstablishContextResponse.class, WSHelper.makeResultOK());
            response.setContextHandle(this.ctxHandle);
            return response;
        }
        catch (IFDException ex) {
            LOG.warn(ex.getMessage(), ex);
            return (EstablishContextResponse)WSHelper.makeResponse(EstablishContextResponse.class, ex.getResult());
        }
    }

    @Override
    public synchronized ReleaseContextResponse releaseContext(ReleaseContext parameters) {
        if (ByteUtils.compare(this.ctxHandle, parameters.getContextHandle())) {
            if (this.numClients.decrementAndGet() == 0) {
                this.ctxHandle = null;
                this.numClients = null;
                this.threadPool.shutdownNow();
                this.threadPool = null;
                this.asyncWaitThreads = null;
            }
            this.evManager.terminate();
            ReleaseContextResponse response = (ReleaseContextResponse)WSHelper.makeResponse(ReleaseContextResponse.class, WSHelper.makeResultOK());
            return response;
        }
        String msg = "Invalid context handle specified.";
        Result r = WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/common#invalidContextHandle", msg);
        ReleaseContextResponse response = (ReleaseContextResponse)WSHelper.makeResponse(ReleaseContextResponse.class, r);
        return response;
    }

    @Override
    public ListIFDsResponse listIFDs(ListIFDs parameters) {
        if (!ByteUtils.compare(this.ctxHandle, parameters.getContextHandle())) {
            String msg = "Invalid context handle specified.";
            Result r = WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/common#invalidContextHandle", msg);
            ListIFDsResponse response = (ListIFDsResponse)WSHelper.makeResponse(ListIFDsResponse.class, r);
            return response;
        }
        try {
            List<SCIOTerminal> terminals = this.cm.getTerminals().list();
            ArrayList<String> ifds = new ArrayList<String>(terminals.size());
            for (SCIOTerminal next : terminals) {
                ifds.add(next.getName());
            }
            ListIFDsResponse response = (ListIFDsResponse)WSHelper.makeResponse(ListIFDsResponse.class, WSHelper.makeResultOK());
            response.getIFDName().addAll(ifds);
            return response;
        }
        catch (SCIOException ex) {
            LOG.warn(ex.getMessage(), ex);
            Result r = WSHelper.makeResultUnknownError(ex.getMessage());
            ListIFDsResponse response = (ListIFDsResponse)WSHelper.makeResponse(ListIFDsResponse.class, r);
            return response;
        }
    }

    @Override
    public GetIFDCapabilitiesResponse getIFDCapabilities(GetIFDCapabilities parameters) {
        if (!ByteUtils.compare(this.ctxHandle, parameters.getContextHandle())) {
            String msg = "Invalid context handle specified.";
            Result r = WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/common#invalidContextHandle", msg);
            GetIFDCapabilitiesResponse response = (GetIFDCapabilitiesResponse)WSHelper.makeResponse(GetIFDCapabilitiesResponse.class, r);
            return response;
        }
        try {
            BioSensorCapabilityType bioCap;
            KeyPadCapabilityType keyCap;
            DisplayCapabilityType dispCap;
            String ifdName = parameters.getIFDName();
            SCIOTerminal term = this.cm.getTerminals().getTerminal(ifdName);
            TerminalInfo info = new TerminalInfo(this.cm, term);
            IFDCapabilitiesType cap = new IFDCapabilitiesType();
            SlotCapabilityType slotCap = info.getSlotCapability();
            cap.getSlotCapability().add(slotCap);
            List<String> protocols = slotCap.getProtocol();
            for (String proto : this.protocolFactories.protocols()) {
                if (protocols.contains(proto)) continue;
                protocols.add(proto);
            }
            if (!protocols.contains("urn:oid:1.3.162.15480.3.0.9")) {
                protocols.add("urn:oid:1.3.162.15480.3.0.9");
            }
            if ((dispCap = info.getDisplayCapability()) != null) {
                cap.getDisplayCapability().add(dispCap);
            }
            if ((keyCap = info.getKeypadCapability()) != null) {
                cap.getKeyPadCapability().add(keyCap);
            }
            if ((bioCap = info.getBiosensorCapability()) != null) {
                cap.getBioSensorCapability().add(bioCap);
            }
            cap.setOpticalSignalUnit(info.isOpticalSignal());
            cap.setAcousticSignalUnit(info.isAcousticSignal());
            GetIFDCapabilitiesResponse response = (GetIFDCapabilitiesResponse)WSHelper.makeResponse(GetIFDCapabilitiesResponse.class, WSHelper.makeResultOK());
            response.setIFDCapabilities(cap);
            return response;
        }
        catch (NullPointerException | NoSuchTerminal ex) {
            String msg = String.format("Requested terminal not found.", new Object[0]);
            LOG.warn(msg, ex);
            Result r = WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/terminal#unknownIFD", msg);
            GetIFDCapabilitiesResponse response = (GetIFDCapabilitiesResponse)WSHelper.makeResponse(GetIFDCapabilitiesResponse.class, r);
            return response;
        }
        catch (SCIOException ex) {
            String msg = String.format("Failed to request status from terminal.", new Object[0]);
            SCIOErrorCode code = ex.getCode();
            if (code != SCIOErrorCode.SCARD_E_NO_SMARTCARD && code != SCIOErrorCode.SCARD_W_REMOVED_CARD) {
                LOG.warn(msg, ex);
            } else {
                LOG.debug(msg, ex);
            }
            Result r = WSHelper.makeResultUnknownError(msg);
            GetIFDCapabilitiesResponse response = (GetIFDCapabilitiesResponse)WSHelper.makeResponse(GetIFDCapabilitiesResponse.class, r);
            return response;
        }
    }

    @Override
    public GetStatusResponse getStatus(GetStatus parameters) {
        LinkedList<SCIOTerminal> ifds;
        block10: {
            if (!ByteUtils.compare(this.ctxHandle, parameters.getContextHandle())) {
                String msg = "Invalid context handle specified.";
                Result r = WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/common#invalidContextHandle", msg);
                GetStatusResponse response = (GetStatusResponse)WSHelper.makeResponse(GetStatusResponse.class, r);
                return response;
            }
            ifds = new LinkedList<SCIOTerminal>();
            try {
                String requestedIfd = parameters.getIFDName();
                if (requestedIfd != null) {
                    try {
                        SCIOTerminal t = this.cm.getTerminals().getTerminal(requestedIfd);
                        ifds.add(t);
                        break block10;
                    }
                    catch (NoSuchTerminal ex) {
                        String msg = "The requested IFD name does not exist.";
                        LOG.warn(msg, ex);
                        String minor = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/terminal#unknownIFD";
                        Result r = WSHelper.makeResult("http://www.bsi.bund.de/ecard/api/1.1/resultmajor#error", minor, msg);
                        GetStatusResponse response = (GetStatusResponse)WSHelper.makeResponse(GetStatusResponse.class, r);
                        return response;
                    }
                }
                ifds.addAll(this.cm.getTerminals().list());
            }
            catch (SCIOException ex) {
                String msg = "Failed to get list with the terminals.";
                LOG.warn(msg, ex);
                GetStatusResponse response = (GetStatusResponse)WSHelper.makeResponse(GetStatusResponse.class, WSHelper.makeResultUnknownError(msg));
                return response;
            }
        }
        ArrayList<IFDStatusType> status = new ArrayList<IFDStatusType>(ifds.size());
        for (SCIOTerminal ifd : ifds) {
            TerminalInfo termInfo = new TerminalInfo(this.cm, ifd);
            try {
                IFDStatusType s = termInfo.getStatus();
                status.add(s);
            }
            catch (SCIOException ex) {
                if (ex.getCode() != SCIOErrorCode.SCARD_W_UNPOWERED_CARD && ex.getCode() != SCIOErrorCode.SCARD_W_UNRESPONSIVE_CARD && ex.getCode() != SCIOErrorCode.SCARD_W_UNSUPPORTED_CARD && ex.getCode() != SCIOErrorCode.SCARD_E_PROTO_MISMATCH) {
                    String msg = String.format("Failed to determine status of terminal '%s'.", ifd.getName());
                    LOG.warn(msg, ex);
                    Result r = WSHelper.makeResultUnknownError(msg);
                    GetStatusResponse response = (GetStatusResponse)WSHelper.makeResponse(GetStatusResponse.class, r);
                    return response;
                }
                LOG.info("Ignoring failed status request from terminal.", ex);
            }
        }
        GetStatusResponse response = (GetStatusResponse)WSHelper.makeResponse(GetStatusResponse.class, WSHelper.makeResultOK());
        response.getIFDStatus().addAll(status);
        return response;
    }

    @Override
    public WaitResponse wait(Wait parameters) {
        long timeoutL;
        if (!ByteUtils.compare(this.ctxHandle, parameters.getContextHandle())) {
            String msg = "Invalid context handle specified.";
            Result r = WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/common#invalidContextHandle", msg);
            WaitResponse response = (WaitResponse)WSHelper.makeResponse(WaitResponse.class, r);
            return response;
        }
        BigInteger timeout = parameters.getTimeOut();
        if (timeout == null) {
            timeout = BigInteger.valueOf(Long.MAX_VALUE);
        }
        if (timeout.signum() == -1 || timeout.signum() == 0) {
            String msg = "Invalid timeout value given, must be strictly positive.";
            Result r = WSHelper.makeResultUnknownError(msg);
            WaitResponse response = (WaitResponse)WSHelper.makeResponse(WaitResponse.class, r);
            return response;
        }
        try {
            timeoutL = (long)timeout.doubleValue();
        }
        catch (ArithmeticException ex) {
            LOG.warn("Too big timeout value give, shortening to Long.MAX_VALUE.");
            timeoutL = Long.MAX_VALUE;
        }
        ChannelHandleType callback = parameters.getCallback();
        if (callback != null && callback.getProtocolTerminationPoint() == null) {
            callback = null;
        }
        String sessionId = null;
        if (callback != null) {
            ChannelHandleType newCallback = new ChannelHandleType();
            newCallback.setBinding(callback.getBinding());
            newCallback.setPathSecurity(callback.getPathSecurity());
            newCallback.setProtocolTerminationPoint(callback.getProtocolTerminationPoint());
            sessionId = ValueGenerators.genBase64Session();
            newCallback.setSessionIdentifier(sessionId);
            callback = newCallback;
        }
        try {
            EventWatcher watcher = new EventWatcher(this.cm, timeoutL, callback);
            List<IFDStatusType> initialState = watcher.start();
            List<IFDStatusType> expectedState = parameters.getIFDStatus();
            if (expectedState.isEmpty()) {
                expectedState = initialState;
            } else {
                for (IFDStatusType s : expectedState) {
                    if (s.getIFDName() == null) {
                        String msg = "IFD in a request IFDStatus not known.";
                        Result r = WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/terminal#unknownIFD", msg);
                        WaitResponse response = (WaitResponse)WSHelper.makeResponse(WaitResponse.class, r);
                        return response;
                    }
                    if (!s.getSlotStatus().isEmpty()) continue;
                    SlotStatusType slot = new SlotStatusType();
                    slot.setCardAvailable(false);
                    slot.setIndex(BigInteger.ZERO);
                    s.getSlotStatus().add(slot);
                }
            }
            watcher.setExpectedState(expectedState);
            FutureTask<List<IFDStatusType>> future = new FutureTask<List<IFDStatusType>>(watcher);
            if (watcher.isAsync()) {
                this.asyncWaitThreads.put(sessionId, future);
                this.threadPool.execute(future);
                WaitResponse response = (WaitResponse)WSHelper.makeResponse(WaitResponse.class, WSHelper.makeResultOK());
                response.setSessionIdentifier(sessionId);
                return response;
            }
            this.syncWaitThread = future;
            this.threadPool.execute(future);
            List<IFDStatusType> events = future.get();
            WaitResponse response = (WaitResponse)WSHelper.makeResponse(WaitResponse.class, WSHelper.makeResultOK());
            response.getIFDEvent().addAll(events);
            return response;
        }
        catch (SCIOException ex) {
            String msg = "Unknown SCIO error occured during wait call.";
            LOG.warn(msg, ex);
            Result r = WSHelper.makeResultUnknownError(msg);
            WaitResponse response = (WaitResponse)WSHelper.makeResponse(WaitResponse.class, r);
            return response;
        }
        catch (ExecutionException ex) {
            WaitResponse response;
            Throwable cause = ex.getCause();
            if (cause instanceof SCIOException) {
                String msg = "Unknown SCIO error occured during wait call.";
                LOG.warn(msg, cause);
                Result r = WSHelper.makeResultUnknownError(msg);
                response = (WaitResponse)WSHelper.makeResponse(WaitResponse.class, r);
            } else {
                String msg = "Unknown error during wait call.";
                LOG.error(msg, cause);
                Result r = WSHelper.makeResultUnknownError(msg);
                response = (WaitResponse)WSHelper.makeResponse(WaitResponse.class, r);
            }
            return response;
        }
        catch (InterruptedException ex) {
            String msg = "Wait interrupted by another thread.";
            LOG.warn(msg, ex);
            Result r = WSHelper.makeResultUnknownError(msg);
            WaitResponse response = (WaitResponse)WSHelper.makeResponse(WaitResponse.class, r);
            return response;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CancelResponse cancel(Cancel parameters) {
        CancelResponse response;
        if (!ByteUtils.compare(this.ctxHandle, parameters.getContextHandle())) {
            String msg = "Invalid context handle specified.";
            Result r = WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/common#invalidContextHandle", msg);
            CancelResponse response2 = (CancelResponse)WSHelper.makeResponse(CancelResponse.class, r);
            return response2;
        }
        String ifdName = parameters.getIFDName();
        String session = parameters.getSessionIdentifier();
        if (session != null) {
            Future<List<IFDStatusType>> f = this.asyncWaitThreads.get(session);
            if (f != null) {
                f.cancel(true);
                response = (CancelResponse)WSHelper.makeResponse(CancelResponse.class, WSHelper.makeResultOK());
            } else {
                String msg = "No matching Wait call exists for the given session.";
                Result r = WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/IO#cancelNotPossible", msg);
                response = (CancelResponse)WSHelper.makeResponse(CancelResponse.class, r);
            }
        } else if (ifdName != null) {
            IFD f = this;
            synchronized (f) {
                if (this.syncWaitThread != null) {
                    this.syncWaitThread.cancel(true);
                    this.syncWaitThread = null;
                    response = (CancelResponse)WSHelper.makeResponse(CancelResponse.class, WSHelper.makeResultOK());
                } else {
                    String msg = "No synchronous Wait to cancel.";
                    Result r = WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/IO#cancelNotPossible", msg);
                    response = (CancelResponse)WSHelper.makeResponse(CancelResponse.class, r);
                }
            }
        } else {
            String msg = "Invalid parameters given.";
            response = (CancelResponse)WSHelper.makeResponse(CancelResponse.class, WSHelper.makeResultUnknownError(msg));
        }
        return response;
    }

    @Override
    public ControlIFDResponse controlIFD(ControlIFD parameters) {
        if (!this.hasContext()) {
            String msg = "Context not initialized.";
            Result r = WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/common#invalidSlotHandle", msg);
            ControlIFDResponse response = (ControlIFDResponse)WSHelper.makeResponse(ControlIFDResponse.class, r);
            return response;
        }
        byte[] handle = parameters.getSlotHandle();
        byte[] command = parameters.getCommand();
        if (handle == null || command == null) {
            String msg = "Missing parameter.";
            Result r = WSHelper.makeResultUnknownError(msg);
            ControlIFDResponse response = (ControlIFDResponse)WSHelper.makeResponse(ControlIFDResponse.class, r);
            return response;
        }
        byte ctrlCode = command[0];
        command = Arrays.copyOfRange(command, 1, command.length);
        try {
            SingleThreadChannel ch = this.cm.getSlaveChannel(handle);
            TerminalInfo info = new TerminalInfo(this.cm, ch);
            Integer featureCode = info.getFeatureCodes().get(ctrlCode);
            if (featureCode != null) {
                byte[] resultCommand = ch.transmitControlCommand(featureCode, command);
                Result result = this.evaluateControlIFDRAPDU(resultCommand);
                ControlIFDResponse response = (ControlIFDResponse)WSHelper.makeResponse(ControlIFDResponse.class, result);
                response.setResponse(resultCommand);
                return response;
            }
            String msg = "The terminal is not capable of performing the requested action.";
            Result r = WSHelper.makeResultUnknownError(msg);
            ControlIFDResponse response = (ControlIFDResponse)WSHelper.makeResponse(ControlIFDResponse.class, r);
            return response;
        }
        catch (IllegalStateException | NoSuchChannel ex) {
            String msg = "The card or the terminal is not available anymore.";
            Result r = WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/terminal#unknownIFD", msg);
            ControlIFDResponse response = (ControlIFDResponse)WSHelper.makeResponse(ControlIFDResponse.class, r);
            LOG.warn(msg, ex);
            return response;
        }
        catch (SCIOException ex) {
            String msg = "Unknown error while sending transmit control command.";
            Result r = WSHelper.makeResultUnknownError(msg);
            ControlIFDResponse response = (ControlIFDResponse)WSHelper.makeResponse(ControlIFDResponse.class, r);
            LOG.warn(msg, ex);
            return response;
        }
    }

    @Override
    public ConnectResponse connect(Connect parameters) {
        try {
            if (!ByteUtils.compare(this.ctxHandle, parameters.getContextHandle())) {
                String msg = "Invalid context handle specified.";
                Result r = WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/common#invalidContextHandle", msg);
                ConnectResponse response = (ConnectResponse)WSHelper.makeResponse(ConnectResponse.class, r);
                return response;
            }
            try {
                String name = parameters.getIFDName();
                byte[] slotHandle = (byte[])this.cm.openSlaveChannel((String)name).p1;
                SingleThreadChannel ch = this.cm.getSlaveChannel(slotHandle);
                Boolean exclusive = parameters.isExclusive();
                if (exclusive != null && exclusive.booleanValue()) {
                    BeginTransaction transact = new BeginTransaction();
                    transact.setSlotHandle(slotHandle);
                    BeginTransactionResponse resp = this.beginTransaction(transact);
                    if (resp.getResult().getResultMajor().equals("http://www.bsi.bund.de/ecard/api/1.1/resultmajor#error")) {
                        ch.shutdown();
                        ConnectResponse response = (ConnectResponse)WSHelper.makeResponse(ConnectResponse.class, resp.getResult());
                        return response;
                    }
                }
                ConnectResponse response = (ConnectResponse)WSHelper.makeResponse(ConnectResponse.class, WSHelper.makeResultOK());
                response.setSlotHandle(slotHandle);
                return response;
            }
            catch (NullPointerException | NoSuchTerminal ex) {
                String msg = "The requested terminal does not exist.";
                Result r = WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/terminal#unknownIFD", msg);
                ConnectResponse response = (ConnectResponse)WSHelper.makeResponse(ConnectResponse.class, r);
                LOG.warn(msg, ex);
                return response;
            }
            catch (IllegalStateException ex) {
                String msg = "No card available in the requested terminal.";
                Result r = WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/terminal#noCard", msg);
                ConnectResponse response = (ConnectResponse)WSHelper.makeResponse(ConnectResponse.class, r);
                LOG.warn(msg, ex);
                return response;
            }
            catch (SCIOException ex) {
                String msg = "Unknown error in the underlying SCIO implementation.";
                Result r = WSHelper.makeResultUnknownError(msg);
                ConnectResponse response = (ConnectResponse)WSHelper.makeResponse(ConnectResponse.class, r);
                LOG.warn(msg, ex);
                return response;
            }
        }
        catch (Exception ex) {
            LOG.warn(ex.getMessage(), ex);
            this.throwThreadKillException(ex);
            return (ConnectResponse)WSHelper.makeResponse(ConnectResponse.class, WSHelper.makeResult(ex));
        }
    }

    @Override
    public synchronized DisconnectResponse disconnect(Disconnect parameters) {
        try {
            if (!this.hasContext()) {
                String msg = "Context not initialized.";
                Result r = WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/common#invalidSlotHandle", msg);
                DisconnectResponse response = (DisconnectResponse)WSHelper.makeResponse(DisconnectResponse.class, r);
                return response;
            }
            try {
                byte[] handle = parameters.getSlotHandle();
                SingleThreadChannel ch = this.cm.getSlaveChannel(handle);
                this.cm.closeSlaveChannel(handle);
                SCIOCard card = ch.getChannel().getCard();
                ActionType action = parameters.getAction();
                if (ActionType.RESET == action) {
                    HandlerBuilder builder = HandlerBuilder.create();
                    ConnectionHandleType cHandleIn = builder.setCardType("http://bsi.bund.de/cif/unknown").setCardIdentifier(card.getATR().getBytes()).setContextHandle(this.ctxHandle).setIfdName(card.getTerminal().getName()).setSlotIdx(BigInteger.ZERO).buildConnectionHandle();
                    builder = HandlerBuilder.create();
                    ConnectionHandleType cHandleRm = builder.setContextHandle(this.ctxHandle).setIfdName(card.getTerminal().getName()).setSlotIdx(BigInteger.ZERO).buildConnectionHandle();
                    this.evManager.resetCard(cHandleRm, cHandleIn, card.getProtocol().toUri());
                    card.disconnect(true);
                }
                DisconnectResponse response = (DisconnectResponse)WSHelper.makeResponse(DisconnectResponse.class, WSHelper.makeResultOK());
                return response;
            }
            catch (NoSuchChannel ex) {
                String msg = "No card available in the requested terminal.";
                Result r = WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/common#invalidSlotHandle", msg);
                DisconnectResponse response = (DisconnectResponse)WSHelper.makeResponse(DisconnectResponse.class, r);
                LOG.warn(msg, ex);
                return response;
            }
            catch (SCIOException ex) {
                String msg = "Unknown error in the underlying SCIO implementation.";
                Result r = WSHelper.makeResultUnknownError(msg);
                DisconnectResponse response = (DisconnectResponse)WSHelper.makeResponse(DisconnectResponse.class, r);
                LOG.warn(msg, ex);
                return response;
            }
        }
        catch (Exception ex) {
            LOG.warn(ex.getMessage(), ex);
            this.throwThreadKillException(ex);
            return (DisconnectResponse)WSHelper.makeResponse(DisconnectResponse.class, WSHelper.makeResult(ex));
        }
    }

    @Override
    public BeginTransactionResponse beginTransaction(BeginTransaction beginTransaction) {
        try {
            if (!this.hasContext()) {
                String msg = "Context not initialized.";
                Result r = WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/common#invalidSlotHandle", msg);
                BeginTransactionResponse response = (BeginTransactionResponse)WSHelper.makeResponse(BeginTransactionResponse.class, r);
                return response;
            }
            try {
                byte[] handle = beginTransaction.getSlotHandle();
                SingleThreadChannel ch = this.cm.getSlaveChannel(handle);
                ch.beginExclusive();
            }
            catch (IllegalStateException | NoSuchChannel ex) {
                String msg = "No card available in the requested terminal.";
                Result r = WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/common#invalidSlotHandle", msg);
                BeginTransactionResponse response = (BeginTransactionResponse)WSHelper.makeResponse(BeginTransactionResponse.class, r);
                LOG.warn(msg, ex);
                return response;
            }
            catch (SCIOException ex) {
                String minor;
                String msg;
                switch (ex.getCode()) {
                    case SCARD_W_RESET_CARD: 
                    case SCARD_W_REMOVED_CARD: 
                    case SCARD_E_READER_UNAVAILABLE: 
                    case SCARD_E_NO_SMARTCARD: 
                    case SCARD_E_NO_SERVICE: {
                        msg = String.format("Slot handle is not available [%s].", ex.getCode().name());
                        minor = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/common#invalidSlotHandle";
                        LOG.debug(msg, ex);
                        break;
                    }
                    default: {
                        msg = "Unknown error in the underlying SCIO implementation.";
                        minor = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/common#unknownError";
                        LOG.warn(msg, ex);
                    }
                }
                Result r = WSHelper.makeResultError(minor, msg);
                BeginTransactionResponse response = (BeginTransactionResponse)WSHelper.makeResponse(BeginTransactionResponse.class, r);
                return response;
            }
            BeginTransactionResponse response = (BeginTransactionResponse)WSHelper.makeResponse(BeginTransactionResponse.class, WSHelper.makeResultOK());
            return response;
        }
        catch (Exception ex) {
            LOG.warn(ex.getMessage(), ex);
            this.throwThreadKillException(ex);
            return (BeginTransactionResponse)WSHelper.makeResponse(BeginTransactionResponse.class, WSHelper.makeResult(ex));
        }
    }

    @Override
    public EndTransactionResponse endTransaction(EndTransaction parameters) {
        try {
            if (!this.hasContext()) {
                String msg = "Context not initialized.";
                Result r = WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/common#invalidSlotHandle", msg);
                EndTransactionResponse response = (EndTransactionResponse)WSHelper.makeResponse(EndTransactionResponse.class, r);
                return response;
            }
            try {
                byte[] handle = parameters.getSlotHandle();
                SingleThreadChannel ch = this.cm.getSlaveChannel(handle);
                ch.endExclusive();
            }
            catch (IllegalStateException | NoSuchChannel ex) {
                String msg = "No card with transaction available in the requested terminal.";
                Result r = WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/common#invalidSlotHandle", msg);
                EndTransactionResponse response = (EndTransactionResponse)WSHelper.makeResponse(EndTransactionResponse.class, r);
                LOG.warn(msg, ex);
                return response;
            }
            catch (SCIOException ex) {
                String msg = "Unknown error in the underlying SCIO implementation.";
                Result r = WSHelper.makeResultUnknownError(msg);
                EndTransactionResponse response = (EndTransactionResponse)WSHelper.makeResponse(EndTransactionResponse.class, r);
                LOG.warn(msg, ex);
                return response;
            }
            EndTransactionResponse response = (EndTransactionResponse)WSHelper.makeResponse(EndTransactionResponse.class, WSHelper.makeResultOK());
            return response;
        }
        catch (Exception ex) {
            LOG.warn(ex.getMessage(), ex);
            this.throwThreadKillException(ex);
            return (EndTransactionResponse)WSHelper.makeResponse(EndTransactionResponse.class, WSHelper.makeResult(ex));
        }
    }

    @Override
    @Publish
    public TransmitResponse transmit(Transmit parameters) {
        try {
            if (!this.hasContext()) {
                String msg = "Context not initialized.";
                Result r = WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/common#invalidSlotHandle", msg);
                TransmitResponse response = (TransmitResponse)WSHelper.makeResponse(TransmitResponse.class, r);
                return response;
            }
            try {
                String msg;
                Result result;
                byte[] handle = parameters.getSlotHandle();
                SingleThreadChannel ch = this.cm.getSlaveChannel(handle);
                List<InputAPDUInfoType> apdus = parameters.getInputAPDUInfo();
                for (InputAPDUInfoType apdu : apdus) {
                    for (byte[] code : apdu.getAcceptableStatusCode()) {
                        if (code.length != 0 && code.length <= 2) continue;
                        String msg2 = "Invalid accepted status code given.";
                        Result r = WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/common#parameterError", msg2);
                        TransmitResponse response = (TransmitResponse)WSHelper.makeResponse(TransmitResponse.class, r);
                        return response;
                    }
                }
                TransmitResponse response = (TransmitResponse)WSHelper.makeResponse(TransmitResponse.class, WSHelper.makeResultOK());
                List<byte[]> rapdus = response.getOutputAPDU();
                try {
                    for (InputAPDUInfoType capdu : apdus) {
                        byte[] rapdu = ch.transmit(capdu.getInputAPDU(), capdu.getAcceptableStatusCode());
                        rapdus.add(rapdu);
                    }
                    result = WSHelper.makeResultOK();
                }
                catch (TransmitException ex) {
                    rapdus.add(ex.getResponseAPDU());
                    result = ex.getResult();
                }
                catch (SCIOException ex) {
                    msg = "Error during transmit.";
                    LOG.warn(msg, ex);
                    result = WSHelper.makeResultUnknownError(msg);
                }
                catch (IllegalStateException ex) {
                    msg = "Card removed during transmit.";
                    LOG.warn(msg, ex);
                    result = WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/common#invalidSlotHandle", msg);
                }
                catch (IllegalArgumentException ex) {
                    msg = "Given command contains a MANAGE CHANNEL APDU.";
                    LOG.error(msg, ex);
                    result = WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/common#invalidSlotHandle", msg);
                }
                response.setResult(result);
                return response;
            }
            catch (IllegalStateException | NoSuchChannel ex) {
                String msg = "No card with transaction available in the requested terminal.";
                Result r = WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/common#invalidSlotHandle", msg);
                TransmitResponse response = (TransmitResponse)WSHelper.makeResponse(TransmitResponse.class, r);
                LOG.warn(msg, ex);
                return response;
            }
        }
        catch (Exception ex) {
            LOG.warn(ex.getMessage(), ex);
            this.throwThreadKillException(ex);
            return (TransmitResponse)WSHelper.makeResponse(TransmitResponse.class, WSHelper.makeResult(ex));
        }
    }

    @Override
    public VerifyUserResponse verifyUser(VerifyUser parameters) {
        try {
            if (!this.hasContext()) {
                String msg = "Context not initialized.";
                Result r = WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/common#invalidSlotHandle", msg);
                VerifyUserResponse response = (VerifyUserResponse)WSHelper.makeResponse(VerifyUserResponse.class, r);
                return response;
            }
            SingleThreadChannel channel = this.cm.getSlaveChannel(parameters.getSlotHandle());
            AbstractTerminal aTerm = new AbstractTerminal(this, this.cm, channel, this.gui, this.ctxHandle, parameters.getDisplayIndex());
            try {
                VerifyUserResponse response = aTerm.verifyUser(parameters);
                return response;
            }
            catch (IFDException ex) {
                VerifyUserResponse response = (VerifyUserResponse)WSHelper.makeResponse(VerifyUserResponse.class, ex.getResult());
                return response;
            }
        }
        catch (Exception ex) {
            LOG.warn(ex.getMessage(), ex);
            this.throwThreadKillException(ex);
            return (VerifyUserResponse)WSHelper.makeResponse(VerifyUserResponse.class, WSHelper.makeResult(ex));
        }
    }

    @Override
    public ModifyVerificationDataResponse modifyVerificationData(ModifyVerificationData parameters) {
        String msg = "Command not supported.";
        ModifyVerificationDataResponse response = (ModifyVerificationDataResponse)WSHelper.makeResponse(ModifyVerificationDataResponse.class, WSHelper.makeResultUnknownError(msg));
        return response;
    }

    @Override
    public OutputResponse output(Output parameters) {
        String msg = "Command not supported.";
        OutputResponse response = (OutputResponse)WSHelper.makeResponse(OutputResponse.class, WSHelper.makeResultUnknownError(msg));
        return response;
    }

    @Override
    public EstablishChannelResponse establishChannel(EstablishChannel parameters) {
        byte[] slotHandle = parameters.getSlotHandle();
        try {
            SingleThreadChannel channel = this.cm.getSlaveChannel(slotHandle);
            TerminalInfo termInfo = new TerminalInfo(this.cm, channel);
            DIDAuthenticationDataType protoParam = parameters.getAuthenticationProtocolData();
            String protocol = protoParam.getProtocol();
            List<PACECapabilities.PACECapability> paceCapabilities = termInfo.getPACECapabilities();
            List<String> supportedProtos = TerminalInfo.buildPACEProtocolList(paceCapabilities);
            if (!supportedProtos.isEmpty() && supportedProtos.get(0).startsWith(protocol)) {
                PACEInputType paceParam = new PACEInputType(protoParam);
                byte pinID = paceParam.getPINID();
                byte[] chat = paceParam.getCHAT();
                String pin = paceParam.getPIN();
                byte[] certDesc = paceParam.getCertificateDescription();
                EstablishPACERequest estPaceReq = new EstablishPACERequest(pinID, chat, null, certDesc);
                ExecutePACERequest execPaceReq = new ExecutePACERequest(ExecutePACERequest.Function.EstablishPACEChannel, estPaceReq.toBytes());
                if (estPaceReq.isSupportedType(paceCapabilities)) {
                    byte[] reqData = execPaceReq.toBytes();
                    LOG.debug("executeCtrlCode request: {}", (Object)ByteUtils.toHexString(reqData));
                    Map<Integer, Integer> features = termInfo.getFeatureCodes();
                    byte[] resData = channel.transmitControlCommand(features.get(32), reqData);
                    LOG.debug("Response of executeCtrlCode: {}", (Object)ByteUtils.toHexString(resData));
                    ExecutePACEResponse execPaceRes = new ExecutePACEResponse(resData);
                    if (execPaceRes.isError()) {
                        return (EstablishChannelResponse)WSHelper.makeResponse(EstablishChannelResponse.class, execPaceRes.getResult());
                    }
                    EstablishPACEResponse estPaceRes = new EstablishPACEResponse(execPaceRes.getData());
                    PACEOutputType authDataResponse = paceParam.getOutputType();
                    authDataResponse.setRetryCounter(estPaceRes.getRetryCounter());
                    authDataResponse.setEFCardAccess(estPaceRes.getEFCardAccess());
                    if (estPaceRes.hasCurrentCAR()) {
                        authDataResponse.setCurrentCAR(estPaceRes.getCurrentCAR());
                    }
                    if (estPaceRes.hasPreviousCAR()) {
                        authDataResponse.setPreviousCAR(estPaceRes.getPreviousCAR());
                    }
                    if (estPaceRes.hasIDICC()) {
                        authDataResponse.setIDPICC(estPaceRes.getIDICC());
                    }
                    EstablishChannelResponse response = (EstablishChannelResponse)WSHelper.makeResponse(EstablishChannelResponse.class, WSHelper.makeResultOK());
                    response.setAuthenticationProtocolData(authDataResponse.getAuthDataType());
                    return response;
                }
            }
            if (this.protocolFactories.contains(protocol)) {
                ProtocolFactory factory = this.protocolFactories.get(protocol);
                Protocol protoImpl = factory.createInstance();
                EstablishChannelResponse response = protoImpl.establish(parameters, this.env.getDispatcher(), this.gui);
                if (response.getResult().getResultMajor().equals("http://www.bsi.bund.de/ecard/api/1.1/resultmajor#ok")) {
                    channel.addSecureMessaging(protoImpl);
                }
                return response;
            }
            Result r = WSHelper.makeResultUnknownError("No such protocol available in this IFD.");
            return (EstablishChannelResponse)WSHelper.makeResponse(EstablishChannelResponse.class, r);
        }
        catch (Throwable t) {
            return (EstablishChannelResponse)WSHelper.makeResponse(EstablishChannelResponse.class, WSHelper.makeResult(t));
        }
    }

    @Override
    public DestroyChannelResponse destroyChannel(DestroyChannel parameters) {
        try {
            DestroyChannelResponse destroyChannelResponse = new DestroyChannelResponse();
            byte[] slotHandle = parameters.getSlotHandle();
            SingleThreadChannel channel = this.cm.getSlaveChannel(slotHandle);
            TerminalInfo termInfo = new TerminalInfo(this.cm, channel);
            List<PACECapabilities.PACECapability> paceCapabilities = termInfo.getPACECapabilities();
            if (paceCapabilities.contains((Object)PACECapabilities.PACECapability.DestroyPACEChannel)) {
                ExecutePACERequest execPaceReq = new ExecutePACERequest(ExecutePACERequest.Function.DestroyPACEChannel);
                byte[] reqData = execPaceReq.toBytes();
                LOG.debug("executeCtrlCode request: {}", (Object)ByteUtils.toHexString(reqData));
                Map<Integer, Integer> features = termInfo.getFeatureCodes();
                byte[] resData = channel.transmitControlCommand(features.get(32), reqData);
                LOG.debug("Response of executeCtrlCode: {}", (Object)ByteUtils.toHexString(resData));
                ExecutePACEResponse execPaceRes = new ExecutePACEResponse(resData);
                if (execPaceRes.isError()) {
                    destroyChannelResponse = (DestroyChannelResponse)WSHelper.makeResponse(DestroyChannelResponse.class, execPaceRes.getResult());
                }
            }
            channel.removeSecureMessaging();
            if (destroyChannelResponse.getResult() == null) {
                Result r = new Result();
                r.setResultMajor("http://www.bsi.bund.de/ecard/api/1.1/resultmajor#ok");
                destroyChannelResponse.setResult(r);
            }
            return destroyChannelResponse;
        }
        catch (Throwable t) {
            return (DestroyChannelResponse)WSHelper.makeResponse(DestroyChannelResponse.class, WSHelper.makeResult(t));
        }
    }

    private Result evaluateControlIFDRAPDU(byte[] resultCommand) {
        int result = ByteUtils.toInteger(resultCommand);
        switch (result) {
            case 36864: {
                return WSHelper.makeResultOK();
            }
            case 25600: {
                return WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/common#timeoutError", "Timeout.");
            }
        }
        return WSHelper.makeResultUnknownError("Unknown return code from terminal.");
    }

    private void throwThreadKillException(Exception ex) {
        Throwable cause = ex instanceof InvocationTargetExceptionUnchecked ? ex.getCause() : ex;
        if (cause instanceof ThreadTerminateException) {
            throw (RuntimeException)cause;
        }
        if (cause instanceof InterruptedException) {
            throw new ThreadTerminateException("Thread running inside SAL interrupted.", cause);
        }
        if (cause instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
    }
}

