/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.ifd.protocol.pace.gui;

import java.util.Map;
import org.openecard.common.I18n;
import org.openecard.gui.definition.PasswordField;
import org.openecard.gui.definition.Step;
import org.openecard.gui.definition.Text;
import org.openecard.gui.executor.ExecutionResults;
import org.openecard.ifd.protocol.pace.common.PasswordID;
import org.openecard.ifd.protocol.pace.gui.GUIContentMap;

public class PINStep {
    private static final I18n lang = I18n.getTranslation("pace");
    private static final String STEP_ID = "PROTOCOL_PACE_GUI_STEP_PIN";
    private static final String TITLE = "step_pace_title";
    private static final String STEP_DESCRIPTION = "step_pace_step_description";
    private static final String DESCRIPTION = "step_pace_description";
    private final Step step;
    private final GUIContentMap content;
    private final String passwordType;

    public PINStep(GUIContentMap content) {
        this.content = content;
        this.passwordType = PasswordID.parse((Byte)content.get(GUIContentMap.ELEMENT.PIN_ID)).getString();
        this.step = new Step(STEP_ID, lang.translationForKey(TITLE, this.passwordType));
        this.initialize();
    }

    private void initialize() {
        this.step.setDescription(lang.translationForKey(STEP_DESCRIPTION, new Object[0]));
        String decriptionText = lang.translationForKey(DESCRIPTION, this.passwordType);
        Text description = new Text();
        description.setText(decriptionText);
        this.step.getInputInfoUnits().add(description);
        PasswordField pinInputField = new PasswordField(this.passwordType);
        pinInputField.setDescription(lang.translationForKey(this.passwordType, new Object[0]));
        this.step.getInputInfoUnits().add(pinInputField);
    }

    public Step getStep() {
        return this.step;
    }

    public void processResult(Map<String, ExecutionResults> results) {
        ExecutionResults executionResults = results.get(this.step.getID());
        if (executionResults == null) {
            return;
        }
        PasswordField p = (PasswordField)executionResults.getResult(this.passwordType);
        this.content.add(GUIContentMap.ELEMENT.PIN, (Object)p.getValue());
    }
}

