/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.gui.swing.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.openecard.common.I18n;
import org.openecard.common.util.FileUtils;
import org.openecard.gui.definition.Document;
import org.openecard.gui.definition.OutputInfoUnit;
import org.openecard.gui.swing.common.GUIDefaults;
import org.openecard.gui.swing.components.StepComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToggleText
implements StepComponent {
    private static final Logger logger = LoggerFactory.getLogger(ToggleText.class);
    private static final I18n lang = I18n.getTranslation("swing");
    private static final String TOGGLETEXT = "ToggleText";
    private static final String TOGGLETEXT_FOREGROUND = "ToggleText.foreground";
    private static final String TOGGLETEXT_BACKGROUND = "ToggleText.background";
    private static final String TOGGLETEXT_INDICATOR_FOREGROUND = "ToggleTextIndicator.foreground";
    private static final Icon openedIndicator = GUIDefaults.getImage("ToggleText.selectedIcon");
    private static final Icon closedIndicator = GUIDefaults.getImage("ToggleText.icon");
    private JPanel rootPanel;
    private JButton button;
    private JComponent text;
    private File tmpDir;

    public ToggleText(org.openecard.gui.definition.ToggleText toggleText) {
        this(toggleText.getTitle(), toggleText.getDocument(), toggleText.isCollapsed());
    }

    public ToggleText(String buttonText, String contentText) {
        this(buttonText, new Document("text/plain", contentText.getBytes(Charset.forName("UTF-8"))), false);
    }

    public ToggleText(String buttonText, String contentText, boolean collapsed) {
        this(buttonText, new Document("text/plain", contentText.getBytes(Charset.forName("UTF-8"))), collapsed);
    }

    public ToggleText(String buttonText, Document content, boolean collapsed) {
        this.initComponents(buttonText, content);
        this.initLayout();
        this.loadUIDefaults();
        this.button.setSelected(collapsed);
        this.text.setVisible(!collapsed);
        this.button.setIcon(!collapsed ? openedIndicator : closedIndicator);
    }

    private void initComponents(String buttonText, Document content) {
        String mimeType;
        this.rootPanel = new JPanel();
        this.button = new JButton(buttonText + "  ");
        switch (mimeType = content.getMimeType()) {
            case "text/html": {
                ClassLoader loader = ToggleText.class.getClassLoader();
                try {
                    loader.loadClass("javafx.embed.swing.JFXPanel");
                    this.text = this.createJfxPanel(mimeType, content.getValue());
                }
                catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | IllegalStateException | InvocationTargetException ex) {
                    logger.error("Failed to initialize JFXPanel", ex);
                    this.createJTextArea(new String(content.getValue(), Charset.forName("UTF-8")));
                }
                break;
            }
            case "text/plain": {
                this.createJTextArea(new String(content.getValue(), Charset.forName("UTF-8")));
                break;
            }
            case "application/pdf": {
                try {
                    this.createTmpDir();
                    String pdfFile = this.createTmpPdf(content.getValue());
                    this.createStartPdfViewButton(pdfFile);
                }
                catch (FileNotFoundException | SecurityException ex) {
                    logger.error("Failed to access the tmp pdf file.", ex);
                    this.createJTextArea(lang.translationForKey("pdf.creation.failed", new Object[0]));
                }
                catch (IOException ex) {
                    logger.error("Failed to create the tmp pdf file.", ex);
                    this.createJTextArea(lang.translationForKey("pdf.creation.failed", new Object[0]));
                }
                break;
            }
            default: {
                logger.warn("Unsupported usage of content of type " + mimeType + " in " + ToggleText.class.getName());
                this.createJTextArea(lang.translationForKey("unsupported.mimetype", mimeType));
            }
        }
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToggleText.this.text.setVisible(!ToggleText.this.text.isVisible());
                ToggleText.this.button.setIcon(ToggleText.this.text.isVisible() ? openedIndicator : closedIndicator);
                ToggleText.this.rootPanel.revalidate();
                ToggleText.this.rootPanel.doLayout();
                ToggleText.this.rootPanel.repaint();
            }
        });
    }

    private void initLayout() {
        this.rootPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        this.rootPanel.add((Component)this.button, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        this.rootPanel.add((Component)this.text, gbc);
    }

    private void loadUIDefaults() {
        Color fgIndicator;
        Color fg;
        UIDefaults defaults = UIManager.getDefaults();
        Color bg = (Color)defaults.get(TOGGLETEXT_BACKGROUND);
        if (bg == null) {
            bg = Color.WHITE;
        }
        if ((fg = (Color)defaults.get(TOGGLETEXT_FOREGROUND)) == null) {
            fg = Color.BLACK;
        }
        if ((fgIndicator = (Color)defaults.get(TOGGLETEXT_INDICATOR_FOREGROUND)) == null) {
            fgIndicator = Color.LIGHT_GRAY;
        }
        Font font = UIManager.getFont("Label.font");
        this.button.setOpaque(true);
        this.button.setFocusPainted(false);
        this.button.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
        this.button.setHorizontalAlignment(2);
        this.button.setMargin(new Insets(0, 0, 0, 0));
        this.button.setBounds(0, 0, 0, 0);
        this.button.setFont(font.deriveFont(1));
        this.button.setContentAreaFilled(false);
        this.button.setHorizontalTextPosition(11);
        this.text.setFont(font.deriveFont(0));
        this.rootPanel.setBackground(bg);
        this.rootPanel.setForeground(fg);
        for (int i = 0; i < this.rootPanel.getComponentCount(); ++i) {
            this.rootPanel.getComponent(i).setBackground(bg);
            this.rootPanel.getComponent(i).setForeground(fg);
        }
    }

    @Override
    public Component getComponent() {
        return this.rootPanel;
    }

    @Override
    public boolean isValueType() {
        return false;
    }

    @Override
    public boolean validate() {
        return true;
    }

    @Override
    public OutputInfoUnit getValue() {
        return null;
    }

    private JPanel createJfxPanel(String mimeType, byte[] content) throws ClassNotFoundException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        ClassLoader loader = ToggleText.class.getClassLoader();
        Class<?> htmlPanelClass = loader.loadClass("org.openecard.gui.swing.components.HTMLPanel");
        for (Method m : htmlPanelClass.getMethods()) {
            if (!m.getName().equals("createPanel")) continue;
            return (JPanel)m.invoke(null, mimeType, content);
        }
        throw new IllegalStateException("The required method createPanel was not found.");
    }

    private void createJTextArea(String content) {
        this.text = new JTextArea(content);
        JTextArea textAreaObject = (JTextArea)this.text;
        textAreaObject.setMargin(new Insets(0, 13, 0, 0));
        textAreaObject.setEditable(false);
        textAreaObject.setLineWrap(true);
        textAreaObject.setWrapStyleWord(true);
    }

    private void createTmpDir() throws IOException, SecurityException {
        String tmpDirPath = FileUtils.getHomeConfigDir().getAbsolutePath() + "/tmp";
        this.tmpDir = new File(tmpDirPath);
        this.tmpDir.mkdirs();
        this.tmpDir.deleteOnExit();
    }

    private String createTmpPdf(byte[] content) throws IOException, FileNotFoundException {
        File tmpPdf = File.createTempFile("tmp", ".pdf", this.tmpDir);
        tmpPdf.deleteOnExit();
        try (FileOutputStream out = new FileOutputStream(tmpPdf);){
            out.write(content);
            out.flush();
        }
        return tmpPdf.getAbsolutePath();
    }

    private void createStartPdfViewButton(final String pdfFile) {
        JPanel contentPane = new JPanel();
        final JButton pdfButton = new JButton(lang.translationForKey("open.pdf.in.external.viewer", new Object[0]));
        pdfButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == pdfButton) {
                    try {
                        Desktop desktop = Desktop.getDesktop();
                        desktop.open(new File(pdfFile));
                    }
                    catch (IOException ex) {
                        logger.error("Failed to open pdf file.", ex);
                    }
                }
            }
        });
        contentPane.add(pdfButton);
        this.text = contentPane;
    }
}

