/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.gui.swing.components;

import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.nio.charset.Charset;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import org.openecard.gui.definition.Document;
import org.openecard.gui.definition.OutputInfoUnit;
import org.openecard.gui.swing.components.StepComponent;

public class Text
implements StepComponent {
    private final JTextPane textArea;

    public Text(org.openecard.gui.definition.Text text) {
        String textString;
        Document textValue = text.getDocument();
        switch (textValue.getMimeType()) {
            case "text/plain": {
                textString = "<html><body>" + new String(textValue.getValue(), Charset.forName("UTF-8")) + "</body></html>";
                break;
            }
            case "text/html": {
                textString = new String(textValue.getValue(), Charset.forName("UTF-8"));
                break;
            }
            default: {
                throw new IllegalArgumentException("Content with the MimeType " + textValue.getMimeType() + " is not supported by the Swing Text implementation.");
            }
        }
        this.textArea = new JTextPane();
        this.textArea.setEditorKitForContentType("text/html", new HTMLEditorKit());
        this.textArea.setContentType("text/html");
        this.textArea.setMargin(new Insets(0, 0, 0, 0));
        this.textArea.setEditable(false);
        Font font = UIManager.getFont("Label.font");
        String bodyRule = "body { font-family: " + font.getFamily() + "; font-size: " + font.getSize() + "pt; }";
        HTMLDocument doc = (HTMLDocument)this.textArea.getDocument();
        doc.getStyleSheet().addRule(bodyRule);
        this.textArea.setText(textString);
    }

    @Override
    public Component getComponent() {
        return this.textArea;
    }

    @Override
    public boolean validate() {
        return true;
    }

    @Override
    public boolean isValueType() {
        return false;
    }

    @Override
    public OutputInfoUnit getValue() {
        return null;
    }
}

