/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.gui.swing.components;

import java.awt.Component;
import java.nio.charset.Charset;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.BorderPane;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTMLPanel {
    private static final Logger logger = LoggerFactory.getLogger(HTMLPanel.class);
    private static JFXPanel jfxPane;
    private static WebView browser;
    private static JPanel contentPane;

    public static JPanel createPanel(final String mimeType, final byte[] content) {
        contentPane = new JPanel();
        jfxPane = new JFXPanel();
        contentPane.add((Component)jfxPane);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                HTMLPanel.initFx(mimeType, content);
            }
        });
        return contentPane;
    }

    private static void initFx(String mimeType, byte[] content) {
        BorderPane borderPane = new BorderPane();
        browser = new WebView();
        WebEngine engine = browser.getEngine();
        engine.loadContent(new String(content, Charset.forName("UTF-8")));
        borderPane.setCenter((Node)browser);
        Scene scene = new Scene((Parent)borderPane, 400.0, 200.0);
        jfxPane.setScene(scene);
    }
}

