/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.gui.swing;

import java.awt.Image;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.openecard.gui.MessageDialog;
import org.openecard.gui.message.DialogType;
import org.openecard.gui.message.MessageDialogResult;
import org.openecard.gui.message.OptionType;
import org.openecard.gui.message.ReturnType;
import org.openecard.gui.swing.common.GUIDefaults;

public class SwingMessageDialog
implements MessageDialog {
    private static final Image FRAME_ICON = GUIDefaults.getImage("Frame.icon", 45, 45).getImage();

    @Override
    public MessageDialogResult showMessageDialog(String msg, String title) {
        return this.showMessageDialog(msg, title, DialogType.INFORMATION_MESSAGE);
    }

    @Override
    public MessageDialogResult showMessageDialog(String msg, String title, DialogType msgType) {
        return this.showMessageDialog(msg, title, msgType, null);
    }

    @Override
    public MessageDialogResult showMessageDialog(String msg, String title, DialogType msgType, @Nullable byte[] iconData) {
        msg = this.formatMessage(msg);
        ImageIcon icon = iconData != null ? new ImageIcon(iconData) : null;
        JOptionPane jop = new JOptionPane(msg, SwingMessageDialog.convertDialogType(msgType), -1, icon);
        JDialog dialog = jop.createDialog(title);
        dialog.setIconImage(FRAME_ICON);
        dialog.setVisible(true);
        return new MessageDialogResult(ReturnType.OK);
    }

    @Override
    public MessageDialogResult showConfirmDialog(String msg, String title) {
        return this.showConfirmDialog(msg, title, OptionType.YES_NO_CANCEL_OPTION);
    }

    @Override
    public MessageDialogResult showConfirmDialog(String msg, String title, OptionType optionType) {
        return this.showConfirmDialog(msg, title, optionType, DialogType.QUESTION_MESSAGE);
    }

    @Override
    public MessageDialogResult showConfirmDialog(String msg, String title, OptionType optionType, DialogType msgType) {
        return this.showConfirmDialog(msg, title, optionType, msgType, null);
    }

    @Override
    public MessageDialogResult showConfirmDialog(String msg, String title, OptionType optionType, DialogType msgType, @Nullable byte[] iconData) {
        msg = this.formatMessage(msg);
        ImageIcon icon = iconData != null ? new ImageIcon(iconData) : null;
        JOptionPane jop = new JOptionPane(msg, SwingMessageDialog.convertDialogType(msgType), SwingMessageDialog.convertOptionType(optionType), icon);
        JDialog dialog = jop.createDialog(title);
        dialog.setIconImage(FRAME_ICON);
        dialog.setVisible(true);
        Object returnValue = jop.getValue();
        if (returnValue == null) {
            return new MessageDialogResult(ReturnType.CANCEL);
        }
        return new MessageDialogResult(SwingMessageDialog.convertReturnType((Integer)returnValue));
    }

    @Override
    public MessageDialogResult showInputDialog(String msg, String title) {
        return this.showInputDialog(msg, title, "");
    }

    @Override
    public MessageDialogResult showInputDialog(String msg, String title, String initialValue) {
        return this.showInputDialog(msg, title, DialogType.QUESTION_MESSAGE, initialValue);
    }

    @Override
    public MessageDialogResult showInputDialog(String msg, String title, DialogType msgType, String initialValue) {
        msg = this.formatMessage(msg);
        JOptionPane jop = new JOptionPane(msg, SwingMessageDialog.convertDialogType(msgType), 2);
        JDialog dialog = jop.createDialog(title);
        dialog.setIconImage(FRAME_ICON);
        jop.setInitialSelectionValue(initialValue);
        jop.setWantsInput(true);
        dialog.setVisible(true);
        Object returnValue = jop.getInputValue();
        if (returnValue == null) {
            return new MessageDialogResult((String)null);
        }
        return new MessageDialogResult((String)returnValue);
    }

    @Override
    public MessageDialogResult showInputDialog(String msg, String title, DialogType msgType, byte[] iconData, int initialSelectedIndex, String ... options) {
        msg = this.formatMessage(msg);
        List<String> optionsList = Arrays.asList(options);
        if (optionsList.isEmpty()) {
            throw new IllegalArgumentException("List of options must be given.");
        }
        if (initialSelectedIndex > optionsList.size()) {
            initialSelectedIndex = 0;
        }
        String initialValue = optionsList.get(initialSelectedIndex);
        ImageIcon icon = new ImageIcon(iconData);
        JOptionPane jop = new JOptionPane(msg, SwingMessageDialog.convertDialogType(msgType), 2, icon);
        JDialog dialog = jop.createDialog(title);
        dialog.setIconImage(FRAME_ICON);
        jop.setSelectionValues(options);
        jop.setInitialSelectionValue(initialValue);
        jop.setWantsInput(true);
        dialog.setVisible(true);
        Object returnValue = jop.getInputValue();
        if ("uninitializedValue".equals(returnValue) && !optionsList.contains("uninitializedValue")) {
            return new MessageDialogResult(ReturnType.CANCEL);
        }
        return new MessageDialogResult((String)returnValue);
    }

    @Override
    public MessageDialogResult showOptionDialog(String msg, String title, OptionType optionType, DialogType msgType, byte[] iconData, String ... options) {
        msg = this.formatMessage(msg);
        if (options.length == 0) {
            throw new IllegalArgumentException("List of options must be given.");
        }
        ImageIcon icon = null;
        if (iconData != null) {
            icon = new ImageIcon(iconData);
        }
        JOptionPane jop = new JOptionPane(msg, SwingMessageDialog.convertDialogType(msgType), SwingMessageDialog.convertOptionType(optionType), icon, options);
        JDialog dialog = jop.createDialog(title);
        dialog.setIconImage(FRAME_ICON);
        dialog.setVisible(true);
        Object returnValue = jop.getValue();
        if (returnValue == null) {
            return new MessageDialogResult(ReturnType.CANCEL);
        }
        return new MessageDialogResult((String)returnValue);
    }

    private static int convertOptionType(OptionType optionType) {
        switch (optionType) {
            case YES_NO_OPTION: {
                return 0;
            }
            case YES_NO_CANCEL_OPTION: {
                return 1;
            }
            case OK_CANCEL_OPTION: {
                return 2;
            }
        }
        throw new IllegalArgumentException();
    }

    private static int convertDialogType(DialogType dialogType) {
        switch (dialogType) {
            case ERROR_MESSAGE: {
                return 0;
            }
            case INFORMATION_MESSAGE: {
                return 1;
            }
            case WARNING_MESSAGE: {
                return 2;
            }
            case QUESTION_MESSAGE: {
                return 3;
            }
            case PLAIN_MESSAGE: {
                return -1;
            }
        }
        throw new IllegalArgumentException();
    }

    private static ReturnType convertReturnType(int returnValue) {
        switch (returnValue) {
            case 0: {
                return ReturnType.OK;
            }
            case 1: {
                return ReturnType.NO;
            }
            case 2: {
                return ReturnType.CANCEL;
            }
        }
        throw new IllegalArgumentException();
    }

    private String formatMessage(String message) {
        StringBuilder builder = new StringBuilder();
        builder.append("<html><body style='width: 450px;'><p>");
        builder.append(message.replace("\n", "<br>"));
        builder.append("</p></body></html>");
        return builder.toString();
    }
}

