/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.gui.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import org.openecard.gui.ResultStatus;
import org.openecard.gui.StepResult;
import org.openecard.gui.definition.OutputInfoUnit;
import org.openecard.gui.definition.Step;
import org.openecard.gui.executor.BackgroundTask;
import org.openecard.gui.executor.StepActionResult;
import org.openecard.gui.swing.SwingStepResult;
import org.openecard.gui.swing.common.NavigationEvent;
import org.openecard.gui.swing.components.Focusable;
import org.openecard.gui.swing.components.StepComponent;
import org.openecard.gui.swing.steplayout.StepLayouter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StepFrame {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(StepFrame.class);
    private final JPanel panel = new JPanel();
    private final Step step;
    private final String dialogType;
    private SwingStepResult stepResult;
    private List<StepComponent> components;
    private Thread bgThread;

    public StepFrame(Step step, String dialogType) {
        this.step = step;
        this.dialogType = dialogType;
        this.stepResult = new SwingStepResult(step);
        this.initLayout();
    }

    private void initLayout() {
        this.panel.setLayout(new BorderLayout());
    }

    private void initComponents() {
        StepLayouter stepLayouter = StepLayouter.create(this.step.getInputInfoUnits(), this.dialogType, this.step.getTitle());
        Container contentPanel = stepLayouter.getPanel();
        this.panel.add((Component)contentPanel, "Center");
        this.components = stepLayouter.getComponents();
    }

    public void resetResult() {
        this.stepResult = new SwingStepResult(this.step);
    }

    public boolean isInstantReturn() {
        return this.step.isInstantReturn();
    }

    public Container getPanel() {
        this.revalidate(this.panel);
        return this.panel;
    }

    public Step getStep() {
        return this.step;
    }

    public boolean validateComponents() {
        for (StepComponent next : this.components) {
            Component component = next.getComponent();
            if (next.isValueType() && !next.validate()) {
                component.setBackground(Color.RED);
                return false;
            }
            component.setBackground(null);
        }
        return true;
    }

    public List<OutputInfoUnit> getResultContent() {
        ArrayList<OutputInfoUnit> result = new ArrayList<OutputInfoUnit>(this.components.size());
        for (StepComponent next : this.components) {
            if (!next.isValueType()) continue;
            result.add(next.getValue());
        }
        return result;
    }

    public void updateFrame() {
        this.panel.removeAll();
        this.initComponents();
        this.revalidate(this.panel);
        this.setFocus();
        this.runBackgroundTask();
    }

    public StepResult getStepResult() {
        return this.stepResult;
    }

    private void revalidate(Container c) {
        for (int i = 0; i < c.getComponentCount(); ++i) {
            Component next = c.getComponent(i);
            if (next instanceof Container) {
                this.revalidate((Container)next);
                continue;
            }
            this.revalidate(next);
        }
        c.revalidate();
        c.repaint();
    }

    private void revalidate(Component c) {
        c.revalidate();
        c.repaint();
    }

    private void setFocus() {
        for (StepComponent next : this.components) {
            if (!(next instanceof Focusable)) continue;
            ((Focusable)((Object)next)).setFocus();
            return;
        }
    }

    public void lockControls() {
    }

    public void unlockControls() {
    }

    public void updateResult(NavigationEvent event) {
        this.killBackgroundTask();
        switch (event) {
            case BACK: {
                this.stepResult.setResult(this.getResultContent());
                this.stepResult.setResultStatus(ResultStatus.BACK);
                break;
            }
            case NEXT: {
                this.stepResult.setResult(this.getResultContent());
                this.stepResult.setResultStatus(ResultStatus.OK);
                break;
            }
            default: {
                this.stepResult.setResultStatus(ResultStatus.CANCEL);
            }
        }
        try {
            LOG.debug("Exchange result for step '{}'.", (Object)this.step.getTitle());
            this.stepResult.syncPoint.exchange(null);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void forceResult(StepActionResult result) {
        this.stepResult.setReplacement(result.getReplacement());
        switch (result.getStatus()) {
            case BACK: {
                this.stepResult.setResult(this.getResultContent());
                this.stepResult.setResultStatus(ResultStatus.BACK);
                break;
            }
            case NEXT: {
                this.stepResult.setResult(this.getResultContent());
                this.stepResult.setResultStatus(ResultStatus.OK);
                break;
            }
            case REPEAT: {
                this.stepResult.setResult(this.getResultContent());
                this.stepResult.setResultStatus(ResultStatus.RELOAD);
                break;
            }
            default: {
                this.stepResult.setResultStatus(ResultStatus.CANCEL);
            }
        }
        try {
            LOG.debug("Exchange result from background task for step '{}'.", (Object)this.step.getTitle());
            this.stepResult.syncPoint.exchange(null);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void killBackgroundTask() {
        LOG.debug("Trying to kill background task if it exists.");
        if (this.bgThread != null && this.bgThread.isAlive()) {
            LOG.debug("Killing background task.");
            this.bgThread.interrupt();
        }
    }

    private void runBackgroundTask() {
        final BackgroundTask task = this.step.getBackgroundTask();
        if (task != null) {
            this.bgThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        StepActionResult result = (StepActionResult)task.call();
                        LOG.debug("Background thread terminated before the GUI.");
                        StepFrame.this.forceResult(result);
                    }
                    catch (InterruptedException ex) {
                        LOG.debug("Background task has been terminated from the Swing GUI.", ex);
                    }
                    catch (Exception ex) {
                        LOG.error("Background task terminated with an exception.", ex);
                    }
                }
            }, "Swing-GUI-BG-Task");
            this.bgThread.setDaemon(true);
            this.bgThread.start();
        }
    }
}

