/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.gui.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.openecard.common.util.FileUtils;
import org.openecard.gui.definition.Step;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StepBar
extends JPanel {
    private static final Logger logger = LoggerFactory.getLogger(StepBar.class);
    private static final long serialVersionUID = 1L;
    private static final ImageIcon loader;
    private List<Step> steps;
    private List<JLabel> labels;
    private int curIdx = -1;

    public StepBar(List<Step> steps) {
        this.updateStepBar(steps);
    }

    public void updateStepBar(List<Step> steps) {
        this.steps = steps;
        this.labels = new ArrayList<JLabel>(steps.size());
        this.removeAll();
        this.initializeLayout();
        this.initializeComponents();
    }

    public void selectIdx(int nextIdx) {
        int oldIdx = this.curIdx;
        this.curIdx = nextIdx;
        logger.debug("Selecting index {}, previous was {}.", (Object)nextIdx, (Object)oldIdx);
        if (oldIdx >= 0 && oldIdx < this.getComponentCount()) {
            this.getComponent(oldIdx).setForeground(Color.GRAY);
        }
        if (nextIdx >= 0 && nextIdx < this.getComponentCount()) {
            this.getComponent(nextIdx).setForeground(Color.BLACK);
        }
    }

    public void enableLoaderImage() {
        if (this.curIdx >= 0 && this.curIdx < this.labels.size()) {
            JLabel label = this.labels.get(this.curIdx);
            label.setIcon(loader);
        }
    }

    public void disableLoaderImage() {
        if (this.curIdx >= 0 && this.curIdx < this.labels.size()) {
            JLabel label = this.labels.get(this.curIdx);
            label.setIcon(null);
        }
    }

    private void initializeLayout() {
        this.setLayout(new GridBagLayout());
    }

    private void initializeComponents() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 19;
        gbc.ipady = 10;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        Font font = UIManager.getFont("Label.font").deriveFont(0);
        for (String name : StepBar.getStepNames(this.steps)) {
            JLabel l = new JLabel(name);
            l.setFont(font);
            this.labels.add(l);
            l.setIconTextGap(10);
            l.setHorizontalTextPosition(2);
            l.setForeground(Color.GRAY);
            this.add((Component)l, gbc);
        }
        gbc.weighty = 1.0;
        this.add((Component)new JLabel(), gbc);
    }

    private static String[] getStepNames(List<Step> steps) {
        ArrayList<String> stepNames = new ArrayList<String>(steps.size());
        for (Step s : steps) {
            stepNames.add(s.getTitle());
        }
        return stepNames.toArray(new String[steps.size()]);
    }

    static {
        URL loaderUrl = FileUtils.resolveResourceAsURL(StepBar.class, "loader.gif");
        loader = new ImageIcon(loaderUrl);
    }
}

