/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.gui.definition;

import java.util.Arrays;
import org.openecard.gui.definition.Document;
import org.openecard.gui.definition.IDTrait;
import org.openecard.gui.definition.InfoUnit;
import org.openecard.gui.definition.InfoUnitElementType;
import org.openecard.gui.definition.InputInfoUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ImageBox
extends IDTrait
implements InputInfoUnit {
    private static final Logger LOG = LoggerFactory.getLogger(ImageBox.class);
    private Document doc;

    public byte[] getImageData() {
        byte[] imageData = this.doc.getValue();
        return Arrays.copyOf(imageData, imageData.length);
    }

    public void setImageData(byte[] imageData) {
        this.doc.setValue(Arrays.copyOf(imageData, imageData.length));
    }

    public String getMimeType() {
        return this.doc.getMimeType();
    }

    public void setMimeType(String mimeType) {
        this.doc.setMimeType(mimeType);
    }

    public Document getDocument() {
        return this.doc;
    }

    public void setDocument(Document doc) {
        this.doc = doc;
    }

    @Override
    public InfoUnitElementType type() {
        return InfoUnitElementType.IMAGE_BOX;
    }

    @Override
    public void copyContentFrom(InfoUnit origin) {
        if (!this.getClass().equals(origin.getClass())) {
            LOG.warn("Trying to copy content from type {} to type {}.", (Object)origin.getClass(), (Object)this.getClass());
            return;
        }
        ImageBox other = (ImageBox)origin;
        if (other.getDocument() != null) {
            try {
                this.setDocument(other.getDocument().clone());
            }
            catch (CloneNotSupportedException ex) {
                throw new AssertionError((Object)"Clone not implemented correctly in Document class.");
            }
        }
    }
}

