/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.crypto.tls.verify;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.util.ArrayList;
import java.util.Set;
import org.openecard.bouncycastle.tls.TlsServerCertificate;
import org.openecard.bouncycastle.tls.crypto.TlsCertificate;
import org.openecard.crypto.tls.CertificateVerificationException;
import org.openecard.crypto.tls.CertificateVerifier;
import org.openecard.crypto.tls.verify.TrustStoreLoader;

public class JavaSecVerifier
implements CertificateVerifier {
    protected final boolean checkRevocation;
    protected final CertPathValidator certPathValidator;

    public JavaSecVerifier() throws RuntimeException {
        this(false);
    }

    public JavaSecVerifier(boolean checkRevocation) throws RuntimeException {
        this.checkRevocation = checkRevocation;
        try {
            this.certPathValidator = CertPathValidator.getInstance("PKIX");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException("Failed to load CertPathValidator");
        }
    }

    protected Set<TrustAnchor> getTrustStore() {
        return new TrustStoreLoader().getTrustAnchors();
    }

    @Override
    public void isValid(TlsServerCertificate chain, String hostname) throws CertificateVerificationException {
        try {
            CertPath certPath = JavaSecVerifier.convertChain(chain);
            PKIXParameters params = new PKIXParameters(this.getTrustStore());
            if (this.checkRevocation) {
                params.setRevocationEnabled(true);
                System.setProperty("com.sun.security.enableCRLDP", "true");
            } else {
                params.setRevocationEnabled(false);
            }
            this.certPathValidator.validate(certPath, params);
        }
        catch (CertPathValidatorException ex) {
            throw new CertificateVerificationException(ex.getMessage());
        }
        catch (GeneralSecurityException ex) {
            throw new CertificateVerificationException(ex.getMessage());
        }
        catch (IOException ex) {
            throw new CertificateVerificationException("Error converting certificate chain to java.security format.");
        }
    }

    public static CertPath convertChain(TlsServerCertificate chain) throws CertificateException, IOException {
        int numCerts = chain.getCertificate().getCertificateList().length;
        ArrayList<Certificate> result = new ArrayList<Certificate>(numCerts);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        for (TlsCertificate next : chain.getCertificate().getCertificateList()) {
            Certificate nextConverted = JavaSecVerifier.convertCertificateInt(cf, next);
            result.add(nextConverted);
        }
        return cf.generateCertPath(result);
    }

    public static Certificate convertCertificate(TlsCertificate cert) throws CertificateException, IOException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        return JavaSecVerifier.convertCertificateInt(cf, cert);
    }

    public static Certificate convertCertificateInt(CertificateFactory cf, TlsCertificate cert) throws CertificateException, IOException {
        byte[] nextData = cert.getEncoded();
        ByteArrayInputStream nextDataStream = new ByteArrayInputStream(nextData);
        Certificate nextConverted = cf.generateCertificate(nextDataStream);
        return nextConverted;
    }
}

