/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.crypto.tls.verify;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import javax.annotation.Nonnull;
import org.openecard.bouncycastle.tls.TlsServerCertificate;
import org.openecard.crypto.tls.CertificateVerificationException;
import org.openecard.crypto.tls.CertificateVerifier;

public class CertificateVerifierBuilder {
    private final CertificateVerifierBuilder parent;
    private final LinkedList<CertificateVerifierBuilder> orChilds = new LinkedList();
    private final LinkedList<CertificateVerifier> andList = new LinkedList();

    public CertificateVerifierBuilder() {
        this.parent = null;
    }

    private CertificateVerifierBuilder(CertificateVerifierBuilder parent) {
        this.parent = parent;
    }

    public CertificateVerifierBuilder and(CertificateVerifier ... verifier) {
        if (this.orChilds.isEmpty()) {
            return this.and(Arrays.asList(verifier));
        }
        throw new IllegalStateException("The CertificateVerifierBuilder already contains OR elements.");
    }

    public CertificateVerifierBuilder and(@Nonnull Collection<CertificateVerifier> verifier) {
        if (this.orChilds.isEmpty()) {
            this.andList.addAll(verifier);
            return this;
        }
        throw new IllegalStateException("The CertificateVerifierBuilder already contains OR elements.");
    }

    public CertificateVerifierBuilder or() {
        if (this.andList.isEmpty()) {
            CertificateVerifierBuilder cvb = new CertificateVerifierBuilder(this);
            this.orChilds.add(cvb);
            return cvb;
        }
        throw new IllegalStateException("The CertificateVerifierBuilder already contains AND elements.");
    }

    public CertificateVerifier build() {
        if (this.parent != null) {
            return this.parent.build();
        }
        return this.buildInternal();
    }

    private CertificateVerifier buildInternal() {
        final Collection<CertificateVerifier> andCopy = Collections.unmodifiableCollection(this.andList);
        final ArrayList<CertificateVerifier> orCopy = new ArrayList<CertificateVerifier>(this.orChilds.size());
        for (CertificateVerifierBuilder next : this.orChilds) {
            orCopy.add(next.buildInternal());
        }
        return new CertificateVerifier(){

            @Override
            public void isValid(TlsServerCertificate chain, String hostname) throws CertificateVerificationException {
                if (!andCopy.isEmpty()) {
                    for (CertificateVerifier cv : andCopy) {
                        cv.isValid(chain, hostname);
                    }
                } else if (!orCopy.isEmpty()) {
                    boolean noSuccess = true;
                    for (CertificateVerifier cv : orCopy) {
                        try {
                            cv.isValid(chain, hostname);
                            break;
                        }
                        catch (CertificateVerificationException ex) {
                            noSuccess = false;
                        }
                    }
                    if (noSuccess) {
                        String msg = "None of the possible validation paths succeeded.";
                        throw new CertificateVerificationException(msg);
                    }
                }
            }
        };
    }
}

