/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.crypto.tls.proxy;

import java.io.IOException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.List;
import org.openecard.crypto.tls.proxy.NoProxySelector;
import org.openecard.crypto.tls.proxy.SelectorSupplier;

public class UpdatingProxySelector
extends ProxySelector {
    private static final long UPDATE_DELTA = 30000L;
    private final SelectorSupplier supplier;
    private long lastUpdate = 0L;
    private ProxySelector lastSelector;

    public UpdatingProxySelector(SelectorSupplier supplier) {
        this.supplier = supplier;
        this.loadSelector();
    }

    private synchronized void loadSelector() {
        long now = System.currentTimeMillis();
        long diff = now - this.lastUpdate;
        if (diff > 30000L) {
            this.lastUpdate = now;
            ProxySelector selector = this.supplier.find();
            if (selector == null) {
                selector = new NoProxySelector();
            }
            this.lastSelector = selector;
        }
    }

    @Override
    public List<Proxy> select(URI uri) {
        this.loadSelector();
        return this.lastSelector.select(uri);
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
        this.lastSelector.connectFailed(uri, sa, ioe);
    }
}

