/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.crypto.tls.proxy;

import java.io.IOException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class RegexProxySelector
extends ProxySelector {
    private final ProxySelector parent;
    private final List<Pattern> hosts;

    public RegexProxySelector(@Nonnull ProxySelector parent, @Nonnull List<Pattern> hosts) {
        this.parent = parent;
        this.hosts = hosts;
    }

    public boolean isExclusion(URI uri) {
        String hostPort = uri.getHost() + ":" + uri.getPort();
        for (Pattern next : this.hosts) {
            Matcher m = next.matcher(hostPort);
            if (!m.matches()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Proxy> select(URI uri) {
        if (this.isExclusion(uri)) {
            return Collections.singletonList(Proxy.NO_PROXY);
        }
        return this.parent.select(uri);
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
        this.parent.connectFailed(uri, sa, ioe);
    }
}

