/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.crypto.tls;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TlsError {
    private final short alertLevel;
    private final short alertDescription;
    private final String message;
    private final Throwable cause;

    public TlsError(short alertLevel, short alertDescription) {
        this(alertLevel, alertDescription, null, null);
    }

    public TlsError(short alertLevel, short alertDescription, @Nullable String message, @Nullable Throwable cause) {
        this.alertLevel = alertLevel;
        this.alertDescription = alertDescription;
        this.message = message;
        this.cause = cause;
    }

    public short getAlertLevel() {
        return this.alertLevel;
    }

    public String getAlertLevelStr() {
        switch (this.getAlertLevel()) {
            case 2: {
                return "FATAL";
            }
            case 1: {
                return "WARN";
            }
        }
        return "UNKNOWN";
    }

    public short getAlertDescription() {
        return this.alertDescription;
    }

    public String getAlertDescriptionStr() {
        switch (this.alertDescription) {
            case 0: {
                return String.format("Close [close_notify=%d]", this.alertDescription);
            }
            case 10: {
                return String.format("Unexpected message [unexpected_message=%d]", this.alertDescription);
            }
            case 20: {
                return String.format("MAC of record invalid [bad_record_mac=%d]", this.alertDescription);
            }
            case 21: {
                return String.format("Decryption failed [decryption_failed=%d]", this.alertDescription);
            }
            case 22: {
                return String.format("Overly large record received [record_overflow=%d]", this.alertDescription);
            }
            case 30: {
                return String.format("Decompression failed [decompression_failure=%d]", this.alertDescription);
            }
            case 40: {
                return String.format("No acceptable set of security parameters found [handshake_failure=%d]", this.alertDescription);
            }
            case 41: {
                return String.format("No certificate [no_certificate=%d]", this.alertDescription);
            }
            case 42: {
                return String.format("Certificate corrupt [bad_certificate=%d]", this.alertDescription);
            }
            case 43: {
                return String.format("Certificate type not supported [unsupported_certificate=%d]", this.alertDescription);
            }
            case 44: {
                return String.format("Certificate revoked [certificate_revoked=%d]", this.alertDescription);
            }
            case 45: {
                return String.format("Certificate expired [certificate_expired=%d]", this.alertDescription);
            }
            case 46: {
                return String.format("Certificate invalid [certificate_unknown=%d]", this.alertDescription);
            }
            case 47: {
                return String.format("Illegal parameter in handshake [illegal_parameter=%d]", this.alertDescription);
            }
            case 48: {
                return String.format("No trust anchor found [unknown_ca=%d]", this.alertDescription);
            }
            case 49: {
                return String.format("Access denied [access_denied=%d]", this.alertDescription);
            }
            case 50: {
                return String.format("Message decoding error [decode_error=%d]", this.alertDescription);
            }
            case 51: {
                return String.format("Handshake operation failed [decrypt_error=%d]", this.alertDescription);
            }
            case 60: {
                return String.format("Export restriction [export_restriction=%d]", this.alertDescription);
            }
            case 70: {
                return String.format("No common protocol version [protocol_version=%d]", this.alertDescription);
            }
            case 71: {
                return String.format("Security requirements not met [insufficient_security=%d]", this.alertDescription);
            }
            case 80: {
                return String.format("Internal error [internal_error=%d]", this.alertDescription);
            }
            case 90: {
                return String.format("User cancellation [user_canceled=%d]", this.alertDescription);
            }
            case 100: {
                return String.format("Renegotiation support missing [no_renegotiation=%d]", this.alertDescription);
            }
            case 110: {
                return String.format("Unsupported extension received [unsupported_extension=%d]", this.alertDescription);
            }
            case 111: {
                return String.format("Bad client certificate [certificate_unobtainable=%d]", this.alertDescription);
            }
            case 112: {
                return String.format("SNI name unknown [unrecognized_name=%d]", this.alertDescription);
            }
            case 113: {
                return String.format("Client certificate invalid [bad_certificate_status_response=%d]", this.alertDescription);
            }
            case 114: {
                return String.format("Client certificate hash invalid [bad_certificate_hash_value=%d]", this.alertDescription);
            }
            case 115: {
                return String.format("PSK identity unkown [unknown_psk_identity=%d]", this.alertDescription);
            }
        }
        return String.format("Unknown alert (%d)", this.alertDescription);
    }

    @Nonnull
    public String getMessage() {
        if (this.message == null) {
            Throwable causeTmp = this.getCause();
            if (causeTmp == null) {
                return "Unknown error.";
            }
            return causeTmp.getMessage();
        }
        return this.message;
    }

    @Nullable
    public Throwable getCause() {
        return this.cause;
    }

    public String toString() {
        return String.format("TLS(%s): %s --> %s", this.getAlertLevelStr(), this.getAlertDescriptionStr(), this.getMessage());
    }
}

