/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.crypto.common.sal.did;

import iso.std.iso_iec._24727.tech.schema.AlgorithmIdentifierType;
import iso.std.iso_iec._24727.tech.schema.AlgorithmInfoType;
import iso.std.iso_iec._24727.tech.schema.CardCallTemplateType;
import iso.std.iso_iec._24727.tech.schema.CertificateRefType;
import iso.std.iso_iec._24727.tech.schema.CryptoKeyInfoType;
import iso.std.iso_iec._24727.tech.schema.DIDAbstractMarkerType;
import iso.std.iso_iec._24727.tech.schema.HashGenerationInfoType;
import iso.std.iso_iec._24727.tech.schema.KeyRefType;
import iso.std.iso_iec._24727.tech.schema.LegacySignatureGenerationType;
import iso.std.iso_iec._24727.tech.schema.StateInfo;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.openecard.common.util.StringUtils;
import org.openecard.crypto.common.sal.did.AbstractMarkerType;
import org.openecard.ws.marshal.WSMarshaller;
import org.openecard.ws.marshal.WSMarshallerException;
import org.openecard.ws.marshal.WSMarshallerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CryptoMarkerType
extends AbstractMarkerType {
    private static final Logger LOG = LoggerFactory.getLogger(CryptoMarkerType.class);
    private WSMarshaller m;
    private String legacyKeyName = null;
    private AlgorithmInfoType algorithmInfo = null;
    private HashGenerationInfoType hashGenerationInfo = null;
    private List<CertificateRefType> certificateRefs = null;
    private CryptoKeyInfoType cryptoKeyInfo = null;
    private String[] signatureGenerationInfo = null;
    private List<Object> legacySignatureGenerationInfo = null;

    public CryptoMarkerType(DIDAbstractMarkerType baseType) {
        super(baseType);
        try {
            this.m = WSMarshallerFactory.createInstance();
        }
        catch (WSMarshallerException ex) {
            throw new RuntimeException("Failed to instanciate WSMarshaller.", ex);
        }
        block65: for (Element elem : this.marker.getAny()) {
            switch (elem.getLocalName()) {
                case "AlgorithmInfo": {
                    this.algorithmInfo = new AlgorithmInfoType();
                    NodeList algorithmInfoNodes = elem.getChildNodes();
                    block66: for (int i = 0; i < algorithmInfoNodes.getLength(); ++i) {
                        Node node = algorithmInfoNodes.item(i);
                        switch (node.getLocalName()) {
                            case "Algorithm": {
                                this.algorithmInfo.setAlgorithm(node.getTextContent());
                                continue block66;
                            }
                            case "AlgorithmIdentifier": {
                                AlgorithmIdentifierType algorithmIdentifierType = new AlgorithmIdentifierType();
                                NodeList nodeList = node.getChildNodes();
                                block67: for (int y = 0; y < nodeList.getLength(); ++y) {
                                    Node n = nodeList.item(y);
                                    if (null == n.getLocalName()) continue;
                                    switch (n.getLocalName()) {
                                        case "Algorithm": {
                                            algorithmIdentifierType.setAlgorithm(n.getTextContent());
                                            continue block67;
                                        }
                                        case "Parameters": {
                                            algorithmIdentifierType.setParameters(n);
                                        }
                                    }
                                }
                                this.algorithmInfo.setAlgorithmIdentifier(algorithmIdentifierType);
                                continue block66;
                            }
                            case "SupportedOperations": {
                                String[] supportedOperations = node.getTextContent().split(" ");
                                this.algorithmInfo.getSupportedOperations().addAll(Arrays.asList(supportedOperations));
                                continue block66;
                            }
                            case "CardAlgRef": {
                                this.algorithmInfo.setCardAlgRef(StringUtils.toByteArray(node.getTextContent()));
                                continue block66;
                            }
                            case "HashAlgRef": {
                                this.algorithmInfo.setHashAlgRef(StringUtils.toByteArray(node.getTextContent()));
                            }
                        }
                    }
                    continue block65;
                }
                case "KeyInfo": {
                    this.cryptoKeyInfo = new CryptoKeyInfoType();
                    NodeList nodeList = elem.getChildNodes();
                    block68: for (int i = 0; i < nodeList.getLength(); ++i) {
                        Node n = nodeList.item(i);
                        switch (n.getLocalName()) {
                            case "KeyRef": {
                                KeyRefType keyRef = new KeyRefType();
                                keyRef.setKeyRef(StringUtils.toByteArray(n.getTextContent()));
                                this.cryptoKeyInfo.setKeyRef(keyRef);
                                continue block68;
                            }
                            case "KeySize": {
                                this.cryptoKeyInfo.setKeySize(new BigInteger(n.getTextContent()));
                            }
                        }
                    }
                    continue block65;
                }
                case "SignatureGenerationInfo": {
                    this.signatureGenerationInfo = elem.getTextContent().split(" ");
                    break;
                }
                case "LegacySignatureGenerationInfo": {
                    NodeList nodeList = elem.getChildNodes();
                    this.legacySignatureGenerationInfo = new ArrayList<Object>();
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        Object e;
                        Node n = nodeList.item(i);
                        if (n.getLocalName().equals("CardCommand")) {
                            try {
                                e = this.m.unmarshal(n, CardCallTemplateType.class);
                                this.legacySignatureGenerationInfo.add(e.getValue());
                            }
                            catch (WSMarshallerException ex) {
                                LOG.error("Failed to unmarshal CardCommand.", ex);
                            }
                            continue;
                        }
                        if (!n.getLocalName().equals("APICommand")) continue;
                        try {
                            e = this.m.unmarshal(n, LegacySignatureGenerationType.APICommand.class);
                            this.legacySignatureGenerationInfo.add(e.getValue());
                            continue;
                        }
                        catch (WSMarshallerException ex) {
                            LOG.error("Failed to unmarshal APICommand.", ex);
                        }
                    }
                    continue block65;
                }
                case "HashGenerationInfo": {
                    this.hashGenerationInfo = HashGenerationInfoType.fromValue(elem.getTextContent());
                    break;
                }
                case "CertificateRef": {
                    if (this.certificateRefs == null) {
                        this.certificateRefs = new ArrayList<CertificateRefType>();
                    }
                    CertificateRefType certificateRef = new CertificateRefType();
                    NodeList nodeList = elem.getChildNodes();
                    block70: for (int i = 0; i < nodeList.getLength(); ++i) {
                        Node n = nodeList.item(i);
                        switch (n.getLocalName()) {
                            case "DataSetName": {
                                certificateRef.setDataSetName(n.getTextContent());
                                continue block70;
                            }
                            case "DSIName": {
                                certificateRef.setDSIName(n.getTextContent());
                                continue block70;
                            }
                            case "CertificateType": {
                                certificateRef.setCertificateType(n.getTextContent());
                            }
                        }
                    }
                    this.certificateRefs.add(certificateRef);
                    break;
                }
                case "LegacyKeyName": {
                    this.legacyKeyName = elem.getTextContent();
                    break;
                }
            }
        }
    }

    public String[] getSignatureGenerationInfo() {
        if (this.signatureGenerationInfo == null) {
            return null;
        }
        return (String[])this.signatureGenerationInfo.clone();
    }

    public List<Object> getLegacySignatureGenerationInfo() {
        if (this.legacySignatureGenerationInfo == null) {
            return null;
        }
        return Collections.unmodifiableList(this.legacySignatureGenerationInfo);
    }

    public CryptoKeyInfoType getCryptoKeyInfo() {
        return this.cryptoKeyInfo;
    }

    public String getLegacyKeyName() {
        return this.legacyKeyName;
    }

    public AlgorithmInfoType getAlgorithmInfo() {
        return this.algorithmInfo;
    }

    public HashGenerationInfoType getHashGenerationInfo() {
        return this.hashGenerationInfo;
    }

    public List<CertificateRefType> getCertificateRefs() {
        return this.certificateRefs;
    }

    public StateInfo getStateInfo() {
        throw new UnsupportedOperationException("Not yet implemented");
    }
}

