/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.crypto.common.sal.did;

import iso.std.iso_iec._24727.tech.schema.ACLList;
import iso.std.iso_iec._24727.tech.schema.ACLListResponse;
import iso.std.iso_iec._24727.tech.schema.AccessRuleType;
import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import iso.std.iso_iec._24727.tech.schema.CryptographicServiceActionName;
import iso.std.iso_iec._24727.tech.schema.DIDAuthenticationStateType;
import iso.std.iso_iec._24727.tech.schema.DIDGet;
import iso.std.iso_iec._24727.tech.schema.DIDGetResponse;
import iso.std.iso_iec._24727.tech.schema.DIDScopeType;
import iso.std.iso_iec._24727.tech.schema.DIDStructureType;
import iso.std.iso_iec._24727.tech.schema.NamedDataServiceActionName;
import iso.std.iso_iec._24727.tech.schema.SecurityConditionType;
import iso.std.iso_iec._24727.tech.schema.TargetNameType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.openecard.common.SecurityConditionUnsatisfiable;
import org.openecard.common.WSHelper;
import org.openecard.common.interfaces.Dispatcher;
import org.openecard.common.util.HandlerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ACLResolver {
    private static final Logger LOG = LoggerFactory.getLogger(ACLResolver.class);
    private final Dispatcher dispatcher;
    private final ConnectionHandleType handle;

    public ACLResolver(Dispatcher dispatcher, ConnectionHandleType handle) {
        this.dispatcher = dispatcher;
        this.handle = HandlerUtils.copyHandle(handle);
    }

    public List<DIDStructureType> getUnsatisfiedDIDs(TargetNameType target) throws WSHelper.WSException, SecurityConditionUnsatisfiable {
        ACLList aclReq = new ACLList();
        aclReq.setConnectionHandle(this.handle);
        aclReq.setTargetName(target);
        ACLListResponse aclRes = (ACLListResponse)this.dispatcher.safeDeliver(aclReq);
        WSHelper.checkResult(aclRes);
        List<AccessRuleType> acls = aclRes.getTargetACL().getAccessRule();
        List<DIDStructureType> dids = this.getMissingDids(acls, target);
        return dids;
    }

    public List<DIDStructureType> getUnsatisfiedDIDs(TargetNameType target, List<AccessRuleType> acls) throws WSHelper.WSException, SecurityConditionUnsatisfiable {
        List<DIDStructureType> dids = this.getMissingDids(acls, target);
        return dids;
    }

    private List<DIDStructureType> getMissingDids(List<AccessRuleType> acls, TargetNameType target) throws WSHelper.WSException, SecurityConditionUnsatisfiable {
        ArrayList<AccessRuleType> tmpAcls = new ArrayList<AccessRuleType>();
        for (AccessRuleType accessRuleType : acls) {
            CryptographicServiceActionName cryptographicServiceActionName;
            if (target.getDIDName() != null && CryptographicServiceActionName.SIGN.equals((Object)(cryptographicServiceActionName = accessRuleType.getAction().getCryptographicServiceAction()))) {
                tmpAcls.add(accessRuleType);
                break;
            }
            if (target.getDataSetName() == null) continue;
            NamedDataServiceActionName namedDataServiceActionName = accessRuleType.getAction().getNamedDataServiceAction();
            if (NamedDataServiceActionName.DATA_SET_SELECT.equals((Object)namedDataServiceActionName)) {
                tmpAcls.add(accessRuleType);
                continue;
            }
            if (!NamedDataServiceActionName.DSI_READ.equals((Object)namedDataServiceActionName)) continue;
            tmpAcls.add(accessRuleType);
        }
        ArrayList<DIDStructureType> result = new ArrayList<DIDStructureType>();
        for (AccessRuleType accessRuleType : tmpAcls) {
            SecurityConditionType cond = ACLResolver.normalize(accessRuleType.getSecurityCondition());
            cond = ACLResolver.getBestSecurityCondition(cond);
            List<DIDAuthenticationStateType> authStates = ACLResolver.flattenCondition(cond);
            List<DIDStructureType> missingDIDs = this.filterSatisfiedDIDs(authStates);
            result.addAll(missingDIDs);
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            DIDStructureType next = (DIDStructureType)iterator.next();
            if (treeSet.contains(next.getDIDName())) {
                iterator.remove();
                continue;
            }
            treeSet.add(next.getDIDName());
        }
        return result;
    }

    private static SecurityConditionType normalize(SecurityConditionType cond) {
        if (cond.getOr() == null) {
            SecurityConditionType result = new SecurityConditionType();
            SecurityConditionType.Or or = new SecurityConditionType.Or();
            result.setOr(or);
            or.getSecurityCondition().add(cond);
            return result;
        }
        return cond;
    }

    private static SecurityConditionType getBestSecurityCondition(SecurityConditionType securityCondition) {
        return securityCondition.getOr().getSecurityCondition().get(0);
    }

    private static List<DIDAuthenticationStateType> flattenCondition(SecurityConditionType conds) throws SecurityConditionUnsatisfiable {
        if (conds.getAnd() != null) {
            ArrayList<DIDAuthenticationStateType> result = new ArrayList<DIDAuthenticationStateType>();
            for (SecurityConditionType cond : conds.getAnd().getSecurityCondition()) {
                DIDAuthenticationStateType state = cond.getDIDAuthentication();
                if (state == null) continue;
                result.add(cond.getDIDAuthentication());
            }
            return result;
        }
        if (conds.getDIDAuthentication() != null) {
            ArrayList<DIDAuthenticationStateType> result = new ArrayList<DIDAuthenticationStateType>();
            result.add(conds.getDIDAuthentication());
            return result;
        }
        if (conds.isAlways() != null && conds.isAlways().booleanValue() || conds.isNever() != null && !conds.isNever().booleanValue()) {
            return Collections.emptyList();
        }
        if (conds.isNever() != null && conds.isNever().booleanValue() || conds.isAlways() != null && !conds.isAlways().booleanValue()) {
            String msg = "The ACL of the object states, that it is never satisfiable (never=true).";
            throw new SecurityConditionUnsatisfiable(msg);
        }
        String msg = "The ACL of the object is empty, defaulting to never satisfiable (never=true).";
        throw new SecurityConditionUnsatisfiable(msg);
    }

    private List<DIDStructureType> filterSatisfiedDIDs(List<DIDAuthenticationStateType> states) throws WSHelper.WSException {
        ArrayList<DIDStructureType> result = new ArrayList<DIDStructureType>(states.size());
        for (DIDAuthenticationStateType state : states) {
            if (!state.isDIDState()) continue;
            DIDGet req = new DIDGet();
            req.setConnectionHandle(this.handle);
            req.setDIDName(state.getDIDName());
            req.setDIDScope(DIDScopeType.GLOBAL);
            DIDGetResponse res = (DIDGetResponse)this.dispatcher.safeDeliver(req);
            WSHelper.checkResult(res);
            if (res.getDIDStructure().isAuthenticated()) continue;
            result.add(res.getDIDStructure());
        }
        return result;
    }
}

