/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.crypto.common.asn1.eac;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.openecard.bouncycastle.asn1.ASN1Encodable;
import org.openecard.bouncycastle.asn1.ASN1Set;
import org.openecard.bouncycastle.asn1.ASN1StreamParser;
import org.openecard.crypto.common.asn1.eac.SecurityInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityInfos {
    private static final Logger LOG = LoggerFactory.getLogger(SecurityInfos.class);
    private final ASN1Set securityInfos;

    public static SecurityInfos getInstance(Object obj) {
        if (obj instanceof SecurityInfo) {
            return (SecurityInfos)obj;
        }
        if (obj instanceof ASN1Set) {
            return new SecurityInfos((ASN1Set)obj);
        }
        if (obj instanceof byte[]) {
            return SecurityInfos.getInstance(new ByteArrayInputStream((byte[])obj));
        }
        if (obj instanceof InputStream) {
            try {
                ASN1StreamParser sp = new ASN1StreamParser((InputStream)obj);
                ASN1Encodable enc = sp.readObject();
                return SecurityInfos.getInstance(enc.toASN1Primitive());
            }
            catch (IOException e) {
                LOG.error("Cannot parse SecurityInfos", e);
            }
        }
        throw new IllegalArgumentException("Unknown object in factory: " + obj.getClass());
    }

    private SecurityInfos(ASN1Set seq) {
        this.securityInfos = seq;
    }

    public ASN1Set getSecurityInfos() {
        return this.securityInfos;
    }
}

