/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.crypto.common.asn1.eac;

import java.util.ArrayList;
import java.util.List;
import org.openecard.crypto.common.asn1.eac.PACEDomainParameterInfo;
import org.openecard.crypto.common.asn1.eac.PACEInfo;
import org.openecard.crypto.common.asn1.eac.PACESecurityInfoPair;

public final class PACESecurityInfos {
    private List<PACEDomainParameterInfo> pdpiList = new ArrayList<PACEDomainParameterInfo>();
    private List<PACEInfo> piList = new ArrayList<PACEInfo>();
    private List<PACESecurityInfoPair> pipList;

    public List<PACEDomainParameterInfo> getPACEDomainParameterInfos() {
        return this.pdpiList;
    }

    public void setPACEDomainParameterInfos(List<PACEDomainParameterInfo> paceDomainParameterInfos) {
        this.pdpiList = paceDomainParameterInfos;
    }

    public void addPACEDomainParameterInfo(PACEDomainParameterInfo paceDomainParameterInfo) {
        this.pdpiList.add(paceDomainParameterInfo);
    }

    public List<PACEInfo> getPACEInfos() {
        return this.piList;
    }

    public void setPACEInfos(List<PACEInfo> paceInfos) {
        this.piList = paceInfos;
    }

    public void addPACEInfo(PACEInfo paceInfo) {
        this.piList.add(paceInfo);
    }

    public List<PACESecurityInfoPair> getPACEInfoPairs() {
        if (this.pipList == null) {
            this.pipList = this.createPACEInfoPairs();
        }
        return this.pipList;
    }

    public List<PACESecurityInfoPair> getPACEInfoPairs(List<String> supportedProtocols, List<Integer> supportedParams) {
        ArrayList<PACESecurityInfoPair> result = new ArrayList<PACESecurityInfoPair>();
        for (PACESecurityInfoPair next : this.getPACEInfoPairs(supportedProtocols)) {
            if (!supportedParams.contains(next.getPACEInfo().getParameterID())) continue;
            result.add(next);
        }
        return result;
    }

    public List<PACESecurityInfoPair> getPACEInfoPairs(List<String> supportedProtocols) {
        ArrayList<PACESecurityInfoPair> result = new ArrayList<PACESecurityInfoPair>();
        for (PACESecurityInfoPair next : this.getPACEInfoPairs()) {
            if (!supportedProtocols.contains(next.getPACEInfo().getProtocol())) continue;
            result.add(next);
        }
        return result;
    }

    private List<PACESecurityInfoPair> createPACEInfoPairs() {
        ArrayList<PACESecurityInfoPair> result = new ArrayList<PACESecurityInfoPair>();
        if (this.piList.size() == 1) {
            if (this.pdpiList.isEmpty()) {
                result.add(new PACESecurityInfoPair(this.piList.get(0), null));
            } else {
                result.add(new PACESecurityInfoPair(this.piList.get(0), this.pdpiList.get(0)));
            }
            return result;
        }
        for (PACEInfo pi : this.piList) {
            int id = pi.getParameterID();
            boolean found = false;
            if (id != -1) {
                for (PACEDomainParameterInfo dpi : this.pdpiList) {
                    if (id != dpi.getParameterID()) continue;
                    found = true;
                    result.add(new PACESecurityInfoPair(pi, dpi));
                    break;
                }
            }
            if (found) continue;
            result.add(new PACESecurityInfoPair(pi, null));
        }
        return result;
    }
}

