/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.crypto.common.asn1.eac;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.ListIterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openecard.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.openecard.common.tlv.TLV;
import org.openecard.common.tlv.TLVException;
import org.openecard.common.tlv.Tag;
import org.openecard.common.tlv.TagClass;
import org.openecard.common.tlv.iso7816.TLVList;
import org.openecard.common.util.ByteUtils;
import org.openecard.crypto.common.asn1.eac.DiscretionaryDataTemplate;

public class AuthenticatedAuxiliaryData
extends TLVList {
    private final HashMap<ASN1ObjectIdentifier, DiscretionaryDataTemplate> templates = new HashMap();
    private boolean empty = false;

    public AuthenticatedAuxiliaryData(@Nonnull TLV tlv) throws TLVException {
        super(tlv, new Tag(TagClass.APPLICATION, false, 7L));
        ArrayList<DiscretionaryDataTemplate> ts = new ArrayList<DiscretionaryDataTemplate>();
        for (TLV tLV : this.getContent()) {
            DiscretionaryDataTemplate d = new DiscretionaryDataTemplate(tLV);
            ts.add(d);
        }
        ListIterator i = ts.listIterator(ts.size());
        while (i.hasPrevious()) {
            DiscretionaryDataTemplate discretionaryDataTemplate = (DiscretionaryDataTemplate)i.previous();
            ASN1ObjectIdentifier oid = discretionaryDataTemplate.getObjectIdentifier();
            if (this.templates.containsKey(oid)) continue;
            this.templates.put(oid, discretionaryDataTemplate);
        }
    }

    public AuthenticatedAuxiliaryData(@Nullable byte[] data) throws TLVException {
        this(AuthenticatedAuxiliaryData.emptyOrStructure(data));
        if (data == null) {
            this.empty = true;
        }
    }

    private static TLV emptyOrStructure(byte[] data) throws TLVException {
        if (data == null) {
            TLV tlv = new TLV();
            tlv.setTag(new Tag(TagClass.APPLICATION, false, 7L));
            return tlv;
        }
        return TLV.fromBER(data);
    }

    public byte[] getData() {
        return this.empty ? null : this.tlv.toBER();
    }

    public Calendar getAgeVerificationData() {
        ASN1ObjectIdentifier reqOID = new ASN1ObjectIdentifier("0.4.0.127.0.7.3.1.4.1");
        if (this.templates.containsKey(reqOID)) {
            DiscretionaryDataTemplate t = this.templates.get(reqOID);
            return this.convertDate(t.getDiscretionaryData());
        }
        return null;
    }

    public Calendar getDocumentValidityVerificationData() {
        ASN1ObjectIdentifier reqOID = new ASN1ObjectIdentifier("0.4.0.127.0.7.3.1.4.2");
        if (this.templates.containsKey(reqOID)) {
            DiscretionaryDataTemplate t = this.templates.get(reqOID);
            return this.convertDate(t.getDiscretionaryData());
        }
        return null;
    }

    public byte[] getCommunityIDVerificationData() {
        ASN1ObjectIdentifier reqOID = new ASN1ObjectIdentifier("0.4.0.127.0.7.3.1.4.3");
        if (this.templates.containsKey(reqOID)) {
            DiscretionaryDataTemplate t = this.templates.get(reqOID);
            return ByteUtils.clone(t.getDiscretionaryData());
        }
        return null;
    }

    private Calendar convertDate(byte[] discretionaryData) {
        if (discretionaryData.length != 8) {
            throw new IllegalArgumentException("Given value in discretionary data does not represent a date.");
        }
        String yearStr = new String(Arrays.copyOfRange(discretionaryData, 0, 4));
        int year = Integer.parseInt(yearStr);
        String monthStr = new String(Arrays.copyOfRange(discretionaryData, 4, 6));
        int month = Integer.parseInt(monthStr);
        String dayStr = new String(Arrays.copyOfRange(discretionaryData, 6, 8));
        int day = Integer.parseInt(dayStr);
        Calendar c = Calendar.getInstance();
        c.set(year, month, day);
        return c;
    }
}

