/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.crypto.common.asn1.cvc;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.List;
import org.openecard.common.tlv.TLV;
import org.openecard.common.util.ByteUtils;
import org.openecard.crypto.common.asn1.cvc.CardVerifiableCertificate;
import org.openecard.crypto.common.asn1.cvc.CertificateDescription;
import org.openecard.crypto.common.asn1.utils.ObjectIdentifierUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CardVerifiableCertificateVerifier {
    private static final Logger _logger = LoggerFactory.getLogger(CardVerifiableCertificateVerifier.class);

    public static void verify(CardVerifiableCertificate certificate, CertificateDescription description) throws CertificateException {
        try {
            byte[] extentions = certificate.getExtensions();
            TLV extentionObject = TLV.fromBER(extentions);
            List<TLV> list = extentionObject.asList();
            for (TLV item : list) {
                TLV hashObject;
                String oid = ObjectIdentifierUtils.toString(item.getValue());
                if (oid.equals("0.4.0.127.0.7.3.1.3.1")) {
                    List<TLV> hashObjects = item.findChildTags(128L);
                    if (hashObjects == null || hashObjects.isEmpty()) continue;
                    hashObject = hashObjects.get(0);
                    MessageDigest md = CardVerifiableCertificateVerifier.selectDigest(certificate.getPublicKey().getObjectIdentifier());
                    byte[] hash = md.digest(description.getEncoded());
                    if (ByteUtils.compare(hash, hashObject.getValue())) continue;
                    throw new CertificateException("The checksum of the certificate description cannot be verified!");
                }
                if (oid.equals("0.4.0.127.0.7.3.1.3.2")) {
                    List<TLV> secondPublicKeyObjects;
                    List<TLV> firstPublicKeyObjects = item.findChildTags(128L);
                    if (firstPublicKeyObjects != null && !firstPublicKeyObjects.isEmpty()) {
                        hashObject = firstPublicKeyObjects.get(0);
                    }
                    if ((secondPublicKeyObjects = item.findChildTags(129L)) == null || secondPublicKeyObjects.isEmpty()) continue;
                    TLV tLV = secondPublicKeyObjects.get(0);
                    continue;
                }
                _logger.warn("Unknown OID: {} ", (Object)oid);
            }
        }
        catch (Exception e) {
            _logger.debug(e.getMessage());
            throw new CertificateException("Verification failed", e);
        }
    }

    public static void checkDate(CardVerifiableCertificate certificate) throws CertificateException {
        Date systemDate = new Date();
        Date expDate = certificate.getExpirationDate().getTime();
        Date effDate = certificate.getEffectiveDate().getTime();
        if (systemDate.after(expDate) || systemDate.before(effDate)) {
            String msg = "CV Certificate's validity date is different than the current date.";
            throw new CertificateException(msg);
        }
    }

    private static MessageDigest selectDigest(String oid) throws NoSuchAlgorithmException {
        if (oid.equals("0.4.0.127.0.7.2.2.2.2.1") || oid.equals("0.4.0.127.0.7.2.2.2.1.3") || oid.equals("0.4.0.127.0.7.2.2.2.1.1")) {
            return MessageDigest.getInstance("SHA-1");
        }
        if (oid.equals("0.4.0.127.0.7.2.2.2.2.2")) {
            return MessageDigest.getInstance("SHA-224");
        }
        if (oid.equals("0.4.0.127.0.7.2.2.2.2.3") || oid.equals("0.4.0.127.0.7.2.2.2.1.4") || oid.equals("0.4.0.127.0.7.2.2.2.1.4")) {
            return MessageDigest.getInstance("SHA-256");
        }
        if (oid.equals("0.4.0.127.0.7.2.2.2.2.4") || oid.equals("0.4.0.127.0.7.2.2.2.1.3") || oid.equals("0.4.0.127.0.7.2.2.2.1.3")) {
            return MessageDigest.getInstance("SHA-384");
        }
        if (oid.equals("0.4.0.127.0.7.2.2.2.2.5") || oid.equals("0.4.0.127.0.7.2.2.2.1.6") || oid.equals("0.4.0.127.0.7.2.2.2.1.6")) {
            return MessageDigest.getInstance("SHA-512");
        }
        throw new NoSuchAlgorithmException();
    }
}

